/*
 * Decompiled with CFR 0.152.
 */
package edivad.extrastorage.nodes;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.SlottedCraftingRequest;
import com.refinedmods.refinedstorage.inventory.fluid.FluidInventory;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeFluidInventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import edivad.extrastorage.tiles.AdvancedExporterTile;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class AdvancedExporterNetworkNode
extends NetworkNode
implements IComparable,
IType {
    public static final ResourceLocation ID = new ResourceLocation("extrastorage", "advanced_exporter");
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilters";
    private static final int SLOTS = 18;
    private final BaseItemHandler itemFilters = new BaseItemHandler(18).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));
    private final FluidInventory fluidFilters = new FluidInventory(18).addListener((InventoryListener)new NetworkNodeFluidInventoryListener((INetworkNode)this));
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, new UpgradeItem.Type[]{UpgradeItem.Type.SPEED, UpgradeItem.Type.CRAFTING, UpgradeItem.Type.STACK, UpgradeItem.Type.REGULATOR}).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
        if (!reading && !this.getUpgrades().hasUpgrade(UpgradeItem.Type.REGULATOR)) {
            boolean changed = false;
            for (int i = 0; i < 18; ++i) {
                FluidStack filteredFluid;
                ItemStack filteredItem = this.itemFilters.getStackInSlot(i);
                if (filteredItem.func_190916_E() > 1) {
                    filteredItem.func_190920_e(1);
                    changed = true;
                }
                if ((filteredFluid = this.fluidFilters.getFluid(i)).isEmpty() || filteredFluid.getAmount() == 1000) continue;
                filteredFluid.setAmount(1000);
                changed = true;
            }
            if (changed) {
                this.markDirty();
            }
        }
    });
    private int compare = 1;
    private int type = 0;
    private int filterSlot;

    public AdvancedExporterNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    public int getEnergyUsage() {
        return 4 * (RS.SERVER_CONFIG.getExporter().getUsage() + this.upgrades.getEnergyUsage());
    }

    public void update() {
        super.update();
        if (this.canUpdate() && this.ticks % this.upgrades.getSpeed() == 0 && this.world.func_195588_v(this.pos)) {
            if (this.type == 0) {
                IItemHandler handler = WorldUtils.getItemHandler((TileEntity)this.getFacingTile(), (Direction)this.getDirection().func_176734_d());
                if (handler != null) {
                    ItemStack slot;
                    int handlerSlots = handler.getSlots();
                    while (this.filterSlot + 1 < 18 && this.itemFilters.getStackInSlot(this.filterSlot).func_190926_b()) {
                        ++this.filterSlot;
                    }
                    if (this.filterSlot == 17 && this.itemFilters.getStackInSlot(this.filterSlot).func_190926_b() || this.filterSlot >= 18) {
                        this.filterSlot = 0;
                    }
                    if (!(slot = this.itemFilters.getStackInSlot(this.filterSlot)).func_190926_b()) {
                        int stackSize = this.upgrades.getStackInteractCount();
                        if (this.upgrades.hasUpgrade(UpgradeItem.Type.REGULATOR)) {
                            int found = 0;
                            for (int i = 0; i < handlerSlots; ++i) {
                                ItemStack stackInConnectedHandler = handler.getStackInSlot(i);
                                if (!API.instance().getComparer().isEqual(slot, stackInConnectedHandler, this.compare)) continue;
                                found += stackInConnectedHandler.func_190916_E();
                            }
                            int needed = 0;
                            for (int i = 0; i < 18; ++i) {
                                if (!API.instance().getComparer().isEqualNoQuantity(slot, this.itemFilters.getStackInSlot(i))) continue;
                                needed += this.itemFilters.getStackInSlot(i).func_190916_E();
                            }
                            stackSize = Math.min(stackSize, needed - found);
                        }
                        if (stackSize > 0) {
                            ItemStack took = this.network.extractItem(slot, Math.min(slot.func_77976_d(), stackSize), this.compare, Action.SIMULATE);
                            if (took.func_190926_b()) {
                                if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                                    this.network.getCraftingManager().request((Object)new SlottedCraftingRequest((INetworkNode)this, this.filterSlot), slot, stackSize);
                                }
                            } else {
                                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)true);
                                int correctedStackSize = took.func_190916_E() - remainder.func_190916_E();
                                if (correctedStackSize > 0) {
                                    took = this.network.extractItem(slot, correctedStackSize, this.compare, Action.PERFORM);
                                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)took, (boolean)false);
                                }
                            }
                        }
                    }
                    ++this.filterSlot;
                }
            } else if (this.type == 1) {
                IFluidHandler handler;
                FluidStack[] fluids = this.fluidFilters.getFluids();
                while (this.filterSlot + 1 < fluids.length && fluids[this.filterSlot] == null) {
                    ++this.filterSlot;
                }
                if (this.filterSlot == fluids.length - 1 && fluids[this.filterSlot] == null || this.filterSlot >= fluids.length) {
                    this.filterSlot = 0;
                }
                if ((handler = WorldUtils.getFluidHandler((TileEntity)this.getFacingTile(), (Direction)this.getDirection().func_176734_d())) != null) {
                    FluidStack stack = fluids[this.filterSlot];
                    if (stack != null) {
                        int toExtract = 1000 * this.upgrades.getStackInteractCount();
                        FluidStack stackInStorage = (FluidStack)this.network.getFluidStorageCache().getList().get((Object)stack, this.compare);
                        if (stackInStorage != null) {
                            FluidStack took;
                            int filled;
                            toExtract = Math.min(toExtract, stackInStorage.getAmount());
                            if (this.upgrades.hasUpgrade(UpgradeItem.Type.REGULATOR)) {
                                int found = 0;
                                for (int i = 0; i < handler.getTanks(); ++i) {
                                    FluidStack stackInConnectedHandler = handler.getFluidInTank(i);
                                    if (!API.instance().getComparer().isEqual(stack, stackInConnectedHandler, this.compare)) continue;
                                    found += stackInConnectedHandler.getAmount();
                                }
                                int needed = 0;
                                for (int i = 0; i < 18; ++i) {
                                    if (!API.instance().getComparer().isEqual(stack, this.fluidFilters.getFluid(i), 1)) continue;
                                    needed += this.fluidFilters.getFluid(i).getAmount();
                                }
                                toExtract = Math.min(toExtract, needed - found);
                            }
                            if (toExtract > 0 && (filled = handler.fill(took = this.network.extractFluid(stack, toExtract, this.compare, Action.SIMULATE), IFluidHandler.FluidAction.SIMULATE)) > 0) {
                                took = this.network.extractFluid(stack, filled, this.compare, Action.PERFORM);
                                handler.fill(took, IFluidHandler.FluidAction.EXECUTE);
                            }
                        } else if (this.upgrades.hasUpgrade(UpgradeItem.Type.CRAFTING)) {
                            this.network.getCraftingManager().request((Object)this, stack, toExtract);
                        }
                    }
                    ++this.filterSlot;
                }
            }
        }
    }

    public int getCompare() {
        return this.compare;
    }

    public void setCompare(int compare) {
        this.compare = compare;
        this.markDirty();
    }

    public ResourceLocation getId() {
        return ID;
    }

    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
        return tag;
    }

    public CompoundNBT writeConfiguration(CompoundNBT tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        tag.func_218657_a(NBT_FLUID_FILTERS, (INBT)this.fluidFilters.writeToNbt());
        return tag;
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)1, (CompoundNBT)tag);
    }

    public void readConfiguration(CompoundNBT tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems((BaseItemHandler)this.itemFilters, (int)0, (CompoundNBT)tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilters.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    public IItemHandler getDrops() {
        return this.getUpgrades();
    }

    public int getType() {
        return this.world.field_72995_K ? (Integer)AdvancedExporterTile.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilters;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilters;
    }
}

