/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.block;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.darkhax.bookshelf.crafting.block.BlockIngredient;
import net.darkhax.bookshelf.crafting.block.IBlockIngredientSerializer;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class BlockIngredientCheckBlock
extends BlockIngredient {
    public static final ResourceLocation ID = new ResourceLocation("bookshelf", "check_block");
    public static final Serializer SERIALIZER = new Serializer();
    private final List<Block> blocks;
    private List<BlockState> cache;

    public BlockIngredientCheckBlock(List<Block> blocks) {
        this.blocks = blocks;
    }

    @Override
    public boolean test(BlockState t) {
        this.buildCache();
        return this.cache.contains(t);
    }

    @Override
    public Collection<BlockState> getValidStates() {
        this.buildCache();
        return this.cache;
    }

    @Override
    public ResourceLocation getSerializeId() {
        return ID;
    }

    private void buildCache() {
        if (this.cache == null) {
            this.cache = new ArrayList<BlockState>();
            for (Block block : this.blocks) {
                block.func_176194_O().func_177619_a().forEach(this.cache::add);
            }
        }
    }

    static class Serializer
    implements IBlockIngredientSerializer<BlockIngredientCheckBlock> {
        Serializer() {
        }

        @Override
        public BlockIngredientCheckBlock read(JsonElement json) {
            List<Block> states = Serializers.BLOCK.readList(json.getAsJsonObject(), "block");
            return new BlockIngredientCheckBlock(states);
        }

        @Override
        public JsonElement write(BlockIngredientCheckBlock ingredient) {
            JsonObject obj = new JsonObject();
            obj.add("block", Serializers.BLOCK.writeList(ingredient.blocks));
            return obj;
        }

        @Override
        public BlockIngredientCheckBlock read(PacketBuffer buf) {
            List<Block> states = Serializers.BLOCK.readList(buf);
            return new BlockIngredientCheckBlock(states);
        }

        @Override
        public void write(PacketBuffer buf, BlockIngredientCheckBlock ingredient) {
            Serializers.BLOCK.writeList(buf, ingredient.blocks);
        }
    }
}

