/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.layout.blocks;

import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.layout.AbsolutePattern;
import ipsis.woot.modules.factory.layout.PatternRepository;
import ipsis.woot.modules.layout.LayoutSetup;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class LayoutTileEntity
extends TileEntity {
    private static final int LAYOUT_Y_OFFSET = 1;
    AbsolutePattern absolutePattern = null;
    Tier tier = Tier.TIER_1;
    int level = -1;
    static final String KEY_LEVEL = "level";
    static final String KEY_TIER = "tier";

    public LayoutTileEntity() {
        super((TileEntityType)LayoutSetup.LAYOUT_BLOCK_TILE.get());
    }

    public int getLevel() {
        return this.level;
    }

    public int setNextLevel() {
        ++this.level;
        if (this.level >= PatternRepository.get().getPattern(this.tier).getHeight()) {
            this.level = -1;
        }
        this.func_70296_d();
        this.refresh();
        return this.level;
    }

    public int getYForLevel() {
        int height = PatternRepository.get().getPattern(this.tier).getHeight();
        return this.func_174877_v().func_177956_o() - height - 1 + this.level + 2;
    }

    public Tier getTier() {
        return this.tier;
    }

    public Tier setNextTier() {
        this.tier = this.tier.getNextValid();
        this.func_70296_d();
        this.refresh();
        return this.tier;
    }

    public void refresh() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPos origin = this.func_174877_v().func_177979_c(1);
        this.absolutePattern = AbsolutePattern.create(this.field_145850_b, this.tier, origin, (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)BlockStateProperties.field_208157_J));
    }

    public AbsolutePattern getAbsolutePattern() {
        return this.absolutePattern;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos pos = this.func_174877_v();
        return new AxisAlignedBB(pos.func_177982_a(-PatternRepository.get().getMaxXZOffset(), -1, -PatternRepository.get().getMaxXZOffset()), pos.func_177982_a(PatternRepository.get().getMaxXZOffset(), PatternRepository.get().getMaxYOffset() - 1, PatternRepository.get().getMaxXZOffset()));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compoundNBT = this.func_189517_E_();
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, compoundNBT);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.deserializeNBT(pkt.func_148857_g());
        this.refresh();
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compoundNBT = super.func_189517_E_();
        this.func_189515_b(compoundNBT);
        return compoundNBT;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.deserializeNBT(tag);
        this.refresh();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a(KEY_LEVEL, this.level);
        compound.func_74768_a(KEY_TIER, this.tier.ordinal());
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.readFromNBT(compound);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compoundNBT) {
        super.func_230337_a_(blockState, compoundNBT);
        this.readFromNBT(compoundNBT);
    }

    private void readFromNBT(CompoundNBT compound) {
        this.level = MathHelper.func_76125_a((int)compound.func_74762_e(KEY_LEVEL), (int)-1, (int)16);
        this.tier = Tier.byIndex(compound.func_74762_e(KEY_TIER));
    }
}

