/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.items;

import ipsis.woot.Woot;
import ipsis.woot.modules.factory.FactorySetup;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;

public class XpShardBaseItem
extends Item {
    public static final String SHARD_REGNAME = "xpshard";
    public static final String SPLINTER_REGNAME = "xpsplinter";
    private static final int STACK_SIZE = 64;
    public static final int SPLINTERS_IN_STACK = 9;
    private static final int SHARD_XP = 9;
    private static final int SPLINTER_XP = 1;
    final Variant variant;

    public XpShardBaseItem(Variant variant) {
        super(new Item.Properties().func_200917_a(64).func_200916_a(Woot.setup.getCreativeTab()));
        this.variant = variant;
    }

    public Variant getVariant() {
        return this.variant;
    }

    public static ItemStack getItemStack(Variant variant) {
        if (variant == Variant.SHARD) {
            return new ItemStack((IItemProvider)FactorySetup.XP_SHARD_ITEM.get());
        }
        return new ItemStack((IItemProvider)FactorySetup.XP_SPLINTER_ITEM.get());
    }

    public static List<ItemStack> getShards(int xp) {
        ArrayList<ItemStack> shards = new ArrayList<ItemStack>();
        int xpShards = xp / 9;
        int xpSplinters = xp % 9;
        int fullStacks = xpShards / 64;
        int leftoverShard = xpShards % 64;
        Woot.setup.getLogger().debug("getShards: xp {} xpShards {} xpSplinters {} fullStacks {} leftoverShards {}", (Object)xp, (Object)xpShards, (Object)xpSplinters, (Object)fullStacks, (Object)leftoverShard);
        for (int i = 0; i < fullStacks; ++i) {
            ItemStack itemStack = XpShardBaseItem.getItemStack(Variant.SHARD);
            itemStack.func_190920_e(64);
            shards.add(itemStack);
        }
        if (leftoverShard > 0) {
            ItemStack itemStack = XpShardBaseItem.getItemStack(Variant.SHARD);
            itemStack.func_190920_e(leftoverShard);
            shards.add(itemStack);
        }
        if (xpSplinters > 0) {
            ItemStack itemStack = XpShardBaseItem.getItemStack(Variant.SPLINTER);
            itemStack.func_190920_e(xpSplinters);
            shards.add(itemStack);
        }
        return shards;
    }

    private int getXp(ItemStack itemStack) {
        if (itemStack.func_77973_b() == FactorySetup.XP_SHARD_ITEM.get()) {
            return 9;
        }
        if (itemStack.func_77973_b() == FactorySetup.XP_SPLINTER_ITEM.get()) {
            return 1;
        }
        return 0;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (worldIn.field_72995_K) {
            return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
        }
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        if (itemStack.func_190926_b()) {
            return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
        }
        ItemStack advancementStack = itemStack.func_77946_l();
        worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.5f * ((field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.7f + 1.8f));
        if (playerIn instanceof FakePlayer) {
            worldIn.func_217376_c((Entity)new ExperienceOrbEntity(worldIn, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), 1));
            itemStack.func_190918_g(1);
        } else {
            int xp = 0;
            if (playerIn.func_225608_bj_()) {
                xp = this.getXp(itemStack) * itemStack.func_190916_E();
                if (!playerIn.func_184812_l_()) {
                    itemStack.func_190920_e(0);
                }
            } else {
                xp = this.getXp(itemStack);
                if (!playerIn.func_184812_l_()) {
                    itemStack.func_190918_g(1);
                }
            }
            if (xp > 0) {
                playerIn.func_195068_e(xp);
                if (playerIn instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)playerIn, advancementStack);
                }
            }
        }
        return ActionResult.func_226248_a_((Object)itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.shard.0"));
        tooltip.add((ITextComponent)new TranslationTextComponent("info.woot.shard.1"));
    }

    public static enum Variant {
        SHARD,
        SPLINTER;

    }
}

