/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ipsis.woot.Woot;
import ipsis.woot.crafting.DyeSqueezerRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DyeSqueezerRecipeSerializer<T extends DyeSqueezerRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final IFactory<T> factory;

    public DyeSqueezerRecipeSerializer(IFactory<T> factory) {
        this.factory = factory;
    }

    @Nullable
    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        try {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int energy = buffer.readInt();
            int red = buffer.readInt();
            int yellow = buffer.readInt();
            int blue = buffer.readInt();
            int white = buffer.readInt();
            return this.factory.create(recipeId, ingredient, energy, red, yellow, blue, white);
        }
        catch (Exception e) {
            Woot.setup.getLogger().error("DyeSqueezerRecipeSerializer:read", (Throwable)e);
            throw e;
        }
    }

    public void write(PacketBuffer buffer, T recipe) {
        try {
            ((DyeSqueezerRecipe)recipe).getIngredient().func_199564_a(buffer);
            buffer.writeInt(((DyeSqueezerRecipe)recipe).getEnergy());
            buffer.writeInt(((DyeSqueezerRecipe)recipe).getRed());
            buffer.writeInt(((DyeSqueezerRecipe)recipe).getYellow());
            buffer.writeInt(((DyeSqueezerRecipe)recipe).getBlue());
            buffer.writeInt(((DyeSqueezerRecipe)recipe).getWhite());
        }
        catch (Exception e) {
            Woot.setup.getLogger().error("DyeSqueezerRecipeSerializer:write", (Throwable)e);
            throw e;
        }
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
        int energy = JSONUtils.func_151208_a((JsonObject)json, (String)"energy", (int)100);
        int red = JSONUtils.func_151208_a((JsonObject)json, (String)"red", (int)0);
        int yellow = JSONUtils.func_151208_a((JsonObject)json, (String)"yellow", (int)0);
        int blue = JSONUtils.func_151208_a((JsonObject)json, (String)"blue", (int)0);
        int white = JSONUtils.func_151208_a((JsonObject)json, (String)"white", (int)0);
        return this.factory.create(recipeId, ingredient, energy, red, yellow, blue, white);
    }

    public static interface IFactory<T extends DyeSqueezerRecipe> {
        public T create(ResourceLocation var1, Ingredient var2, int var3, int var4, int var5, int var6, int var7);
    }
}

