/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network;

import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Iterator;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.datastructure.MultitransformIterator;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMapMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollectionPrototypeMap;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashMap;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientPositionsIndex;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PrioritizedPartPos;

public class IngredientPositionsIndex<T, M>
implements IIngredientPositionsIndex<T, M> {
    private final IngredientComponent<T, M> component;
    private final AbstractInt2ObjectSortedMap<IIngredientMapMutable<T, M, ObjectOpenHashSet<PartPos>>> prioritizedPositionsMap;
    private final AbstractInt2ObjectSortedMap<IngredientCollectionPrototypeMap<T, M>> ingredientInstances;

    public IngredientPositionsIndex(IngredientComponent<T, M> component) {
        this.component = component;
        this.prioritizedPositionsMap = new Int2ObjectAVLTreeMap();
        this.ingredientInstances = new Int2ObjectAVLTreeMap();
    }

    protected T getPrototype(T instance) {
        return (T)this.getComponent().getMatcher().withQuantity(instance, 1L);
    }

    protected int getInternalPriority(PrioritizedPartPos pos) {
        return -pos.getPriority();
    }

    @Override
    public Iterator<PartPos> getNonEmptyPositions() {
        return this.getPositions(this.getComponent().getMatcher().getEmptyInstance(), this.getComponent().getMatcher().getAnyMatchCondition());
    }

    @Override
    public Iterator<PartPos> getPositions(T instance, M matchFlags) {
        return this.prioritizedPositionsMap.values().stream().flatMap(ingredientCollection -> ingredientCollection.getAll(this.getPrototype(instance), matchFlags).stream()).flatMap(Collection::stream).iterator();
    }

    @Override
    public void addPosition(T instance, PrioritizedPartPos pos) {
        T prototype;
        ObjectOpenHashSet set;
        IIngredientMapMutable positionsMap = (IIngredientMapMutable)this.prioritizedPositionsMap.get(this.getInternalPriority(pos));
        if (positionsMap == null) {
            positionsMap = new IngredientHashMap(this.getComponent());
            this.prioritizedPositionsMap.put(this.getInternalPriority(pos), (Object)positionsMap);
        }
        if ((set = (ObjectOpenHashSet)positionsMap.get(prototype = this.getPrototype(instance))) == null) {
            set = new ObjectOpenHashSet();
            positionsMap.put(prototype, (Object)set);
        }
        set.add((Object)pos.getPartPos());
    }

    @Override
    public void removePosition(T instance, PrioritizedPartPos pos) {
        T prototype;
        ObjectOpenHashSet set;
        IIngredientMapMutable positionsMap = (IIngredientMapMutable)this.prioritizedPositionsMap.get(this.getInternalPriority(pos));
        if (positionsMap != null && (set = (ObjectOpenHashSet)positionsMap.get(prototype = this.getPrototype(instance))) != null) {
            set.remove((Object)pos.getPartPos());
            if (set.isEmpty()) {
                positionsMap.remove(prototype);
                if (positionsMap.isEmpty()) {
                    this.prioritizedPositionsMap.remove(this.getInternalPriority(pos));
                }
            }
        }
    }

    @Override
    public long getQuantity(T instance) {
        return this.ingredientInstances.values().stream().mapToLong(ingredients -> ingredients.getQuantity(instance)).sum();
    }

    public IngredientComponent<T, M> getComponent() {
        return this.component;
    }

    public int size() {
        return this.ingredientInstances.values().stream().mapToInt(IngredientCollectionPrototypeMap::size).sum();
    }

    public boolean contains(T instance) {
        return this.ingredientInstances.values().stream().anyMatch(ingredients -> ingredients.contains(instance));
    }

    public boolean contains(T instance, M matchCondition) {
        return this.ingredientInstances.values().stream().anyMatch(ingredients -> ingredients.contains(instance, matchCondition));
    }

    public int count(T instance, M matchCondition) {
        return this.ingredientInstances.values().stream().mapToInt(ingredients -> ingredients.count(instance, matchCondition)).sum();
    }

    public Iterator<T> iterator(T instance, M matchCondition) {
        return new MultitransformIterator((Iterator)this.ingredientInstances.values().iterator(), ingredients -> ingredients.iterator(instance, matchCondition));
    }

    public Iterator<T> iterator() {
        return new MultitransformIterator((Iterator)this.ingredientInstances.values().iterator(), IngredientCollectionPrototypeMap::iterator);
    }

    public void removeAll(PrioritizedPartPos pos, Iterable<? extends T> instances) {
        IngredientCollectionPrototypeMap ingredients = (IngredientCollectionPrototypeMap)this.ingredientInstances.get(this.getInternalPriority(pos));
        if (ingredients != null) {
            ingredients.removeAll(instances);
            if (ingredients.isEmpty()) {
                this.ingredientInstances.remove(this.getInternalPriority(pos));
            }
        }
    }

    public void addAll(PrioritizedPartPos pos, Iterable<? extends T> instances) {
        IngredientCollectionPrototypeMap ingredients = (IngredientCollectionPrototypeMap)this.ingredientInstances.get(this.getInternalPriority(pos));
        if (ingredients == null) {
            ingredients = new IngredientCollectionPrototypeMap(this.component, false);
            this.ingredientInstances.put(this.getInternalPriority(pos), (Object)ingredients);
        }
        ingredients.addAll(instances);
    }
}

