/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.item.IAspectVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.item.AspectVariableFacade;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class ContainerMultipartAspects<P extends IPartType<P, S>, S extends IPartState<P>, A extends IAspect>
extends ScrollingInventoryContainer<A>
implements IDirtyMarkListener {
    public static String BUTTON_SETTINGS = "button_settings";
    private static final int PAGE_SIZE = 3;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final P partType;
    private final World world;
    private final Map<IAspect, String> aspectPropertyButtons = Maps.newHashMap();
    protected final IInventory inputSlots;

    public ContainerMultipartAspects(@Nullable ContainerType<?> type, int id, PlayerInventory playerInventory, IInventory inventory, PartTarget target, Optional<IPartContainer> partContainer, P partType, List<A> items) {
        super(type, id, playerInventory, inventory, items, (item, pattern) -> pattern.matcher(L10NHelpers.localize((String)item.getTranslationKey(), (Object[])new Object[0]).toLowerCase(Locale.ENGLISH)).matches());
        this.target = target;
        this.partContainer = partContainer.orElseGet(() -> PartHelpers.getPartContainerChecked(target.getCenter()));
        this.partType = partType;
        this.world = this.player.func_130014_f_();
        this.inputSlots = this.constructInputSlotsInventory();
        this.putButtonAction(BUTTON_SETTINGS, (s, containerExtended) -> {
            if (!this.world.func_201670_d()) {
                PartHelpers.openContainerPartSettings((ServerPlayerEntity)this.player, target.getCenter(), partType);
            }
        });
        for (IAspect aspect : this.getUnfilteredItems()) {
            if (!aspect.hasProperties()) continue;
            String buttonId = "button_aspect_" + aspect.getUniqueName();
            this.aspectPropertyButtons.put(aspect, buttonId);
            this.putButtonAction(buttonId, (s, containerExtended) -> {
                if (!this.world.func_201670_d()) {
                    PartHelpers.openContainerAspectSettings((ServerPlayerEntity)this.player, target.getCenter(), aspect);
                }
            });
        }
    }

    public P getPartType() {
        return this.partType;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public IPartContainer getPartContainer() {
        return this.partContainer;
    }

    public S getPartState() {
        return (S)this.partContainer.getPartState(this.getTarget().getCenter().getSide());
    }

    public Map<IAspect, String> getAspectPropertyButtons() {
        return Collections.unmodifiableMap(this.aspectPropertyButtons);
    }

    public abstract int getAspectBoxHeight();

    protected IInventory constructInputSlotsInventory() {
        SimpleInventory inventory = new SimpleInventory(this.getUnfilteredItemCount(), 1);
        inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        return inventory;
    }

    public void func_75134_a(PlayerEntity player) {
        if (this.inputSlots instanceof SimpleInventory) {
            ((SimpleInventory)this.inputSlots).removeDirtyMarkListener((IDirtyMarkListener)this);
        }
    }

    protected void disableSlot(int slotIndex) {
        Slot slot = this.func_75139_a(slotIndex);
        ContainerMultipartAspects.setSlotPosX((Slot)slot, (int)Integer.MIN_VALUE);
        ContainerMultipartAspects.setSlotPosY((Slot)slot, (int)Integer.MIN_VALUE);
    }

    protected abstract void enableSlot(int var1, int var2);

    public int getPageSize() {
        return 3;
    }

    public void onScroll(int firstRow) {
        for (int i = 0; i < this.getUnfilteredItemCount(); ++i) {
            this.disableSlot(i);
        }
        super.onScroll(firstRow);
    }

    protected void enableElementAt(int row, int elementIndex, A element) {
        super.enableElementAt(row, elementIndex, element);
        this.enableSlot(elementIndex, row);
    }

    public boolean func_75145_c(PlayerEntity player) {
        return PartHelpers.canInteractWith(this.getTarget(), player, this.partContainer);
    }

    public ItemStack writeAspectInfo(boolean generateId, ItemStack itemStack, final IAspect aspect) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(generateId, itemStack, Aspects.REGISTRY, new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IAspectVariableFacade>(){

            @Override
            public IAspectVariableFacade create(boolean generateId) {
                return new AspectVariableFacade(generateId, ContainerMultipartAspects.this.getPartState().getId(), aspect);
            }

            @Override
            public IAspectVariableFacade create(int id) {
                return new AspectVariableFacade(id, ContainerMultipartAspects.this.getPartState().getId(), aspect);
            }
        }, null, null);
    }
}

