/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.data.Model3D;
import com.lothrazar.cyclic.render.FluidRenderMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class UtilFluid {
    public static final FluidRenderMap<Int2ObjectMap<Model3D>> CACHED_FLUIDS = new FluidRenderMap();
    public static final int STAGES = 1400;

    public static TextureAtlasSprite getBaseFluidTexture(Fluid fluid, FluidRenderMap.FluidType type) {
        FluidAttributes fluidAttributes = fluid.getAttributes();
        ResourceLocation spriteLocation = type == FluidRenderMap.FluidType.STILL ? fluidAttributes.getStillTexture() : fluidAttributes.getFlowingTexture();
        return UtilFluid.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(spriteLocation);
    }

    public static Model3D getFluidModel(FluidStack fluid, int stage) {
        Int2ObjectMap fluidCache = (Int2ObjectMap)CACHED_FLUIDS.computeIfAbsent(fluid, fluidStack -> new Int2ObjectOpenHashMap());
        Model3D model = (Model3D)fluidCache.get(stage);
        if (model != null) {
            return model;
        }
        model = new Model3D();
        model.setTexture(FluidRenderMap.getFluidTexture(fluid, FluidRenderMap.FluidType.STILL));
        if (fluid.getFluid().getAttributes().getStillTexture(fluid) != null) {
            double sideSpacing = 0.00625;
            double belowSpacing = 0.015625;
            model.minX = sideSpacing;
            model.minY = belowSpacing;
            model.minZ = sideSpacing;
            model.maxX = 1.0 - sideSpacing;
            model.maxY = 1.0 - belowSpacing;
            model.maxZ = 1.0 - sideSpacing;
        }
        fluidCache.put(stage, (Object)model);
        return model;
    }

    public static float getScale(FluidTank tank) {
        return UtilFluid.getScale(tank.getFluidAmount(), tank.getCapacity(), tank.isEmpty());
    }

    public static float getScale(int stored, int capacity, boolean empty) {
        return (float)stored / (float)capacity;
    }

    public static IFluidHandler getTank(World world, BlockPos pos, Direction side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return null;
        }
        return (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
    }

    public static boolean tryFillPositionFromTank(World world, BlockPos posSide, Direction sideOpp, IFluidHandler tankFrom, int amount) {
        if (amount <= 0) {
            return false;
        }
        if (tankFrom == null) {
            return false;
        }
        IFluidHandler fluidTo = (IFluidHandler)FluidUtil.getFluidHandler((World)world, (BlockPos)posSide, (Direction)sideOpp).orElse(null);
        if (fluidTo == null) {
            return false;
        }
        FluidStack toBeDrained = tankFrom.drain(amount, IFluidHandler.FluidAction.SIMULATE);
        if (toBeDrained.isEmpty()) {
            return false;
        }
        int filledAmount = fluidTo.fill(toBeDrained, IFluidHandler.FluidAction.EXECUTE);
        if (filledAmount <= 0) {
            return false;
        }
        FluidStack drained = tankFrom.drain(filledAmount, IFluidHandler.FluidAction.EXECUTE);
        int drainedAmount = drained.getAmount();
        if (filledAmount != drainedAmount) {
            ModCyclic.LOGGER.error("Imbalance filling fluids, filled " + filledAmount + " drained " + drainedAmount);
        }
        return true;
    }
}

