/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.fluid;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.fluid.ContainerCableFluid;
import com.lothrazar.cyclic.item.datacard.filter.FilterCardItem;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilDirection;
import com.lothrazar.cyclic.util.UtilFluid;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCableFluid
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    final ItemStackHandler filter = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == ItemRegistry.filter_data;
        }
    };
    public static final int CAPACITY = 16000;
    public static final int FLOW_RATE = 16000;
    public static final int EXTRACT_RATE = 16000;
    private final Map<Direction, LazyOptional<FluidTankBase>> flow = Maps.newHashMap();

    public TileCableFluid() {
        super(TileRegistry.fluid_pipeTile);
        for (Direction f : Direction.values()) {
            this.flow.put(f, (LazyOptional<FluidTankBase>)LazyOptional.of(() -> new FluidTankBase(this, 16000, p -> true)));
        }
    }

    public void func_73660_a() {
        for (Direction extractSide : Direction.values()) {
            EnumProperty<EnumConnectType> extractFace = CableBase.FACING_TO_PROPERTY_MAP.get(extractSide);
            EnumConnectType connection = (EnumConnectType)((Object)this.func_195044_w().func_177229_b(extractFace));
            if (!connection.isExtraction()) continue;
            this.tryExtract(extractSide);
        }
        this.normalFlow();
    }

    private void tryExtract(Direction extractSide) {
        Direction incomingSide;
        if (extractSide == null) {
            return;
        }
        BlockPos target = this.field_174879_c.func_177972_a(extractSide);
        IFluidHandler tank = UtilFluid.getTank(this.field_145850_b, target, incomingSide = extractSide.func_176734_d());
        if (tank != null && tank.getTanks() > 0 && !FilterCardItem.filterAllowsExtract(this.filter.getStackInSlot(0), tank.getFluidInTank(0))) {
            return;
        }
        if (UtilFluid.tryFillPositionFromTank(this.field_145850_b, this.field_174879_c, extractSide, tank, 16000)) {
            return;
        }
        FluidTankBase sideHandler = (FluidTankBase)((Object)this.flow.get(extractSide).orElse(null));
        if (sideHandler == null) {
            return;
        }
        if (sideHandler.getSpace() < 1000) {
            return;
        }
        BlockState targetState = this.field_145850_b.func_180495_p(target);
        if (targetState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && ((Boolean)targetState.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && this.field_145850_b.func_175656_a(target, (BlockState)targetState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)))) {
            FluidStack bucketAmountOfWater = new FluidStack((Fluid)Fluids.field_204546_a, 1000);
            int filledAmount = sideHandler.fill(bucketAmountOfWater, IFluidHandler.FluidAction.EXECUTE);
            if (filledAmount != bucketAmountOfWater.getAmount()) {
                ModCyclic.LOGGER.error("Imbalance filling water extracted from waterlogged block, filled " + filledAmount + " expected " + bucketAmountOfWater);
            }
            return;
        }
        FluidState fluidState = this.field_145850_b.func_204610_c(target);
        Fluid fluid = fluidState.func_206886_c();
        if (!fluid.func_207193_c(fluidState)) {
            return;
        }
        if (!this.field_145850_b.func_175656_a(target, Blocks.field_150350_a.func_176223_P())) {
            return;
        }
        FluidStack bucketAmountOfFluid = new FluidStack(fluid, 1000);
        int filledAmount = sideHandler.fill(bucketAmountOfFluid, IFluidHandler.FluidAction.EXECUTE);
        if (filledAmount != bucketAmountOfFluid.getAmount()) {
            ModCyclic.LOGGER.error("Incorrect amount of fluid extracted from fluid source, filled " + filledAmount + " expected " + bucketAmountOfFluid);
        }
    }

    private void normalFlow() {
        for (Direction incomingSide : Direction.values()) {
            IFluidHandler sideHandler = (IFluidHandler)this.flow.get(incomingSide).orElse(null);
            for (Direction outgoingSide : UtilDirection.getAllInDifferentOrder()) {
                if (outgoingSide == incomingSide) continue;
                EnumProperty<EnumConnectType> outgoingFace = CableBase.FACING_TO_PROPERTY_MAP.get(outgoingSide);
                EnumConnectType connection = (EnumConnectType)((Object)this.func_195044_w().func_177229_b(outgoingFace));
                if (connection.isExtraction() || connection.isBlocked()) continue;
                this.moveFluids(outgoingSide, this.field_174879_c.func_177972_a(outgoingSide), 16000, sideHandler);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (side != null && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && !CableBase.isCableBlocked(this.func_195044_w(), side)) {
            return this.flow.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.filter.deserializeNBT(tag.func_74775_l("filter"));
        for (Direction dir : Direction.values()) {
            FluidTankBase fluidh = (FluidTankBase)((Object)this.flow.get(dir).orElse(null));
            if (!tag.func_74764_b("fluid" + dir.toString())) continue;
            fluidh.readFromNBT(tag.func_74775_l("fluid" + dir.toString()));
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("filter", (INBT)this.filter.serializeNBT());
        for (Direction dir : Direction.values()) {
            FluidTankBase fluidh = (FluidTankBase)((Object)this.flow.get(dir).orElse(null));
            CompoundNBT fluidtag = new CompoundNBT();
            if (fluidh != null) {
                fluidh.writeToNBT(fluidtag);
            }
            tag.func_218657_a("fluid" + dir.toString(), (INBT)fluidtag);
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerCableFluid(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }
}

