/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.base;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.breaker.BlockBreaker;
import com.lothrazar.cyclic.block.cable.energy.TileCableEnergy;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.item.datacard.filter.FilterCardItem;
import com.lothrazar.cyclic.net.PacketEnergySync;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilDirection;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilFakePlayer;
import com.lothrazar.cyclic.util.UtilFluid;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityBase
extends TileEntity
implements IInventory {
    public static final String NBTINV = "inv";
    public static final String NBTFLUID = "fluid";
    public static final String NBTENERGY = "energy";
    public static final int MENERGY = 64000;
    protected int flowing = 1;
    protected int needsRedstone = 1;
    protected int render = 0;
    protected int timer = 0;

    public TileEntityBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public int getTimer() {
        return this.timer;
    }

    protected PlayerEntity getLookingPlayer(int maxRange, boolean mustCrouch) {
        List players = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - maxRange), (double)(this.field_174879_c.func_177956_o() - maxRange), (double)(this.field_174879_c.func_177952_p() - maxRange), (double)(this.field_174879_c.func_177958_n() + maxRange), (double)(this.field_174879_c.func_177956_o() + maxRange), (double)(this.field_174879_c.func_177952_p() + maxRange)));
        for (PlayerEntity player : players) {
            if (mustCrouch && !player.func_213453_ef()) continue;
            Vector3d positionEyes = player.func_174824_e(1.0f);
            Vector3d look = player.func_70676_i(1.0f);
            Vector3d visionWithLength = positionEyes.func_72441_c(look.field_72450_a * (double)maxRange, look.field_72448_b * (double)maxRange, look.field_72449_c * (double)maxRange);
            BlockRayTraceResult rayTrace = this.field_145850_b.func_217299_a(new RayTraceContext(positionEyes, visionWithLength, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
            if (!this.field_174879_c.equals((Object)rayTrace.func_216350_a())) continue;
            return player;
        }
        return null;
    }

    public void tryDumpFakePlayerInvo(WeakReference<FakePlayer> fp, boolean includeMainHand) {
        int start = includeMainHand ? 0 : 1;
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        for (int i = start; i < ((FakePlayer)fp.get()).field_71071_by.field_70462_a.size(); ++i) {
            ItemStack s = (ItemStack)((FakePlayer)fp.get()).field_71071_by.field_70462_a.get(i);
            if (s.func_190926_b()) continue;
            toDrop.add(s.func_77946_l());
            ((FakePlayer)fp.get()).field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
        }
        UtilItemStack.drop(this.field_145850_b, this.field_174879_c.func_177984_a(), toDrop);
    }

    public static void tryEquipItem(ItemStack item, WeakReference<FakePlayer> fp, Hand hand) {
        if (fp == null) {
            return;
        }
        ((FakePlayer)fp.get()).func_184611_a(hand, item);
    }

    public static void syncEquippedItem(LazyOptional<IItemHandler> i, WeakReference<FakePlayer> fp, int slot, Hand hand) {
        if (fp == null) {
            return;
        }
        i.ifPresent(inv -> {
            inv.extractItem(slot, 64, false);
            inv.insertItem(slot, ((FakePlayer)fp.get()).func_184586_b(hand), false);
        });
    }

    public static void tryEquipItem(LazyOptional<IItemHandler> i, WeakReference<FakePlayer> fp, int slot, Hand hand) {
        if (fp == null) {
            return;
        }
        i.ifPresent(inv -> {
            ItemStack maybeTool = inv.getStackInSlot(0);
            if (!maybeTool.func_190926_b() && maybeTool.func_190916_E() <= 0) {
                maybeTool = ItemStack.field_190927_a;
            }
            if (!maybeTool.equals(((FakePlayer)fp.get()).func_184586_b(hand))) {
                ((FakePlayer)fp.get()).func_184611_a(hand, maybeTool);
            }
        });
    }

    public static ActionResultType leftClickBlock(WeakReference<FakePlayer> fakePlayerWeakReference, BlockPos targetPos, Direction facing) {
        FakePlayer fakePlayer = (FakePlayer)fakePlayerWeakReference.get();
        if (fakePlayer == null) {
            return ActionResultType.FAIL;
        }
        Direction placementOn = facing == null ? fakePlayer.func_184172_bi() : facing;
        BlockRayTraceResult blockRayTraceResult = new BlockRayTraceResult(fakePlayer.func_70040_Z(), placementOn, targetPos, true);
        try {
            fakePlayer.field_71134_c.func_225416_a(blockRayTraceResult.func_216350_a(), CPlayerDiggingPacket.Action.START_DESTROY_BLOCK, facing, 0);
            return ActionResultType.SUCCESS;
        }
        catch (Exception e) {
            return ActionResultType.FAIL;
        }
    }

    public static ActionResultType rightClickBlock(WeakReference<FakePlayer> fakePlayer, World world, BlockPos targetPos, Hand hand, Direction facing) throws Exception {
        if (fakePlayer == null) {
            return ActionResultType.FAIL;
        }
        Direction placementOn = facing == null ? ((FakePlayer)fakePlayer.get()).func_184172_bi() : facing;
        BlockRayTraceResult blockraytraceresult = new BlockRayTraceResult(((FakePlayer)fakePlayer.get()).func_70040_Z(), placementOn, targetPos, true);
        ActionResultType result = ((FakePlayer)fakePlayer.get()).field_71134_c.func_219441_a((ServerPlayerEntity)fakePlayer.get(), world, ((FakePlayer)fakePlayer.get()).func_184586_b(hand), hand, blockraytraceresult);
        return result;
    }

    public static boolean tryHarvestBlock(WeakReference<FakePlayer> fakePlayer, World world, BlockPos targetPos) {
        if (fakePlayer == null) {
            return false;
        }
        return ((FakePlayer)fakePlayer.get()).field_71134_c.func_180237_b(targetPos);
    }

    public WeakReference<FakePlayer> setupBeforeTrigger(ServerWorld sw, String name, UUID uuid) {
        WeakReference<FakePlayer> fakePlayer = UtilFakePlayer.initFakePlayer(sw, uuid, name);
        if (fakePlayer == null) {
            ModCyclic.LOGGER.error("Fake player failed to init " + name + " " + uuid);
            return null;
        }
        ((FakePlayer)fakePlayer.get()).func_70107_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        ((FakePlayer)fakePlayer.get()).field_70177_z = UtilEntity.getYawFromFacing(this.getCurrentFacing());
        return fakePlayer;
    }

    public WeakReference<FakePlayer> setupBeforeTrigger(ServerWorld sw, String name) {
        return this.setupBeforeTrigger(sw, name, UUID.randomUUID());
    }

    public void setLitProperty(boolean lit) {
        BlockState st = this.func_195044_w();
        if (!st.func_235901_b_((Property)BlockBase.LIT)) {
            return;
        }
        boolean previous = (Boolean)st.func_177229_b((Property)BlockBreaker.LIT);
        if (previous != lit) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)st.func_206870_a((Property)BlockBreaker.LIT, (Comparable)Boolean.valueOf(lit)));
        }
    }

    public Direction getCurrentFacing() {
        if (this.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
            return (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        }
        if (this.func_195044_w().func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
            return (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208157_J);
        }
        return null;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT syncData = new CompoundNBT();
        this.func_189515_b(syncData);
        return syncData;
    }

    protected BlockPos getCurrentFacingPos(int distance) {
        Direction f = this.getCurrentFacing();
        if (f != null) {
            return this.field_174879_c.func_177967_a(f, distance);
        }
        return this.field_174879_c;
    }

    protected BlockPos getCurrentFacingPos() {
        return this.getCurrentFacingPos(1);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public boolean isPowered() {
        return this.func_145831_w().func_175640_z(this.func_174877_v());
    }

    public int getRedstonePower() {
        return this.func_145831_w().func_175687_A(this.func_174877_v());
    }

    public boolean requiresRedstone() {
        return this.needsRedstone == 1;
    }

    public void moveFluids(Direction myFacingDir, BlockPos posTarget, int toFlow, IFluidHandler tank) {
        if (tank == null || tank.getFluidInTank(0).isEmpty()) {
            return;
        }
        Direction themFacingMe = myFacingDir.func_176734_d();
        UtilFluid.tryFillPositionFromTank(this.field_145850_b, posTarget, themFacingMe, tank, toFlow);
    }

    public void tryExtract(IItemHandler myself, Direction extractSide, int qty, ItemStackHandler nullableFilter) {
        if (qty <= 0) {
            return;
        }
        ItemStack stackInSlot = myself.getStackInSlot(0);
        if (!stackInSlot.func_190926_b()) {
            return;
        }
        if (extractSide == null) {
            return;
        }
        BlockPos posTarget = this.field_174879_c.func_177972_a(extractSide);
        TileEntity tile = this.field_145850_b.func_175625_s(posTarget);
        if (tile == null) {
            return;
        }
        IItemHandler itemHandlerFrom = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, extractSide.func_176734_d()).orElse(null);
        if (itemHandlerFrom == null) {
            return;
        }
        int slotLimit = Math.min(myself.getSlotLimit(0), qty);
        for (int slot = 0; slot < itemHandlerFrom.getSlots(); ++slot) {
            ItemStack extractedItemStack;
            ItemStack itemStackToExtract = itemHandlerFrom.getStackInSlot(slot);
            if (itemStackToExtract.func_190926_b() || nullableFilter != null && !FilterCardItem.filterAllowsExtract(nullableFilter.getStackInSlot(0), itemStackToExtract)) continue;
            int limit = Math.min(itemStackToExtract.func_190916_E(), itemStackToExtract.func_77976_d());
            if ((limit = Math.min(limit, slotLimit)) <= 0 || (extractedItemStack = itemHandlerFrom.extractItem(slot, limit, false)).func_190926_b()) continue;
            ItemStack remainderItemStack = myself.insertItem(0, extractedItemStack, false);
            if (!remainderItemStack.func_190926_b()) {
                ModCyclic.LOGGER.error("Incorrect number of items extracted, have to re-insert " + remainderItemStack);
                remainderItemStack = itemHandlerFrom.insertItem(slot, remainderItemStack, false);
                if (!remainderItemStack.func_190926_b()) {
                    ModCyclic.LOGGER.error("Incorrect number of items extracted and now unable to re-insert, " + remainderItemStack + " have been lost");
                }
            }
            return;
        }
    }

    public boolean moveItems(Direction myFacingDir, int max, IItemHandler handlerHere) {
        return this.moveItems(myFacingDir, this.field_174879_c.func_177972_a(myFacingDir), max, handlerHere, 0);
    }

    public boolean moveItems(Direction myFacingDir, BlockPos posTarget, int max, IItemHandler handlerHere, int theslot) {
        ItemStack extractedItemStack;
        int insertedItemCount;
        boolean didInsertItems;
        int originalCount;
        if (max <= 0) {
            return false;
        }
        if (this.field_145850_b.func_201670_d()) {
            return false;
        }
        if (handlerHere == null) {
            return false;
        }
        ItemStack originalItemStack = handlerHere.getStackInSlot(theslot);
        if (originalItemStack.func_190926_b()) {
            return false;
        }
        Direction themFacingMe = myFacingDir.func_176734_d();
        TileEntity tileTarget = this.field_145850_b.func_175625_s(posTarget);
        if (tileTarget == null) {
            return false;
        }
        IItemHandler handlerOutput = (IItemHandler)tileTarget.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, themFacingMe).orElse(null);
        if (handlerOutput == null) {
            return false;
        }
        int maxStackSize = originalItemStack.func_77976_d();
        int remainingItemCount = originalCount = originalItemStack.func_190916_E();
        ItemStack itemStackToInsert = null;
        for (int slot = 0; slot < handlerOutput.getSlots(); ++slot) {
            int limit = Math.min(handlerOutput.getSlotLimit(slot), maxStackSize);
            int amountInOutputSlot = 0;
            ItemStack stackInOutputSlot = handlerOutput.getStackInSlot(slot);
            if (!stackInOutputSlot.func_190926_b()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)originalItemStack, (ItemStack)stackInOutputSlot)) continue;
                amountInOutputSlot = stackInOutputSlot.func_190916_E();
                limit -= amountInOutputSlot;
            }
            limit = Math.min(limit, remainingItemCount);
            if ((limit = Math.min(limit, max)) <= 0) continue;
            if (itemStackToInsert == null) {
                itemStackToInsert = originalItemStack.func_77946_l();
            }
            itemStackToInsert.func_190920_e(limit);
            ItemStack remainderItemStack = handlerOutput.insertItem(slot, itemStackToInsert, false);
            if ((remainingItemCount -= limit - remainderItemStack.func_190916_E()) <= 0) break;
        }
        boolean bl = didInsertItems = (insertedItemCount = originalCount - remainingItemCount) > 0;
        if (didInsertItems && (extractedItemStack = handlerHere.extractItem(theslot, insertedItemCount, false)).func_190916_E() != insertedItemCount) {
            ModCyclic.LOGGER.error("Imbalance moving items, extracted " + extractedItemStack + " inserted " + insertedItemCount);
        }
        return didInsertItems;
    }

    protected boolean moveEnergy(Direction myFacingDir, int quantity) {
        return this.moveEnergy(myFacingDir, this.field_174879_c.func_177972_a(myFacingDir), quantity);
    }

    protected boolean moveEnergy(Direction myFacingDir, BlockPos posTarget, int quantity) {
        if (quantity <= 0) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        IEnergyStorage handlerHere = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, myFacingDir).orElse(null);
        if (handlerHere == null) {
            return false;
        }
        Direction themFacingMe = myFacingDir.func_176734_d();
        TileEntity tileTarget = this.field_145850_b.func_175625_s(posTarget);
        if (tileTarget == null) {
            return false;
        }
        IEnergyStorage handlerOutput = (IEnergyStorage)tileTarget.getCapability(CapabilityEnergy.ENERGY, themFacingMe).orElse(null);
        if (handlerOutput == null) {
            return false;
        }
        int capacity = handlerOutput.getMaxEnergyStored() - handlerOutput.getEnergyStored();
        if (capacity <= 0) {
            return false;
        }
        int drain = handlerHere.extractEnergy(Math.min(quantity, capacity), true);
        if (drain <= 0) {
            return false;
        }
        int filled = handlerOutput.receiveEnergy(drain, false);
        if (filled <= 0) {
            return false;
        }
        int drained = handlerHere.extractEnergy(filled, false);
        if (drained != filled) {
            ModCyclic.LOGGER.error("Imbalance moving energy, extracted " + drained + " received " + filled);
        }
        if (tileTarget instanceof TileCableEnergy) {
            TileCableEnergy cable = (TileCableEnergy)tileTarget;
            cable.updateIncomingEnergyFace(themFacingMe);
        }
        return true;
    }

    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.flowing = tag.func_74762_e("flowing");
        this.needsRedstone = tag.func_74762_e("needsRedstone");
        this.render = tag.func_74762_e("renderParticles");
        this.timer = tag.func_74762_e("timer");
        super.func_230337_a_(bs, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("flowing", this.flowing);
        tag.func_74768_a("needsRedstone", this.needsRedstone);
        tag.func_74768_a("renderParticles", this.render);
        tag.func_74768_a("timer", this.timer);
        return super.func_189515_b(tag);
    }

    public abstract void setField(int var1, int var2);

    public abstract int getField(int var1);

    public void setNeedsRedstone(int value) {
        this.needsRedstone = value % 2;
    }

    public FluidStack getFluid() {
        return FluidStack.EMPTY;
    }

    public void setFluid(FluidStack fluid) {
    }

    @Deprecated
    public int func_70302_i_() {
        return 0;
    }

    @Deprecated
    public boolean func_191420_l() {
        return true;
    }

    @Deprecated
    public ItemStack func_70301_a(int index) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public ItemStack func_70298_a(int index, int count) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public void func_70299_a(int index, ItemStack stack) {
    }

    @Deprecated
    public boolean func_70300_a(PlayerEntity player) {
        return false;
    }

    @Deprecated
    public void func_174888_l() {
    }

    public void setFieldString(int field, String value) {
    }

    public String getFieldString(int field) {
        return null;
    }

    public int getEnergy() {
        return this.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public void setEnergy(int value) {
        IEnergyStorage energy = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        if (energy != null && energy instanceof CustomEnergyStorage) {
            ((CustomEnergyStorage)energy).setEnergy(value);
        }
    }

    protected void syncEnergy() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L) {
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        if (energy == null) {
            return;
        }
        PacketEnergySync packetEnergySync = new PacketEnergySync(this.func_174877_v(), energy.getEnergyStored());
        PacketRegistry.sendToAllClients(this.field_145850_b, packetEnergySync);
    }

    public void exportEnergyAllSides() {
        for (Direction exportToSide : UtilDirection.getAllInDifferentOrder()) {
            this.moveEnergy(exportToSide, 32000);
        }
    }
}

