/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.googlyeyes.common.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import me.ichun.mods.ichunutil.common.config.ConfigBase;
import me.ichun.mods.ichunutil.common.config.annotations.CategoryDivider;
import me.ichun.mods.ichunutil.common.config.annotations.Prop;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraftforge.fml.config.ModConfig;

public class Config
extends ConfigBase {
    @CategoryDivider(name="clientOnly")
    public boolean acidTripEyes = false;
    public List<String> disabledGoogly = new ArrayList<String>();
    @Prop(min=0.0, max=100.0)
    public int googlyEyeChance = 20;
    @Prop(validator="overrideChance")
    public List<String> entityOverrideChance = new ArrayList<String>();
    public List<String> nameOverride = new ArrayList<String>();
    public transient HashMap<ResourceLocation, Integer> entityOverrideChanceParsed = new HashMap();

    public boolean overrideChance(Object o) {
        String[] split;
        if (o instanceof String && (split = ((String)o).split(",")).length == 2) {
            try {
                new ResourceLocation(split[0]);
                int chance = Integer.parseInt(split[1]);
                return chance >= 0 && chance <= 100;
            }
            catch (NumberFormatException | ResourceLocationException throwable) {
                // empty catch block
            }
        }
        return false;
    }

    @Nonnull
    public String getModId() {
        return "googlyeyes";
    }

    @Nonnull
    public String getConfigName() {
        return "Googly Eyes";
    }

    @Nonnull
    public ModConfig.Type getConfigType() {
        return ModConfig.Type.CLIENT;
    }

    public void onConfigLoaded() {
        Minecraft.func_71410_x().execute(this::parseOverrideChance);
    }

    public void parseOverrideChance() {
        this.entityOverrideChanceParsed.clear();
        for (String s : this.entityOverrideChance) {
            String[] split = s.split(",");
            this.entityOverrideChanceParsed.put(new ResourceLocation(split[0]), Integer.parseInt(split[1]));
        }
    }
}

