/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.packets;

import com.shynieke.statues.entity.PlayerStatueEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlayerStatueSyncMessage {
    private UUID entityUUID;
    private CompoundNBT data;

    private PlayerStatueSyncMessage(PacketBuffer buf) {
        this.entityUUID = buf.func_179253_g();
        this.data = buf.func_150793_b();
    }

    public PlayerStatueSyncMessage(UUID playerUUID, CompoundNBT tag) {
        this.entityUUID = playerUUID;
        this.data = tag;
    }

    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.entityUUID);
        buf.func_150786_a(this.data);
    }

    public static PlayerStatueSyncMessage decode(PacketBuffer packetBuffer) {
        return new PlayerStatueSyncMessage(packetBuffer.func_179253_g(), packetBuffer.func_150793_b());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isServer()) {
                PlayerStatueEntity playerStatue;
                ServerPlayerEntity player = ctx.getSender();
                ServerWorld world = ctx.getSender().func_71121_q();
                Entity entity = world.func_217461_a(this.entityUUID);
                if (entity instanceof PlayerStatueEntity && player != null && (!(playerStatue = (PlayerStatueEntity)entity).isLocked() || playerStatue.getLockedBy().equals(player.func_110124_au()))) {
                    boolean noGravityFlag;
                    CompoundNBT entityTag = playerStatue.func_189511_e(new CompoundNBT());
                    CompoundNBT entityTagCopy = entityTag.func_74737_b();
                    if (!this.data.isEmpty()) {
                        entityTagCopy.func_197643_a(this.data);
                        UUID uuid = playerStatue.func_110124_au();
                        playerStatue.func_70020_e(entityTagCopy);
                        playerStatue.func_184221_a(uuid);
                    }
                    float YOffset = this.data.func_74760_g("yOffset");
                    playerStatue.setYOffset(YOffset);
                    boolean lockFlag = this.data.func_74767_n("Locked");
                    if (lockFlag) {
                        if (!playerStatue.isLocked()) {
                            playerStatue.setLockedBy(player.func_110124_au());
                        }
                    } else if (playerStatue.isLocked()) {
                        playerStatue.setUnlocked();
                    }
                    if (noGravityFlag = this.data.func_74767_n("NoGravity")) {
                        playerStatue.func_189654_d(true);
                    } else {
                        playerStatue.func_189654_d(false);
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

