/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.screen;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class PlayerStatueData {
    public boolean small = false;
    public boolean locked = false;
    public boolean nameVisible = true;
    public boolean noGravity = false;
    public float yOffset = 0.0f;
    public float rotation = 0.0f;
    public float[] pose = new float[18];

    public boolean isSmall() {
        return this.small;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean getNameVisible() {
        return this.nameVisible;
    }

    public boolean hasNoGravity() {
        return this.noGravity;
    }

    public void readNBT(CompoundNBT compound) {
        this.small = compound.func_74767_n("Small");
        this.locked = compound.func_74767_n("Locked");
        this.nameVisible = compound.func_74767_n("CustomNameVisible");
        this.noGravity = compound.func_74767_n("NoGravity");
        this.yOffset = compound.func_74760_g("yOffset");
        if (compound.func_74764_b("Rotation")) {
            this.rotation = compound.func_150295_c("Rotation", 5).func_150308_e(0);
        }
        if (compound.func_74764_b("Pose")) {
            CompoundNBT poseTag = (CompoundNBT)compound.func_74781_a("Pose");
            String[] keys = new String[]{"Head", "Body", "LeftLeg", "RightLeg", "LeftArm", "RightArm"};
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!poseTag.func_74764_b(key)) continue;
                ListNBT tagList = poseTag.func_150295_c(key, 5);
                for (int j = 0; j <= 2; ++j) {
                    int k = i * 3 + j;
                    this.pose[k] = tagList.func_150308_e(j);
                }
            }
        }
    }

    public CompoundNBT writeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74757_a("Small", this.small);
        compound.func_74757_a("Locked", this.locked);
        compound.func_74757_a("CustomNameVisible", this.nameVisible);
        compound.func_74757_a("NoGravity", this.noGravity);
        compound.func_74776_a("yOffset", this.yOffset);
        ListNBT rotationTag = new ListNBT();
        rotationTag.add((Object)FloatNBT.func_229689_a_((float)this.rotation));
        compound.func_218657_a("Rotation", (INBT)rotationTag);
        CompoundNBT poseTag = new CompoundNBT();
        ListNBT poseHeadTag = new ListNBT();
        poseHeadTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[0]));
        poseHeadTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[1]));
        poseHeadTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[2]));
        poseTag.func_218657_a("Head", (INBT)poseHeadTag);
        ListNBT poseBodyTag = new ListNBT();
        poseBodyTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[3]));
        poseBodyTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[4]));
        poseBodyTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[5]));
        poseTag.func_218657_a("Body", (INBT)poseBodyTag);
        ListNBT poseLeftLegTag = new ListNBT();
        poseLeftLegTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[6]));
        poseLeftLegTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[7]));
        poseLeftLegTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[8]));
        poseTag.func_218657_a("LeftLeg", (INBT)poseLeftLegTag);
        ListNBT poseRightLegTag = new ListNBT();
        poseRightLegTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[9]));
        poseRightLegTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[10]));
        poseRightLegTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[11]));
        poseTag.func_218657_a("RightLeg", (INBT)poseRightLegTag);
        ListNBT poseLeftArmTag = new ListNBT();
        poseLeftArmTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[12]));
        poseLeftArmTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[13]));
        poseLeftArmTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[14]));
        poseTag.func_218657_a("LeftArm", (INBT)poseLeftArmTag);
        ListNBT poseRightArmTag = new ListNBT();
        poseRightArmTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[15]));
        poseRightArmTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[16]));
        poseRightArmTag.add((Object)FloatNBT.func_229689_a_((float)this.pose[17]));
        poseTag.func_218657_a("RightArm", (INBT)poseRightArmTag);
        compound.func_218657_a("Pose", (INBT)poseTag);
        return compound;
    }
}

