/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StairsBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty field_176309_a = HorizontalBlock.field_185512_D;
    public static final EnumProperty<Half> field_176308_b = BlockStateProperties.field_208164_Q;
    public static final EnumProperty<StairsShape> field_176310_M = BlockStateProperties.field_208146_au;
    public static final BooleanProperty field_204513_t = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_185712_d = SlabBlock.field_196507_c;
    protected static final VoxelShape field_185719_G = SlabBlock.field_196506_b;
    protected static final VoxelShape field_196512_A = Block.func_208617_a(0.0, 0.0, 0.0, 8.0, 8.0, 8.0);
    protected static final VoxelShape field_196513_B = Block.func_208617_a(0.0, 0.0, 8.0, 8.0, 8.0, 16.0);
    protected static final VoxelShape field_196514_C = Block.func_208617_a(0.0, 8.0, 0.0, 8.0, 16.0, 8.0);
    protected static final VoxelShape field_196515_D = Block.func_208617_a(0.0, 8.0, 8.0, 8.0, 16.0, 16.0);
    protected static final VoxelShape field_196516_E = Block.func_208617_a(8.0, 0.0, 0.0, 16.0, 8.0, 8.0);
    protected static final VoxelShape field_196517_F = Block.func_208617_a(8.0, 0.0, 8.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape field_196518_G = Block.func_208617_a(8.0, 8.0, 0.0, 16.0, 16.0, 8.0);
    protected static final VoxelShape field_196519_H = Block.func_208617_a(8.0, 8.0, 8.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] field_196520_I = StairsBlock.func_199779_a(field_185712_d, field_196512_A, field_196516_E, field_196513_B, field_196517_F);
    protected static final VoxelShape[] field_196521_J = StairsBlock.func_199779_a(field_185719_G, field_196514_C, field_196518_G, field_196515_D, field_196519_H);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block field_150149_b;
    private final BlockState field_150151_M;
    private final Supplier<BlockState> stateSupplier;

    private static VoxelShape[] func_199779_a(VoxelShape p_199779_0_, VoxelShape p_199779_1_, VoxelShape p_199779_2_, VoxelShape p_199779_3_, VoxelShape p_199779_4_) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> StairsBlock.func_199781_a(p_199780_5_, p_199779_0_, p_199779_1_, p_199779_2_, p_199779_3_, p_199779_4_)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape func_199781_a(int p_199781_0_, VoxelShape p_199781_1_, VoxelShape p_199781_2_, VoxelShape p_199781_3_, VoxelShape p_199781_4_, VoxelShape p_199781_5_) {
        VoxelShape voxelshape = p_199781_1_;
        if ((p_199781_0_ & 1) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)p_199781_1_, (VoxelShape)p_199781_2_);
        }
        if ((p_199781_0_ & 2) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)p_199781_3_);
        }
        if ((p_199781_0_ & 4) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)p_199781_4_);
        }
        if ((p_199781_0_ & 8) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)p_199781_5_);
        }
        return voxelshape;
    }

    @Deprecated
    public StairsBlock(BlockState p_i48321_1_, AbstractBlock.Properties p_i48321_2_) {
        super(p_i48321_2_);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176309_a, (Comparable)((Object)Direction.NORTH)))).func_206870_a((Property)field_176308_b, (Comparable)Half.BOTTOM))).func_206870_a((Property)field_176310_M, (Comparable)StairsShape.STRAIGHT))).func_206870_a((Property)field_204513_t, Boolean.valueOf(false))));
        this.field_150149_b = p_i48321_1_.func_177230_c();
        this.field_150151_M = p_i48321_1_;
        this.stateSupplier = () -> p_i48321_1_;
    }

    public StairsBlock(Supplier<BlockState> state, AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176309_a, (Comparable)((Object)Direction.NORTH)))).func_206870_a((Property)field_176308_b, (Comparable)Half.BOTTOM))).func_206870_a((Property)field_176310_M, (Comparable)StairsShape.STRAIGHT))).func_206870_a((Property)field_204513_t, Boolean.valueOf(false))));
        this.field_150149_b = Blocks.field_150350_a;
        this.field_150151_M = Blocks.field_150350_a.func_176223_P();
        this.stateSupplier = state;
    }

    @Override
    public boolean func_220074_n(BlockState p_220074_1_) {
        return true;
    }

    @Override
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return (p_220053_1_.func_177229_b((Property)field_176308_b) == Half.TOP ? field_196520_I : field_196521_J)[field_196522_K[this.func_196511_x(p_220053_1_)]];
    }

    private int func_196511_x(BlockState p_196511_1_) {
        return ((StairsShape)p_196511_1_.func_177229_b((Property)field_176310_M)).ordinal() * 4 + ((Direction)((Object)p_196511_1_.func_177229_b((Property)field_176309_a))).func_176736_b();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState p_180655_1_, World p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
        this.field_150149_b.func_180655_c(p_180655_1_, p_180655_2_, p_180655_3_, p_180655_4_);
    }

    @Override
    public void func_196270_a(BlockState p_196270_1_, World p_196270_2_, BlockPos p_196270_3_, PlayerEntity p_196270_4_) {
        this.field_150151_M.func_196942_a(p_196270_2_, p_196270_3_, p_196270_4_);
    }

    @Override
    public void func_176206_d(IWorld p_176206_1_, BlockPos p_176206_2_, BlockState p_176206_3_) {
        this.field_150149_b.func_176206_d(p_176206_1_, p_176206_2_, p_176206_3_);
    }

    @Override
    public float func_149638_a() {
        return this.field_150149_b.func_149638_a();
    }

    @Override
    public void func_220082_b(BlockState p_220082_1_, World p_220082_2_, BlockPos p_220082_3_, BlockState p_220082_4_, boolean p_220082_5_) {
        if (!p_220082_1_.func_203425_a(p_220082_1_.func_177230_c())) {
            this.field_150151_M.func_215697_a(p_220082_2_, p_220082_3_, Blocks.field_150350_a, p_220082_3_, false);
            this.field_150149_b.func_220082_b(this.field_150151_M, p_220082_2_, p_220082_3_, p_220082_4_, false);
        }
    }

    @Override
    public void func_196243_a(BlockState p_196243_1_, World p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.func_203425_a(p_196243_4_.func_177230_c())) {
            this.field_150151_M.func_196947_b(p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    @Override
    public void func_176199_a(World p_176199_1_, BlockPos p_176199_2_, Entity p_176199_3_) {
        this.field_150149_b.func_176199_a(p_176199_1_, p_176199_2_, p_176199_3_);
    }

    @Override
    public boolean func_149653_t(BlockState p_149653_1_) {
        return this.field_150149_b.func_149653_t(p_149653_1_);
    }

    @Override
    public void func_225542_b_(BlockState p_225542_1_, ServerWorld p_225542_2_, BlockPos p_225542_3_, Random p_225542_4_) {
        this.field_150149_b.func_225542_b_(p_225542_1_, p_225542_2_, p_225542_3_, p_225542_4_);
    }

    @Override
    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        this.field_150149_b.func_225534_a_(p_225534_1_, p_225534_2_, p_225534_3_, p_225534_4_);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        return this.field_150151_M.func_227031_a_(p_225533_2_, p_225533_4_, p_225533_5_, p_225533_6_);
    }

    @Override
    public void func_180652_a(World p_180652_1_, BlockPos p_180652_2_, Explosion p_180652_3_) {
        this.field_150149_b.func_180652_a(p_180652_1_, p_180652_2_, p_180652_3_);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        Direction direction = p_196258_1_.func_196000_l();
        BlockPos blockpos = p_196258_1_.func_195995_a();
        FluidState fluidstate = p_196258_1_.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate = (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_176309_a, (Comparable)((Object)p_196258_1_.func_195992_f())))).func_206870_a((Property)field_176308_b, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && p_196258_1_.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? Half.BOTTOM : Half.TOP)))).func_206870_a((Property)field_204513_t, Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a)));
        return (BlockState)((Object)blockstate.func_206870_a((Property)field_176310_M, (Comparable)StairsBlock.func_208064_n(blockstate, (IBlockReader)((Object)p_196258_1_.func_195991_k()), blockpos)));
    }

    @Override
    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (((Boolean)p_196271_1_.func_177229_b((Property)field_204513_t)).booleanValue()) {
            p_196271_4_.func_205219_F_().func_205360_a(p_196271_5_, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)p_196271_4_));
        }
        return p_196271_2_.func_176740_k().func_176722_c() ? (BlockState)((Object)p_196271_1_.func_206870_a((Property)field_176310_M, (Comparable)StairsBlock.func_208064_n(p_196271_1_, (IBlockReader)p_196271_4_, p_196271_5_))) : super.func_196271_a(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    private static StairsShape func_208064_n(BlockState p_208064_0_, IBlockReader p_208064_1_, BlockPos p_208064_2_) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)((Object)p_208064_0_.func_177229_b((Property)field_176309_a));
        BlockState blockstate = p_208064_1_.func_180495_p(p_208064_2_.func_177972_a(direction));
        if (StairsBlock.func_185709_i(blockstate) && p_208064_0_.func_177229_b((Property)field_176308_b) == blockstate.func_177229_b((Property)field_176308_b) && (direction1 = (Direction)((Object)blockstate.func_177229_b((Property)field_176309_a))).func_176740_k() != ((Direction)((Object)p_208064_0_.func_177229_b((Property)field_176309_a))).func_176740_k() && StairsBlock.func_185704_d(p_208064_0_, p_208064_1_, p_208064_2_, direction1.func_176734_d())) {
            if (direction1 == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = p_208064_1_.func_180495_p(p_208064_2_.func_177972_a(direction.func_176734_d()));
        if (StairsBlock.func_185709_i(blockstate1) && p_208064_0_.func_177229_b((Property)field_176308_b) == blockstate1.func_177229_b((Property)field_176308_b) && (direction2 = (Direction)((Object)blockstate1.func_177229_b((Property)field_176309_a))).func_176740_k() != ((Direction)((Object)p_208064_0_.func_177229_b((Property)field_176309_a))).func_176740_k() && StairsBlock.func_185704_d(p_208064_0_, p_208064_1_, p_208064_2_, direction2)) {
            if (direction2 == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean func_185704_d(BlockState p_185704_0_, IBlockReader p_185704_1_, BlockPos p_185704_2_, Direction p_185704_3_) {
        BlockState blockstate = p_185704_1_.func_180495_p(p_185704_2_.func_177972_a(p_185704_3_));
        return !StairsBlock.func_185709_i(blockstate) || blockstate.func_177229_b((Property)field_176309_a) != p_185704_0_.func_177229_b((Property)field_176309_a) || blockstate.func_177229_b((Property)field_176308_b) != p_185704_0_.func_177229_b((Property)field_176308_b);
    }

    public static boolean func_185709_i(BlockState p_185709_0_) {
        return p_185709_0_.func_177230_c() instanceof StairsBlock;
    }

    @Override
    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)((Object)p_185499_1_.func_206870_a((Property)field_176309_a, (Comparable)((Object)p_185499_2_.func_185831_a((Direction)((Object)p_185499_1_.func_177229_b((Property)field_176309_a))))));
    }

    @Override
    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        Direction direction = (Direction)((Object)p_185471_1_.func_177229_b((Property)field_176309_a));
        StairsShape stairsshape = (StairsShape)p_185471_1_.func_177229_b((Property)field_176310_M);
        switch (p_185471_2_) {
            case LEFT_RIGHT: {
                if (direction.func_176740_k() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)((Object)p_185471_1_.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((Property)field_176310_M, (Comparable)StairsShape.INNER_RIGHT));
                    }
                    case INNER_RIGHT: {
                        return (BlockState)((Object)p_185471_1_.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((Property)field_176310_M, (Comparable)StairsShape.INNER_LEFT));
                    }
                    case OUTER_LEFT: {
                        return (BlockState)((Object)p_185471_1_.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((Property)field_176310_M, (Comparable)StairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)((Object)p_185471_1_.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((Property)field_176310_M, (Comparable)StairsShape.OUTER_LEFT));
                    }
                }
                return p_185471_1_.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.func_176740_k() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)((Object)p_185471_1_.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((Property)field_176310_M, (Comparable)StairsShape.INNER_LEFT));
                    }
                    case INNER_RIGHT: {
                        return (BlockState)((Object)p_185471_1_.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((Property)field_176310_M, (Comparable)StairsShape.INNER_RIGHT));
                    }
                    case OUTER_LEFT: {
                        return (BlockState)((Object)p_185471_1_.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((Property)field_176310_M, (Comparable)StairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)((Object)p_185471_1_.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a((Property)field_176310_M, (Comparable)StairsShape.OUTER_LEFT));
                    }
                    case STRAIGHT: {
                        return p_185471_1_.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.func_185471_a(p_185471_1_, p_185471_2_);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_176309_a, field_176308_b, field_176310_M, field_204513_t});
    }

    @Override
    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)field_204513_t) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    @Override
    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return false;
    }

    private Block getModelBlock() {
        return this.getModelState().func_177230_c();
    }

    private BlockState getModelState() {
        return this.stateSupplier.get();
    }
}

