/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world.gen.forge;

import dev.latvian.kubejs.util.ConsoleJS;
import dev.latvian.kubejs.world.gen.RemoveSpawnsByCategoryProperties;
import dev.latvian.kubejs.world.gen.RemoveSpawnsByIDProperties;
import dev.latvian.kubejs.world.gen.WorldgenEntryList;
import dev.latvian.kubejs.world.gen.WorldgenRemoveEventJS;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import org.jetbrains.annotations.Nullable;

public class WorldgenRemoveEventJSForge
extends WorldgenRemoveEventJS {
    private final BiomeLoadingEvent event;
    private final Map<ConfiguredFeature<?, ?>, Optional<ResourceLocation>> featureRegistry = new HashMap();

    public WorldgenRemoveEventJSForge(BiomeLoadingEvent e) {
        this.event = e;
    }

    @Override
    @Nullable
    public ResourceLocation getConfiguredFeatureKey(ConfiguredFeature<?, ?> feature) {
        return this.featureRegistry.computeIfAbsent(feature, f -> {
            ResourceLocation id = WorldGenRegistries.field_243653_e.func_177774_c(f);
            if (id != null) {
                return Optional.of(id);
            }
            return Optional.empty();
        }).orElse(null);
    }

    @Override
    protected boolean verifyBiomes(WorldgenEntryList biomes) {
        return biomes.verify(s -> {
            if (s.startsWith("#")) {
                return this.event.getCategory().func_222352_a().equals(s.substring(1));
            }
            return new ResourceLocation(s).equals((Object)this.event.getName());
        });
    }

    @Override
    protected void removeFeature(GenerationStage.Decoration decoration, Predicate<IFeatureConfig> predicate) {
        this.event.getGeneration().getFeatures(decoration).removeIf(configuredFeatureSupplier -> WorldgenRemoveEventJSForge.checkTree((ConfiguredFeature)configuredFeatureSupplier.get(), predicate));
    }

    @Override
    protected void removeSpawn(RemoveSpawnsByCategoryProperties properties) {
        this.event.getSpawns().getSpawnerTypes().forEach(category -> {
            if (properties.categories.verifyIgnoreCase(category.func_220363_a())) {
                this.event.getSpawns().getSpawner(category).clear();
            }
        });
    }

    @Override
    protected void removeSpawn(RemoveSpawnsByIDProperties properties) {
        this.event.getSpawns().getSpawnerTypes().forEach(category -> this.event.getSpawns().getSpawner(category).removeIf(spawner -> properties.entities.verify(spawner.field_242588_c.func_210760_d())));
    }

    @Override
    public void printFeatures(@Nullable GenerationStage.Decoration type) {
        if (type == null) {
            for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
                this.printFeatures(decoration);
            }
        } else {
            ConsoleJS.STARTUP.info("Features with type '" + type.name().toLowerCase() + "' in biome '" + this.event.getName() + "':");
            int unknown = 0;
            for (Supplier cfs : this.event.getGeneration().getFeatures(type)) {
                ConfiguredFeature cf = (ConfiguredFeature)cfs.get();
                ResourceLocation id = this.getConfiguredFeatureKey(cf);
                if (id == null) {
                    ++unknown;
                    continue;
                }
                ConsoleJS.STARTUP.info("- " + id);
            }
            if (unknown > 0) {
                ConsoleJS.STARTUP.info("- " + unknown + " features with unknown id");
            }
        }
    }

    @Override
    public void removeFeatureById(GenerationStage.Decoration type, ResourceLocation[] ids) {
        Set set = Arrays.stream(ids).collect(Collectors.toSet());
        this.event.getGeneration().getFeatures(type).removeIf(cf -> {
            ResourceLocation id = this.getConfiguredFeatureKey((ConfiguredFeature)cf.get());
            return id != null && set.contains(id);
        });
    }

    @Override
    public void removeAllFeatures(GenerationStage.Decoration type) {
        this.event.getGeneration().getFeatures(type).clear();
    }

    @Override
    public void removeAllFeatures() {
        for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
            this.event.getGeneration().getFeatures(decoration).clear();
        }
    }

    @Override
    public void printSpawns(@Nullable EntityClassification category) {
        if (category == null) {
            for (EntityClassification c : EntityClassification.values()) {
                this.printSpawns(c);
            }
            return;
        }
        ConsoleJS.STARTUP.info("Mod spawns with type '" + category.func_220363_a() + "' in biome '" + this.event.getName() + "':");
        for (MobSpawnInfo.Spawners data : this.event.getSpawns().getSpawner(category)) {
            ConsoleJS.STARTUP.info("- " + data.toString());
        }
    }

    @Override
    public void removeAllSpawns() {
        this.event.getSpawns().getSpawnerTypes().forEach(category -> this.event.getSpawns().getSpawner(category).clear());
    }
}

