/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.integration.gamestages;

import dev.latvian.kubejs.integration.gamestages.GameStageClientHelper;
import dev.latvian.kubejs.stages.Stages;
import java.util.Collection;
import java.util.Collections;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.IStageData;
import net.darkhax.gamestages.data.StageData;
import net.minecraft.entity.player.PlayerEntity;

public class GameStagesWrapper
extends Stages {
    public GameStagesWrapper(PlayerEntity p) {
        super(p);
    }

    @Override
    public boolean addNoUpdate(String stage) {
        IStageData stageData = GameStageHelper.getPlayerData((PlayerEntity)this.player);
        if (stageData != null && !stageData.hasStage(stage)) {
            stageData.addStage(stage);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeNoUpdate(String stage) {
        IStageData stageData = GameStageHelper.getPlayerData((PlayerEntity)this.player);
        if (stageData != null && stageData.hasStage(stage)) {
            stageData.removeStage(stage);
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> getAll() {
        IStageData stageData = GameStageHelper.getPlayerData((PlayerEntity)this.player);
        return stageData != null ? stageData.getStages() : Collections.emptyList();
    }

    @Override
    public void replace(Collection<String> stages) {
        StageData stageData = new StageData();
        for (String s : stages) {
            stageData.addStage(s);
        }
        this.setClientData((IStageData)stageData);
    }

    private void setClientData(IStageData stageData) {
        GameStageClientHelper.setClientData(stageData);
    }
}

