/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.entity;

import com.mojang.authlib.GameProfile;
import dev.latvian.kubejs.core.EntityKJS;
import dev.latvian.kubejs.entity.RayTraceResultJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.player.EntityArrayList;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.util.MessageSender;
import dev.latvian.kubejs.util.WrappedJS;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.kubejs.world.ServerWorldJS;
import dev.latvian.kubejs.world.WorldJS;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.shedaniel.architectury.hooks.EntityHooks;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

public class EntityJS
implements MessageSender,
WrappedJS {
    private static Map<String, DamageSource> damageSourceMap;
    private final WorldJS level;
    public final Entity minecraftEntity;
    public final CompoundNBT persistentData;

    public EntityJS(WorldJS w, Entity e) {
        this.level = w;
        this.minecraftEntity = e;
        this.persistentData = ((EntityKJS)e).getPersistentDataKJS();
    }

    public WorldJS getLevel() {
        return this.level;
    }

    public WorldJS getWorld() {
        return this.level;
    }

    @Nullable
    public ServerJS getServer() {
        return this.getWorld().getServer();
    }

    public UUID getId() {
        return this.minecraftEntity.func_110124_au();
    }

    public String getType() {
        return Registries.getId((Object)this.minecraftEntity.func_200600_R(), (RegistryKey)Registry.field_239713_n_).toString();
    }

    @Override
    public Text getName() {
        return Text.of(this.minecraftEntity.func_200200_C_());
    }

    public GameProfile getProfile() {
        return new GameProfile(this.getId(), EntityHooks.getEncodeId((Entity)this.minecraftEntity));
    }

    @Override
    public Text getDisplayName() {
        return Text.of(this.minecraftEntity.func_145748_c_());
    }

    @Override
    public void tell(ITextComponent message) {
        this.minecraftEntity.func_145747_a(message, Util.field_240973_b_);
    }

    public String toString() {
        return this.minecraftEntity.func_200200_C_().getString() + "-" + this.getId();
    }

    @Nullable
    public ItemStackJS getItem() {
        return null;
    }

    public boolean isFrame() {
        return false;
    }

    public Set<String> getTags() {
        return this.minecraftEntity.func_184216_O();
    }

    public boolean isAlive() {
        return this.minecraftEntity.func_70089_S();
    }

    public boolean isLiving() {
        return false;
    }

    public boolean isPlayer() {
        return false;
    }

    public boolean isCrouching() {
        return this.minecraftEntity.func_213453_ef();
    }

    public boolean isSprinting() {
        return this.minecraftEntity.func_70051_ag();
    }

    public boolean isSwimming() {
        return this.minecraftEntity.func_203007_ba();
    }

    public boolean isGlowing() {
        return this.minecraftEntity.func_225510_bt_();
    }

    public void setGlowing(boolean glowing) {
        this.minecraftEntity.func_184195_f(glowing);
    }

    public boolean isInvisible() {
        return this.minecraftEntity.func_82150_aj();
    }

    public void setInvisible(boolean invisible) {
        this.minecraftEntity.func_82142_c(invisible);
    }

    public boolean isInvulnerable() {
        return this.minecraftEntity.func_190530_aW();
    }

    public void setInvulnerable(boolean invulnerable) {
        this.minecraftEntity.func_184224_h(invulnerable);
    }

    public boolean isBoss() {
        return !this.minecraftEntity.func_184222_aU();
    }

    public boolean isMonster() {
        return !this.minecraftEntity.func_200600_R().func_220339_d().func_75599_d();
    }

    public boolean isAnimal() {
        return this.minecraftEntity.func_200600_R().func_220339_d().func_82705_e();
    }

    public boolean isAmbientCreature() {
        return this.minecraftEntity.func_200600_R().func_220339_d() == EntityClassification.AMBIENT;
    }

    public boolean isWaterCreature() {
        return this.minecraftEntity.func_200600_R().func_220339_d() == EntityClassification.WATER_CREATURE;
    }

    public boolean isPeacefulCreature() {
        return this.minecraftEntity.func_200600_R().func_220339_d().func_75599_d();
    }

    public boolean isOnGround() {
        return this.minecraftEntity.func_233570_aj_();
    }

    public float getFallDistance() {
        return this.minecraftEntity.field_70143_R;
    }

    public void setFallDistance(float fallDistance) {
        this.minecraftEntity.field_70143_R = fallDistance;
    }

    public float getStepHeight() {
        return this.minecraftEntity.field_70138_W;
    }

    public void setStepHeight(float stepHeight) {
        this.minecraftEntity.field_70138_W = stepHeight;
    }

    public boolean getNoClip() {
        return this.minecraftEntity.field_70145_X;
    }

    public void setNoClip(boolean noClip) {
        this.minecraftEntity.field_70145_X = noClip;
    }

    public boolean isSilent() {
        return this.minecraftEntity.func_174814_R();
    }

    public void setSilent(boolean isSilent) {
        this.minecraftEntity.func_174810_b(isSilent);
    }

    public boolean getNoGravity() {
        return this.minecraftEntity.func_189652_ae();
    }

    public void setNoGravity(boolean noGravity) {
        this.minecraftEntity.func_189654_d(noGravity);
    }

    public double getX() {
        return this.minecraftEntity.func_226277_ct_();
    }

    public void setX(double x) {
        this.minecraftEntity.func_70107_b(x, this.getY(), this.getZ());
    }

    public double getY() {
        return this.minecraftEntity.func_226278_cu_();
    }

    public void setY(double y) {
        this.minecraftEntity.func_70107_b(this.getX(), y, this.getZ());
    }

    public double getZ() {
        return this.minecraftEntity.func_226281_cx_();
    }

    public void setZ(double z) {
        this.minecraftEntity.func_70107_b(this.getX(), this.getY(), z);
    }

    public float getYaw() {
        return this.minecraftEntity.field_70177_z;
    }

    public void setYaw(float yaw) {
        this.minecraftEntity.field_70177_z = yaw;
    }

    public float getPitch() {
        return this.minecraftEntity.field_70125_A;
    }

    public void setPitch(float pitch) {
        this.minecraftEntity.field_70125_A = pitch;
    }

    public double getMotionX() {
        return this.minecraftEntity.func_213322_ci().field_72450_a;
    }

    public void setMotionX(double x) {
        Vector3d m = this.minecraftEntity.func_213322_ci();
        this.minecraftEntity.func_213293_j(x, m.field_72448_b, m.field_72449_c);
    }

    public double getMotionY() {
        return this.minecraftEntity.func_213322_ci().field_72448_b;
    }

    public void setMotionY(double y) {
        Vector3d m = this.minecraftEntity.func_213322_ci();
        this.minecraftEntity.func_213293_j(m.field_72450_a, y, m.field_72449_c);
    }

    public double getMotionZ() {
        return this.minecraftEntity.func_213322_ci().field_72449_c;
    }

    public void setMotionZ(double z) {
        Vector3d m = this.minecraftEntity.func_213322_ci();
        this.minecraftEntity.func_213293_j(m.field_72450_a, m.field_72448_b, z);
    }

    public void setMotion(double x, double y, double z) {
        this.minecraftEntity.func_213293_j(x, y, z);
    }

    public int getTicksExisted() {
        return this.minecraftEntity.field_70173_aa;
    }

    public void setPosition(BlockContainerJS block) {
        this.setPosition((double)block.getX() + 0.5, (double)block.getY() + 0.05, (double)block.getZ() + 0.5);
    }

    public void setPosition(double x, double y, double z) {
        this.setPositionAndRotation(x, y, z, this.getYaw(), this.getPitch());
    }

    public void setRotation(float yaw, float pitch) {
        this.setPositionAndRotation(this.getX(), this.getY(), this.getZ(), yaw, pitch);
    }

    public void setPositionAndRotation(double x, double y, double z, float yaw, float pitch) {
        this.minecraftEntity.func_70012_b(x, y, z, yaw, pitch);
    }

    public void addMotion(double x, double y, double z) {
        this.minecraftEntity.func_213317_d(this.minecraftEntity.func_213322_ci().func_72441_c(x, y, z));
    }

    @Override
    public int runCommand(String command) {
        if (this.level instanceof ServerWorldJS) {
            return this.level.getServer().getMinecraftServer().func_195571_aL().func_197059_a(this.minecraftEntity.func_195051_bN(), command);
        }
        return 0;
    }

    @Override
    public int runCommandSilent(String command) {
        if (this.level instanceof ServerWorldJS) {
            return this.level.getServer().getMinecraftServer().func_195571_aL().func_197059_a(this.minecraftEntity.func_195051_bN().func_197031_a(), command);
        }
        return 0;
    }

    public void kill() {
        this.minecraftEntity.func_174812_G();
    }

    public boolean startRiding(EntityJS e, boolean force) {
        return this.minecraftEntity.func_184205_a(e.minecraftEntity, force);
    }

    public void removePassengers() {
        this.minecraftEntity.func_184226_ay();
    }

    public void dismountRidingEntity() {
        this.minecraftEntity.func_184210_p();
    }

    public EntityArrayList getPassengers() {
        return new EntityArrayList(this.level, this.minecraftEntity.func_184188_bt());
    }

    public boolean isPassenger(EntityJS e) {
        return this.minecraftEntity.func_184196_w(e.minecraftEntity);
    }

    public EntityArrayList getRecursivePassengers() {
        return new EntityArrayList(this.level, this.minecraftEntity.func_184182_bu());
    }

    @Nullable
    public EntityJS getRidingEntity() {
        return this.level.getEntity(this.minecraftEntity.func_184187_bx());
    }

    public String getTeamId() {
        Team team = this.minecraftEntity.func_96124_cp();
        return team == null ? "" : team.func_96661_b();
    }

    public boolean isOnSameTeam(EntityJS e) {
        return this.minecraftEntity.func_184191_r(e.minecraftEntity);
    }

    public boolean isOnScoreboardTeam(String teamID) {
        ScorePlayerTeam team = this.minecraftEntity.func_130014_f_().func_96441_U().func_96508_e(teamID);
        return team != null && this.minecraftEntity.func_184194_a((Team)team);
    }

    public void setCustomName(ITextComponent name) {
        this.minecraftEntity.func_200203_b(name);
    }

    public Text getCustomName() {
        return Text.of(this.minecraftEntity.func_200201_e());
    }

    public boolean getHasCustomName() {
        return this.minecraftEntity.func_145818_k_();
    }

    public void setCustomNameAlwaysVisible(boolean b) {
        this.minecraftEntity.func_174805_g(b);
    }

    public boolean getCustomNameAlwaysVisible() {
        return this.minecraftEntity.func_174833_aM();
    }

    public Direction getHorizontalFacing() {
        return this.minecraftEntity.func_174811_aO();
    }

    public Direction getFacing() {
        if (this.getPitch() > 45.0f) {
            return Direction.DOWN;
        }
        if (this.getPitch() < -45.0f) {
            return Direction.UP;
        }
        return this.getHorizontalFacing();
    }

    public float getEyeHeight() {
        return this.minecraftEntity.func_70047_e();
    }

    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.minecraftEntity.field_70170_p, this.minecraftEntity.func_233580_cy_());
    }

    public void setOnFire(int seconds) {
        this.minecraftEntity.func_70015_d(seconds);
    }

    public void extinguish() {
        this.minecraftEntity.func_70066_B();
    }

    public CompoundNBT getFullNBT() {
        CompoundNBT nbt = new CompoundNBT();
        this.minecraftEntity.func_189511_e(nbt);
        return nbt;
    }

    public void setFullNBT(@Nullable CompoundNBT nbt) {
        if (nbt != null) {
            this.minecraftEntity.func_70020_e(nbt);
        }
    }

    public EntityJS mergeFullNBT(@Nullable CompoundNBT tag) {
        if (tag == null || tag.isEmpty()) {
            return this;
        }
        CompoundNBT nbt = this.getFullNBT();
        for (String k : tag.func_150296_c()) {
            INBT t = tag.func_74781_a(k);
            if (t == null || t == EndNBT.field_229686_b_) {
                nbt.func_82580_o(k);
                continue;
            }
            nbt.func_218657_a(k, tag.func_74781_a(k));
        }
        this.setFullNBT(nbt);
        return this;
    }

    @Deprecated
    public CompoundNBT getNbt() {
        return this.persistentData;
    }

    public void playSound(SoundEvent id, float volume, float pitch) {
        this.minecraftEntity.field_70170_p.func_184148_a(null, this.getX(), this.getY(), this.getZ(), id, this.minecraftEntity.func_184176_by(), volume, pitch);
    }

    public void playSound(SoundEvent id) {
        this.playSound(id, 1.0f, 1.0f);
    }

    public void spawn() {
        this.level.minecraftLevel.func_217376_c(this.minecraftEntity);
    }

    public void attack(String source, float hp) {
        if (damageSourceMap == null) {
            damageSourceMap = new HashMap<String, DamageSource>();
            try {
                for (Field field : DamageSource.class.getDeclaredFields()) {
                    field.setAccessible(true);
                    if (!Modifier.isStatic(field.getModifiers()) || field.getType() != DamageSource.class) continue;
                    DamageSource s = (DamageSource)field.get(null);
                    damageSourceMap.put(s.func_76355_l(), s);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DamageSource s = damageSourceMap.getOrDefault(source, DamageSource.field_76377_j);
        this.minecraftEntity.func_70097_a(s, hp);
    }

    public void attack(float hp) {
        this.minecraftEntity.func_70097_a(DamageSource.field_76377_j, hp);
    }

    public RayTraceResultJS rayTrace(double distance) {
        double xRot = this.minecraftEntity.field_70125_A;
        double yRot = this.minecraftEntity.field_70177_z;
        Vector3d fromPos = this.minecraftEntity.func_174824_e(1.0f);
        double x0 = Math.sin(-yRot * (Math.PI / 180) - 3.1415927410125732);
        double z0 = Math.cos(-yRot * (Math.PI / 180) - 3.1415927410125732);
        double y0 = -Math.cos(-xRot * (Math.PI / 180));
        double y = Math.sin(-xRot * (Math.PI / 180));
        double x = x0 * y0;
        double z = z0 * y0;
        Vector3d toPos = fromPos.func_72441_c(x * distance, y * distance, z * distance);
        BlockRayTraceResult hitResult = this.minecraftEntity.field_70170_p.func_217299_a(new RayTraceContext(fromPos, toPos, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, this.minecraftEntity));
        return new RayTraceResultJS(this, (RayTraceResult)hitResult, distance);
    }

    public boolean isInWater() {
        return this.minecraftEntity.func_70090_H();
    }

    public boolean isUnderWater() {
        return this.minecraftEntity.func_204231_K();
    }

    public double getDistanceSq(double x, double y, double z) {
        return this.minecraftEntity.func_70092_e(x, y, z);
    }

    public double getDistance(double x, double y, double z) {
        return Math.sqrt(this.getDistanceSq(x, y, z));
    }

    public double getDistanceSq(BlockPos pos) {
        return this.getDistanceSq((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public double getDistance(BlockPos pos) {
        return Math.sqrt(this.getDistanceSq(pos));
    }
}

