/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.mixin.coremods;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.IConnectionTemplate;
import blusunrize.immersiveengineering.common.wires.WireTemplateHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Template.class})
public abstract class TemplateMixin
implements IConnectionTemplate {
    private final List<Connection> connections = new ArrayList<Connection>();

    @Inject(method={"fillFromWorld"}, at={@At(value="HEAD")})
    public void takeConnectionsFromWorld(World worldIn, BlockPos startPos, BlockPos size, boolean takeEntities, Block toIgnore, CallbackInfo ci) {
        WireTemplateHelper.fillConnectionsInArea(worldIn, startPos, size, this);
    }

    @Inject(method={"placeInWorld(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Ljava/util/Random;I)Z"}, at={@At(value="RETURN")})
    public void addConnectionsToWorld(IServerWorld iworld, BlockPos startPos, BlockPos p_237146_3_, PlacementSettings orientation, Random p_237146_5_, int p_237146_6_, CallbackInfoReturnable<Boolean> cir) {
        if (cir.getReturnValue() == Boolean.TRUE) {
            WireTemplateHelper.addConnectionsFromTemplate(iworld, this, orientation, startPos);
        }
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    public void writeConnectionsToNBT(CompoundNBT $, CallbackInfoReturnable<CompoundNBT> cir) {
        WireTemplateHelper.addConnectionsToNBT(this, (CompoundNBT)cir.getReturnValue());
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    public void readConnectionsFromNBT(CompoundNBT compound, CallbackInfo ci) {
        WireTemplateHelper.readConnectionsFromNBT(compound, this);
    }

    @Override
    public List<Connection> getStoredConnections() {
        return this.connections;
    }
}

