/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.gardentools.item;

import com.lothrazar.gardentools.ConfigManager;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

public class ItemWatering
extends Item {
    private static final double PCT_GROW_IF_LESS = 0.1;

    public ItemWatering(Item.Properties builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip");
        t.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)t);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (context.func_196000_l() == Direction.DOWN) {
            return ActionResultType.FAIL;
        }
        int range = (Integer)ConfigManager.WATERING_RANGE.get();
        BlockPos pos = context.func_195995_a();
        Stream shape = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range));
        shape.forEach(posCurrent -> {
            int moisture;
            BlockState bs = world.func_180495_p(posCurrent);
            if (bs.func_235901_b_((Property)FarmlandBlock.field_176531_a) && (moisture = ((Integer)bs.func_177229_b((Property)FarmlandBlock.field_176531_a)).intValue()) < 7) {
                world.func_180501_a(posCurrent, (BlockState)bs.func_206870_a((Property)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(7)), 3);
                world.func_195594_a((IParticleData)ParticleTypes.field_197600_K, (double)posCurrent.func_177958_n(), (double)posCurrent.func_177956_o(), (double)posCurrent.func_177952_p(), 0.0, 0.0, 0.0);
            }
            Block plantBlock = bs.func_177230_c();
            if ((this.hasAgeProperty(bs) || plantBlock instanceof IGrowable || plantBlock instanceof IPlantable) && world.field_73012_v.nextDouble() < 0.1) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197600_K, (double)posCurrent.func_177958_n(), (double)posCurrent.func_177956_o(), (double)posCurrent.func_177952_p(), 0.0, 0.0, 0.0);
                if (world instanceof ServerWorld) {
                    bs.func_227034_b_((ServerWorld)world, posCurrent, field_77697_d);
                }
            }
        });
        return ActionResultType.SUCCESS;
    }

    private boolean hasAgeProperty(BlockState bs) {
        for (Property p : bs.func_235904_r_()) {
            if (p == null || p.func_177701_a() == null || !(p instanceof IntegerProperty) || !p.func_177701_a().equalsIgnoreCase("age")) continue;
            return true;
        }
        return false;
    }
}

