/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.gardentools.item;

import com.lothrazar.gardentools.GardenMod;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemTiller
extends HoeItem {
    public ItemTiller(IItemTier tier, Item.Properties builder) {
        super(tier, -4, 0.0f, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip");
        t.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)t);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_196000_l() == Direction.DOWN) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockPos center = context.func_195995_a();
        Direction face = context.func_195992_f();
        BlockPos blockpos = null;
        for (int dist = 0; dist < GardenMod.CONFIG.getTillingRange(); ++dist) {
            blockpos = center.func_177967_a(face, dist);
            if (world.func_175623_d(blockpos)) {
                if (!world.func_175623_d((blockpos = blockpos.func_177977_b()).func_177984_a()) || !this.hoeBlock(context, blockpos)) continue;
                center = center.func_177977_b();
                continue;
            }
            if (world.func_175623_d(blockpos.func_177984_a())) {
                this.hoeBlock(context, blockpos);
                continue;
            }
            if (!world.func_175623_d((blockpos = blockpos.func_177984_a()).func_177984_a()) || !this.hoeBlock(context, blockpos)) continue;
            center = center.func_177984_a();
        }
        return ActionResultType.SUCCESS;
    }

    private boolean hoeBlock(ItemUseContext context, BlockPos blockpos) {
        World world = context.func_195991_k();
        Block blockHere = world.func_180495_p(blockpos).func_177230_c();
        BlockState blockstate = (BlockState)field_195973_b.get(blockHere);
        if (blockstate != null && world.func_180501_a(blockpos, blockstate = this.moisturize(blockstate), 11)) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (playerentity != null) {
                context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p -> p.func_213334_d(context.func_221531_n()));
            }
            return true;
        }
        return false;
    }

    private BlockState moisturize(BlockState blockstate) {
        try {
            if (blockstate.func_177230_c() == Blocks.field_150458_ak && GardenMod.CONFIG.getMoisture() > 0) {
                blockstate = (BlockState)blockstate.func_206870_a((Property)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(GardenMod.CONFIG.getMoisture()));
            }
        }
        catch (Exception e) {
            GardenMod.LOGGER.error("ItemTiller Moisturize error", (Throwable)e);
        }
        return blockstate;
    }
}

