/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.gardentools.block.feeder;

import com.lothrazar.gardentools.ConfigManager;
import com.lothrazar.gardentools.GardenMod;
import com.lothrazar.gardentools.GardenRegistry;
import com.lothrazar.gardentools.UtilFakePlayer;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;

public class TileFeeder
extends TileEntity
implements ITickableTileEntity {
    private WeakReference<FakePlayer> fakePlayer;

    public TileFeeder() {
        super(GardenRegistry.FEEDERTILE);
    }

    public WeakReference<FakePlayer> setupBeforeTrigger(ServerWorld sw, String name, UUID uuid) {
        WeakReference<FakePlayer> fakePlayer = UtilFakePlayer.initFakePlayer(sw, uuid, name);
        if (fakePlayer == null) {
            GardenMod.LOGGER.error("Fake player failed to init " + name + " " + uuid);
            return null;
        }
        ((FakePlayer)fakePlayer.get()).func_70107_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        return fakePlayer;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L) {
            return;
        }
        if (this.field_145850_b instanceof ServerWorld && this.fakePlayer == null) {
            this.fakePlayer = this.setupBeforeTrigger((ServerWorld)this.field_145850_b, "rancher", UUID.randomUUID());
        }
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        int radius = (Integer)ConfigManager.FEEDER_RANGE.get();
        AxisAlignedBB aabb = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_186662_g((double)radius).func_72321_a(0.0, (double)this.field_145850_b.func_217301_I(), 0.0);
        List itemEntities = this.field_145850_b.func_217357_a(ItemEntity.class, aabb);
        List list = this.field_145850_b.func_217357_a(AnimalEntity.class, aabb);
        for (AnimalEntity entity : list) {
            ItemEntity eiBreedingItem;
            if (entity == null || this.fakePlayer == null || this.fakePlayer.get() == null || entity.func_70631_g_() || (eiBreedingItem = this.findBreedingItem(itemEntities, entity)) == null) continue;
            ((FakePlayer)this.fakePlayer.get()).func_184611_a(Hand.MAIN_HAND, eiBreedingItem.func_92059_d());
            ActionResultType result = entity.func_230254_b_((PlayerEntity)this.fakePlayer.get(), Hand.MAIN_HAND);
            if (result != ActionResultType.CONSUME && result != ActionResultType.SUCCESS) continue;
            eiBreedingItem.func_92058_a(((FakePlayer)this.fakePlayer.get()).func_184614_ca());
        }
    }

    private ItemEntity findBreedingItem(List<ItemEntity> itemEntities, AnimalEntity entity) {
        for (ItemEntity ei : itemEntities) {
            if (!ei.func_70089_S() || !entity.func_70877_b(ei.func_92059_d())) continue;
            return ei;
        }
        return null;
    }
}

