/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.gardentools;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigManager {
    private static final ForgeConfigSpec.Builder CFG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec COMMON_CONFIG;
    private static ForgeConfigSpec.IntValue TILLING_RANGE;
    private static ForgeConfigSpec.IntValue IRRIG_RANGE;
    private static ForgeConfigSpec.IntValue MOISTURE;
    private static ForgeConfigSpec.IntValue PLANTER_RANGE;
    public static ForgeConfigSpec.IntValue WATERING_RANGE;
    public static ForgeConfigSpec.IntValue FERT_POWER;
    public static ForgeConfigSpec.IntValue FEEDER_RANGE;
    public static ForgeConfigSpec.IntValue RANCHER_RANGE;
    public static ForgeConfigSpec.DoubleValue SPEEDCLOSE;
    public static ForgeConfigSpec.DoubleValue SPEEDFAR;
    public static ForgeConfigSpec.IntValue MAGNET_RANGE;
    public static ForgeConfigSpec.BooleanValue WATERSRC;

    private static void initConfig() {
        CFG.comment("General settings").push("gardentools");
        TILLING_RANGE = CFG.comment("\r\nRange of cultivator item").defineInRange("cultivator.range", 9, 2, 32);
        PLANTER_RANGE = CFG.comment("\r\nRange of planter item").defineInRange("planter.range", 9, 2, 32);
        IRRIG_RANGE = CFG.comment("\r\nWatering radius of irrigation block").defineInRange("irrigator.radius", 8, 1, 64);
        WATERSRC = CFG.comment("\r\nIs this a water source for buckets and capabilities").define("irrigator.water_source", true);
        MOISTURE = CFG.comment("\r\nMoisture level set by cultivator").defineInRange("cultivator.moisture", 7, 0, 7);
        WATERING_RANGE = CFG.comment("\r\nWatering can range").defineInRange("watering.range", 4, 1, 32);
        FERT_POWER = CFG.comment("\r\nThe bonemeal-power of the fertilizer").defineInRange("fertilizer.power", 6, 1, 32);
        FEEDER_RANGE = CFG.comment("\r\nLivestock Feeder range").defineInRange("feeder.range", 8, 1, 32);
        RANCHER_RANGE = CFG.comment("\r\nLivestock Rancher range").defineInRange("rancher.range", 8, 1, 32);
        MAGNET_RANGE = CFG.comment("\r\nMagnet max range").defineInRange("magnet.range", 16, 1, 256);
        SPEEDCLOSE = CFG.comment("\r\nMagnet speed when items are close within 3 blocks").defineInRange("magnet.speed.close", (double)0.07f, (double)0.01f, 0.5);
        SPEEDCLOSE = CFG.comment("\r\nMagnet speed when items are farther out than 3 blocks").defineInRange("magnet.speed.far", (double)0.31f, (double)0.01f, (double)0.99f);
        CFG.pop();
        COMMON_CONFIG = CFG.build();
    }

    public ConfigManager(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        COMMON_CONFIG.setConfig((CommentedConfig)configData);
    }

    public int getTillingRange() {
        return (Integer)TILLING_RANGE.get();
    }

    public int getPlantingRange() {
        return (Integer)PLANTER_RANGE.get();
    }

    public int getIrrigationRange() {
        return (Integer)IRRIG_RANGE.get();
    }

    public int getMoisture() {
        return (Integer)MOISTURE.get();
    }

    static {
        ConfigManager.initConfig();
    }
}

