/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryUtils {
    public static void dropInventoryItems(World world, BlockPos pos, IItemHandler itemHandler) {
        Random random = new Random();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemStack = itemHandler.getStackInSlot(i);
            if (itemStack.func_190926_b()) continue;
            float offsetX = random.nextFloat() * 0.8f + 0.1f;
            float offsetY = random.nextFloat() * 0.8f + 0.1f;
            float offsetZ = random.nextFloat() * 0.8f + 0.1f;
            while (!itemStack.func_190926_b()) {
                int stackSize = Math.min(itemStack.func_190916_E(), random.nextInt(21) + 10);
                ItemEntity entityitem = new ItemEntity(world, (double)pos.func_177958_n() + (double)offsetX, (double)pos.func_177956_o() + (double)offsetY, (double)pos.func_177952_p() + (double)offsetZ, new ItemStack((IItemProvider)itemStack.func_77973_b(), stackSize));
                if (itemStack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
                }
                itemStack.func_190918_g(stackSize);
                float motionScale = 0.05f;
                entityitem.func_213293_j(random.nextGaussian() * (double)motionScale, random.nextGaussian() * (double)motionScale + 0.2, random.nextGaussian() * (double)motionScale);
                world.func_217376_c((Entity)entityitem);
            }
        }
    }

    public static LazyOptional<IItemHandler> getInventory(World world, BlockPos pos, @Nullable Direction side) {
        TileEntity te = world.func_175625_s(pos);
        return te == null ? LazyOptional.empty() : te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }

    public static int transferItems(IItemHandler from, IItemHandler to, int slot, int count) {
        if (from == null || to == null || count == 0) {
            return 0;
        }
        ItemStack toSend = from.extractItem(slot, count, true);
        if (toSend.func_190926_b()) {
            return 0;
        }
        ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)toSend, (boolean)false);
        int inserted = toSend.func_190916_E() - excess.func_190916_E();
        from.extractItem(slot, inserted, false);
        return inserted;
    }

    public static boolean dropItems(World world, Vector3d pos, ItemStack stack) {
        if (!world.field_72995_K) {
            ItemEntity item = new ItemEntity(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), stack);
            return world.func_217376_c((Entity)item);
        }
        return true;
    }

    public static int countItems(ItemStack toCount, IItemHandler handler, int max, boolean matchMeta) {
        int count = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            boolean match;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            boolean bl = match = matchMeta ? stack.func_77969_a(toCount) : stack.func_185136_b(toCount);
            if (match) {
                count += stack.func_190916_E();
            }
            if (count < max) continue;
            return max;
        }
        return count;
    }
}

