/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.util;

import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class BeamData {
    private final BlockPos dest;
    private final int color;
    private final int duration;
    private final ItemStack stack;
    private boolean itemFade;
    private boolean reversed;
    private int ticksLived = 0;

    public BeamData(int duration, BlockPos dest, ItemStack stack, int color) {
        this.duration = duration;
        this.dest = dest;
        this.stack = stack;
        this.color = color;
    }

    public BeamData(int duration, BlockPos dest, int color) {
        this.duration = duration;
        this.dest = dest;
        this.stack = ItemStack.field_190927_a;
        this.color = color;
    }

    public BeamData(PacketBuffer buf, BlockPos pos1) {
        byte x = buf.readByte();
        byte y = buf.readByte();
        byte z = buf.readByte();
        this.dest = pos1.func_177982_a((int)(-x), (int)(-y), (int)(-z));
        this.color = buf.readInt();
        this.duration = buf.func_150792_a();
        this.stack = buf.func_150791_c();
        if (!this.stack.func_190926_b()) {
            this.itemFade = buf.readBoolean();
            this.reversed = buf.readBoolean();
        }
    }

    public void toBytes(PacketBuffer buf, BlockPos pos1) {
        buf.writeByte(pos1.func_177958_n() - this.dest.func_177958_n());
        buf.writeByte(pos1.func_177956_o() - this.dest.func_177956_o());
        buf.writeByte(pos1.func_177952_p() - this.dest.func_177952_p());
        buf.writeInt(this.color);
        buf.func_150787_b(this.duration);
        buf.func_150788_a(this.stack);
        if (!this.stack.func_190926_b()) {
            buf.writeBoolean(this.itemFade);
            buf.writeBoolean(this.reversed);
        }
    }

    public BeamData reverseItems() {
        this.reversed = true;
        return this;
    }

    public BeamData fadeItems() {
        this.itemFade = true;
        return this;
    }

    public Vector3d getStart(Vector3d basePos) {
        return this.reversed ? Vector3d.func_237489_a_((Vector3i)this.dest) : basePos;
    }

    public Vector3d getEnd(Vector3d basePos) {
        return this.reversed ? basePos : Vector3d.func_237489_a_((Vector3i)this.dest);
    }

    public AxisAlignedBB getAABB(BlockPos basePos) {
        return new AxisAlignedBB(basePos, this.dest);
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isItemFade() {
        return this.itemFade;
    }

    public float getProgress(float partialTicks) {
        return MathHelper.func_76131_a((float)(((float)(this.ticksLived - 1) + partialTicks) / (float)this.duration), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        ++this.ticksLived;
    }

    public boolean isExpired() {
        return this.ticksLived > this.duration;
    }

    public int[] getRGB() {
        int[] res = new int[]{this.color >> 16 & 0xFF, this.color >> 8 & 0xFF, this.color & 0xFF};
        return res;
    }

    public boolean isReversed() {
        return this.reversed;
    }
}

