/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.item_beam;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.client.render.ModRenderTypes;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.util.BeamData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class ItemBeamTileRenderer
extends TileEntityRenderer<TileEntityItemRouter> {
    private static final Vector3f ROTATION = new Vector3f(0.15f, 1.0f, 0.0f);

    public ItemBeamTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileEntityItemRouter te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        Vector3d routerVec = Vector3d.func_237489_a_((Vector3i)te.func_174877_v());
        for (BeamData beam : te.beams) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(-routerVec.func_82615_a(), -routerVec.func_82617_b(), -routerVec.func_82616_c());
            Vector3d startPos = beam.getStart(routerVec);
            Vector3d endPos = beam.getEnd(routerVec);
            float progress = beam.getProgress(partialTicks);
            if (MRConfig.Client.Misc.renderFlyingItems) {
                this.renderFlyingItem(beam, matrixStack, buffer, progress, startPos, endPos);
            }
            this.renderBeamLine(beam, matrixStack, buffer, progress, startPos, endPos);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    private void renderFlyingItem(BeamData beam, MatrixStack matrixStack, IRenderTypeBuffer buffer, float progress, Vector3d startPos, Vector3d endPos) {
        double iz;
        double iy;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        double ix = MathHelper.func_219803_d((double)progress, (double)startPos.func_82615_a(), (double)endPos.func_82615_a());
        BlockPos pos = new BlockPos(ix, iy = MathHelper.func_219803_d((double)progress, (double)startPos.func_82617_b(), (double)endPos.func_82617_b()), iz = MathHelper.func_219803_d((double)progress, (double)startPos.func_82616_c(), (double)endPos.func_82616_c()));
        VoxelShape shape = world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos);
        if (shape.func_197766_b() || !shape.func_197752_a().func_186670_a(pos).func_197744_e(ix, iy, iz)) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(ix, iy - 0.15, iz);
            matrixStack.func_227863_a_(ROTATION.func_229187_a_(progress * 360.0f));
            if (beam.isItemFade()) {
                matrixStack.func_227861_a_(0.0, 0.15, 0.0);
                matrixStack.func_227862_a_(1.15f - progress, 1.15f - progress, 1.15f - progress);
                if ((double)progress > 0.95 && world.field_73012_v.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, endPos.func_82615_a(), endPos.func_82617_b(), endPos.func_82616_c(), 0.5 - world.field_73012_v.nextDouble(), -0.5, 0.5 - world.field_73012_v.nextDouble());
                }
            }
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(beam.getStack(), ItemCameraTransforms.TransformType.GROUND, 0xF000F0, OverlayTexture.field_229196_a_, matrixStack, buffer);
            matrixStack.func_227865_b_();
        }
    }

    private void renderBeamLine(BeamData beam, MatrixStack matrixStack, IRenderTypeBuffer buffer, float progress, Vector3d startPos, Vector3d endPos) {
        int alpha = (int)(MathHelper.func_76126_a((float)((float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % 20L) / 20.0f * (float)Math.PI)) * 128.0f + 32.0f);
        int[] colors = beam.getRGB();
        Matrix4f positionMatrix = matrixStack.func_227866_c_().func_227870_a_();
        IVertexBuilder builder = buffer.getBuffer(ModRenderTypes.BEAM_LINE_THICK);
        ClientUtil.posF(builder, positionMatrix, startPos).func_225586_a_(colors[0], colors[1], colors[2], alpha).func_181675_d();
        ClientUtil.posF(builder, positionMatrix, endPos).func_225586_a_(colors[0], colors[1], colors[2], alpha).func_181675_d();
        IVertexBuilder builder2 = buffer.getBuffer(ModRenderTypes.BEAM_LINE_THIN);
        ClientUtil.posF(builder2, positionMatrix, startPos).func_225586_a_(colors[0], colors[1], colors[2], 192).func_181675_d();
        ClientUtil.posF(builder2, positionMatrix, endPos).func_225586_a_(colors[0], colors[1], colors[2], 192).func_181675_d();
    }
}

