/*
 * Decompiled with CFR 0.152.
 */
package commoble.entitydetectors.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import commoble.entitydetectors.blocks.MobDetectorTileEntity;
import commoble.entitydetectors.client.FakeClientEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class MobDetectorTileEntityRenderer
extends TileEntityRenderer<MobDetectorTileEntity> {
    private static final float DEGREES_PER_ROTATION = 360.0f;
    private static final float ROTATIONS_PER_SECOND = 0.5f;
    private static final float SECONDS_PER_TICK = 0.05f;
    private static final float DEGREES_PER_TICK = 9.0f;
    private static final double MIN_RENDER_DISTANCE = 2.0;
    private static final double MAX_RENDER_DISTANCE = 5.0;
    private static final double MIN_RENDER_DISTANCE_SQ = 4.0;
    private static final double MAX_RENDER_DISTANCE_SQ = 25.0;
    private static final double DISTANCE_DIFF = 21.0;

    public MobDetectorTileEntityRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    public void render(MobDetectorTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int intA, int intB) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && te.func_145831_w().func_175623_d(te.func_174877_v().func_177984_a())) {
            World world = te.func_145831_w();
            FakeClientEntities.getOptionalFakeEntity(te.getFilteredEntityType(), world).ifPresent(entity -> this.renderFakeEntity(te, player, (Entity)entity, partialTicks, matrix, buffer, intA));
        }
    }

    public void renderFakeEntity(MobDetectorTileEntity te, ClientPlayerEntity player, Entity entity, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int intA) {
        double extraZ;
        double extraY;
        BlockPos pos = te.func_174877_v();
        double teX = (double)pos.func_177958_n() + 0.5;
        double teY = (double)pos.func_177956_o() + 0.5;
        double teZ = (double)pos.func_177952_p() + 0.5;
        Vector3d vel = player.func_213322_ci();
        double extraX = vel.func_82615_a() * (double)partialTicks;
        double playerDistanceSq = player.func_70092_e(teX - extraX, teY - (extraY = vel.func_82617_b() * (double)partialTicks), teZ - (extraZ = vel.func_82616_c() * (double)partialTicks));
        if (playerDistanceSq < 25.0) {
            double distFactor = 1.0 - Math.min(playerDistanceSq - 4.0, 21.0) / 21.0;
            long gameTicks = te.func_145831_w().func_82737_E();
            float renderTicks = (float)gameTicks + partialTicks;
            float rotation = renderTicks * 9.0f % 360.0f;
            matrix.func_227860_a_();
            float entityScale = 0.53125f;
            entityScale = (float)((double)entityScale * ((double)0.8f * distFactor));
            float scaleDivisor = Math.max(entity.func_213311_cf(), entity.func_213302_cg());
            if ((double)scaleDivisor > 1.0) {
                entityScale /= scaleDivisor;
            }
            EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            renderManager.func_178633_a(false);
            entity.func_70107_b(teX, teY, teZ);
            matrix.func_227861_a_(0.5, 1.0, 0.5);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
            matrix.func_227862_a_(entityScale, entityScale, entityScale);
            renderManager.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, matrix, buffer, intA);
            renderManager.func_178633_a(true);
            matrix.func_227865_b_();
        }
    }
}

