/*
 * Decompiled with CFR 0.152.
 */
package commoble.entitydetectors.blocks;

import commoble.entitydetectors.EntityDetectors;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class EntityDetectorBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final IntegerProperty LEVEL = BlockStateProperties.field_208130_ae;
    public static final AxisAlignedBB CUBE_BOX = VoxelShapes.func_197868_b().func_197752_a();
    public final Class<? extends Entity> entityClass;

    public EntityDetectorBlock(Class<? extends Entity> entityClass, AbstractBlock.Properties properties) {
        super(properties);
        this.entityClass = entityClass;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public abstract <T extends Entity> Predicate<T> getEntityFilter(IWorld var1, BlockPos var2);

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED, LEVEL});
    }

    public static int getLightValue(BlockState state) {
        return (Boolean)state.func_177229_b((Property)POWERED) != false ? 7 : 0;
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return true;
    }

    @Deprecated
    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    @Deprecated
    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) != false ? 15 : 0;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (state.func_235901_b_((Property)LEVEL)) {
            int oldLevel = (Integer)state.func_177229_b((Property)LEVEL);
            int newLevel = (oldLevel + 1) % 4;
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LEVEL, (Comparable)Integer.valueOf(newLevel)));
            this.onUpdate(state, (IWorld)world, pos);
            float volume = 0.25f + world.field_73012_v.nextFloat() * 0.1f;
            float pitch = 0.5f + world.field_73012_v.nextFloat() * 0.1f;
            world.func_184133_a(null, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, volume, pitch);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        this.onUpdate(state, (IWorld)world, pos);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177230_c() != oldState.func_177230_c()) {
            this.onUpdate(state, (IWorld)worldIn, pos);
        }
    }

    public void onUpdate(BlockState state, IWorld world, BlockPos pos) {
        BlockState actualState = world.func_180495_p(pos);
        if (!world.func_201670_d() && actualState.func_235901_b_((Property)LEVEL) && actualState.func_235901_b_((Property)POWERED)) {
            int level = (Integer)actualState.func_177229_b((Property)LEVEL);
            double radius = 2.0 * Math.pow(2.0, level);
            double radiusSquared = radius * radius;
            AxisAlignedBB aabb = CUBE_BOX.func_186670_a(pos).func_186662_g(radius);
            Vector3d center = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            boolean areEntitiesNear = world.func_175647_a(this.entityClass, aabb, this.getEntityFilter(world, pos)).stream().anyMatch(entity -> entity.func_195048_a(center) < radiusSquared);
            if (areEntitiesNear != (Boolean)actualState.func_177229_b((Property)POWERED)) {
                world.func_180501_a(pos, (BlockState)actualState.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(areEntitiesNear)), 3);
            }
            world.func_205220_G_().func_205360_a(pos, (Object)this, EntityDetectors.config.refreshRate.get().intValue());
        }
    }
}

