/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.net;

import java.util.function.Supplier;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageTransferStack {
    private final int id;
    private final int slotNumber;

    public MessageTransferStack(int id, int slotNumber) {
        this.id = id;
        this.slotNumber = slotNumber;
    }

    public static void encode(MessageTransferStack message, PacketBuffer buf) {
        buf.writeByte(message.id);
        buf.writeInt(message.slotNumber);
    }

    public static MessageTransferStack decode(PacketBuffer buf) {
        byte id = buf.readByte();
        int slotNumber = buf.readInt();
        return new MessageTransferStack(id, slotNumber);
    }

    public static void handle(MessageTransferStack message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            Container container = player.field_71070_bA;
            if (container == null || message.slotNumber < 0 || message.slotNumber >= container.field_75151_b.size()) {
                return;
            }
            TweakProvider<Container> tweakProvider = CraftingTweaksProviderManager.getProvider(container);
            if (tweakProvider == null) {
                return;
            }
            Slot slot = (Slot)container.field_75151_b.get(message.slotNumber);
            if (!tweakProvider.canTransferFrom((PlayerEntity)player, container, message.id, slot) || slot instanceof CraftingResultSlot) {
                return;
            }
            ItemStack slotStack = slot.func_75211_c();
            if (!slotStack.func_190926_b() && slot.func_82869_a((PlayerEntity)player)) {
                ItemStack oldStack = slotStack.func_77946_l();
                if (!tweakProvider.transferIntoGrid((PlayerEntity)player, container, message.id, slot)) {
                    return;
                }
                slot.func_75220_a(slotStack, oldStack);
                if (slotStack.func_190916_E() <= 0) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                if (slotStack.func_190916_E() != oldStack.func_190916_E()) {
                    slot.func_190901_a((PlayerEntity)player, slotStack);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

