/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api;

import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;

public interface TweakProvider<T extends Container> {
    public String getModId();

    public boolean load();

    default public boolean requiresServerSide() {
        return true;
    }

    default public int getCraftingGridStart(PlayerEntity entityPlayer, T container, int id) {
        return 1;
    }

    default public int getCraftingGridSize(PlayerEntity entityPlayer, T container, int id) {
        return 9;
    }

    public void clearGrid(PlayerEntity var1, T var2, int var3, boolean var4);

    public void rotateGrid(PlayerEntity var1, T var2, int var3, boolean var4);

    public void balanceGrid(PlayerEntity var1, T var2, int var3);

    public void spreadGrid(PlayerEntity var1, T var2, int var3);

    public boolean canTransferFrom(PlayerEntity var1, T var2, int var3, Slot var4);

    public boolean transferIntoGrid(PlayerEntity var1, T var2, int var3, Slot var4);

    public ItemStack putIntoGrid(PlayerEntity var1, T var2, int var3, ItemStack var4, int var5);

    @Nullable
    public IInventory getCraftMatrix(PlayerEntity var1, T var2, int var3);

    @OnlyIn(value=Dist.CLIENT)
    public void initGui(ContainerScreen<T> var1, GuiScreenEvent.InitGuiEvent var2);

    default public boolean isValidContainer(Container container) {
        return true;
    }
}

