/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.util.EnumUtils;
import net.minecraft.util.Direction;

public class ConfigInfo {
    private final Supplier<Direction> facingSupplier;
    private boolean canEject;
    private boolean ejecting;
    private final Map<RelativeSide, DataType> sideConfig;
    private final Map<DataType, ISlotInfo> slotInfo;
    private final Map<Object, List<DataType>> containerTypeMapping;
    private Set<RelativeSide> disabledSides;

    public ConfigInfo(@Nonnull Supplier<Direction> facingSupplier) {
        this.facingSupplier = facingSupplier;
        this.canEject = true;
        this.ejecting = false;
        this.sideConfig = new EnumMap<RelativeSide, DataType>(RelativeSide.class);
        for (RelativeSide side : EnumUtils.SIDES) {
            this.sideConfig.put(side, DataType.NONE);
        }
        this.slotInfo = new EnumMap<DataType, ISlotInfo>(DataType.class);
        this.containerTypeMapping = new HashMap<Object, List<DataType>>();
    }

    public boolean canEject() {
        return this.canEject;
    }

    public void setCanEject(boolean canEject) {
        this.canEject = canEject;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void setEjecting(boolean ejecting) {
        this.ejecting = ejecting;
    }

    public void addDisabledSides(RelativeSide ... sides) {
        if (this.disabledSides == null) {
            this.disabledSides = EnumSet.noneOf(RelativeSide.class);
        }
        for (RelativeSide side : sides) {
            this.disabledSides.add(side);
            this.sideConfig.put(side, DataType.NONE);
        }
    }

    public boolean isSideEnabled(@Nonnull RelativeSide side) {
        if (this.disabledSides == null) {
            return true;
        }
        return !this.disabledSides.contains(side);
    }

    @Nonnull
    public DataType getDataType(@Nonnull RelativeSide side) {
        return this.sideConfig.get(side);
    }

    public void setDataType(@Nonnull DataType dataType, RelativeSide ... sides) {
        for (RelativeSide side : sides) {
            if (!this.isSideEnabled(side)) continue;
            this.sideConfig.put(side, dataType);
        }
    }

    @Nonnull
    public Set<DataType> getSupportedDataTypes() {
        EnumSet<DataType> dataTypes = EnumSet.of(DataType.NONE);
        dataTypes.addAll(this.slotInfo.keySet());
        return dataTypes;
    }

    public void fill(@Nonnull DataType dataType) {
        for (RelativeSide side : EnumUtils.SIDES) {
            this.setDataType(dataType, side);
        }
    }

    @Nullable
    public ISlotInfo getSlotInfo(@Nonnull RelativeSide side) {
        return this.getSlotInfo(this.getDataType(side));
    }

    @Nullable
    public ISlotInfo getSlotInfo(@Nonnull DataType dataType) {
        return this.slotInfo.get(dataType);
    }

    public void addSlotInfo(@Nonnull DataType dataType, @Nonnull ISlotInfo info) {
        block4: {
            block5: {
                block3: {
                    this.slotInfo.put(dataType, info);
                    if (!(info instanceof ChemicalSlotInfo)) break block3;
                    for (IChemicalTank tank : ((ChemicalSlotInfo)info).getTanks()) {
                        this.containerTypeMapping.computeIfAbsent(tank, t -> new ArrayList()).add(dataType);
                    }
                    break block4;
                }
                if (!(info instanceof FluidSlotInfo)) break block5;
                for (IExtendedFluidTank tank : ((FluidSlotInfo)info).getTanks()) {
                    this.containerTypeMapping.computeIfAbsent(tank, t -> new ArrayList()).add(dataType);
                }
                break block4;
            }
            if (!(info instanceof InventorySlotInfo)) break block4;
            for (IInventorySlot slot : ((InventorySlotInfo)info).getSlots()) {
                this.containerTypeMapping.computeIfAbsent(slot, t -> new ArrayList()).add(dataType);
            }
        }
    }

    public List<DataType> getDataTypeForContainer(Object container) {
        return this.containerTypeMapping.getOrDefault(container, new ArrayList());
    }

    public void setDefaults() {
        if (this.slotInfo.containsKey(DataType.INPUT)) {
            this.fill(DataType.INPUT);
        }
        if (this.slotInfo.containsKey(DataType.OUTPUT)) {
            this.setDataType(DataType.OUTPUT, RelativeSide.RIGHT);
        }
        if (this.slotInfo.containsKey(DataType.EXTRA)) {
            this.setDataType(DataType.EXTRA, RelativeSide.BOTTOM);
        }
        if (this.slotInfo.containsKey(DataType.ENERGY)) {
            this.setDataType(DataType.ENERGY, RelativeSide.BACK);
        }
    }

    public Set<Direction> getSidesForData(@Nonnull DataType dataType) {
        return this.getSides(type -> type == dataType);
    }

    public Set<Direction> getSides(Predicate<DataType> predicate) {
        Direction facing = this.facingSupplier.get();
        EnumSet<Direction> directions = null;
        for (Map.Entry<RelativeSide, DataType> entry : this.sideConfig.entrySet()) {
            if (!predicate.test(entry.getValue())) continue;
            if (directions == null) {
                directions = EnumSet.noneOf(Direction.class);
            }
            directions.add(entry.getKey().getDirection(facing));
        }
        return directions == null ? Collections.emptySet() : directions;
    }

    public Set<Direction> getAllOutputtingSides() {
        return this.getSides(DataType::canOutput);
    }

    public Set<Direction> getSidesForOutput(DataType outputType) {
        return this.getSides(type -> type == outputType || type == DataType.INPUT_OUTPUT);
    }

    @Nonnull
    public DataType incrementDataType(@Nonnull RelativeSide relativeSide) {
        DataType current = this.getDataType(relativeSide);
        if (this.isSideEnabled(relativeSide)) {
            Set<DataType> supportedDataTypes = this.getSupportedDataTypes();
            DataType newType = current.getNext(supportedDataTypes::contains);
            this.sideConfig.put(relativeSide, newType);
            return newType;
        }
        return current;
    }

    @Nonnull
    public DataType decrementDataType(@Nonnull RelativeSide relativeSide) {
        DataType current = this.getDataType(relativeSide);
        if (this.isSideEnabled(relativeSide)) {
            Set<DataType> supportedDataTypes = this.getSupportedDataTypes();
            DataType newType = current.getPrevious(supportedDataTypes::contains);
            this.sideConfig.put(relativeSide, newType);
            return newType;
        }
        return current;
    }
}

