/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketQIOItemViewerGuiSync
implements IMekanismPacket {
    private final Type type;
    private final Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap;
    private final long countCapacity;
    private final int typeCapacity;

    private PacketQIOItemViewerGuiSync(Type type, Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        this.type = type;
        this.itemMap = itemMap;
        this.countCapacity = countCapacity;
        this.typeCapacity = typeCapacity;
    }

    public static PacketQIOItemViewerGuiSync batch(Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        return new PacketQIOItemViewerGuiSync(Type.BATCH, itemMap, countCapacity, typeCapacity);
    }

    public static PacketQIOItemViewerGuiSync update(Object2LongMap<HashedItem.UUIDAwareHashedItem> itemMap, long countCapacity, int typeCapacity) {
        return new PacketQIOItemViewerGuiSync(Type.UPDATE, itemMap, countCapacity, typeCapacity);
    }

    public static PacketQIOItemViewerGuiSync kill() {
        return new PacketQIOItemViewerGuiSync(Type.UPDATE, null, 0L, 0);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.field_71070_bA instanceof QIOItemViewerContainer) {
            QIOItemViewerContainer container = (QIOItemViewerContainer)player.field_71070_bA;
            switch (this.type) {
                case BATCH: {
                    container.handleBatchUpdate(this.itemMap, this.countCapacity, this.typeCapacity);
                    break;
                }
                case UPDATE: {
                    container.handleUpdate(this.itemMap, this.countCapacity, this.typeCapacity);
                    break;
                }
                case KILL: {
                    container.handleKill();
                }
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.type);
        if (this.type == Type.BATCH || this.type == Type.UPDATE) {
            buffer.func_179254_b(this.countCapacity);
            buffer.func_150787_b(this.typeCapacity);
            buffer.func_150787_b(this.itemMap.size());
            this.itemMap.forEach((key, value) -> {
                buffer.func_150788_a(key.getStack());
                if (key.getUUID() == null) {
                    buffer.writeBoolean(false);
                } else {
                    buffer.writeBoolean(true);
                    buffer.func_179252_a(key.getUUID());
                }
                buffer.func_179254_b(value.longValue());
            });
        }
    }

    public static PacketQIOItemViewerGuiSync decode(PacketBuffer buffer) {
        Type type = (Type)buffer.func_179257_a(Type.class);
        long countCapacity = 0L;
        int typeCapacity = 0;
        Object2LongOpenHashMap map = null;
        if (type == Type.BATCH || type == Type.UPDATE) {
            countCapacity = buffer.func_179260_f();
            typeCapacity = buffer.func_150792_a();
            int count = buffer.func_150792_a();
            map = new Object2LongOpenHashMap(count);
            for (int i = 0; i < count; ++i) {
                map.put((Object)new HashedItem.UUIDAwareHashedItem(buffer.func_150791_c(), buffer.readBoolean() ? buffer.func_179253_g() : null), buffer.func_179260_f());
            }
        }
        return new PacketQIOItemViewerGuiSync(type, (Object2LongMap<HashedItem.UUIDAwareHashedItem>)map, countCapacity, typeCapacity);
    }

    public static enum Type {
        BATCH,
        UPDATE,
        KILL;

    }
}

