/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.multiblock.Structure;
import mekanism.common.tile.interfaces.ITileWrapper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;

public interface IMultiblockBase
extends ITileWrapper {
    default public MultiblockData getMultiblockData(MultiblockManager<?> manager) {
        MultiblockData data = this.getStructure(manager).getMultiblockData();
        if (data != null && data.isFormed()) {
            return data;
        }
        return this.getDefaultData();
    }

    default public void setMultiblockData(MultiblockManager<?> manager, MultiblockData multiblockData) {
        this.getStructure(manager).setMultiblockData(multiblockData);
    }

    public MultiblockData getDefaultData();

    public ActionResultType onActivate(PlayerEntity var1, Hand var2, ItemStack var3);

    public Structure getStructure(MultiblockManager<?> var1);

    public boolean hasStructure(Structure var1);

    public void setStructure(MultiblockManager<?> var1, Structure var2);

    default public Structure resetStructure(MultiblockManager<?> manager) {
        Structure structure = new Structure(this);
        this.setStructure(manager, structure);
        return structure;
    }

    default public void resetForFormed() {
    }
}

