/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.frequency;

import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityMode;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;

public abstract class Frequency {
    private String name;
    @Nullable
    private UUID ownerUUID;
    private String clientOwner;
    private boolean valid = true;
    private boolean publicFreq;
    private final FrequencyType<?> frequencyType;

    public Frequency(FrequencyType<?> frequencyType, String name, @Nullable UUID uuid) {
        this(frequencyType);
        this.name = name;
        this.ownerUUID = uuid;
    }

    public Frequency(FrequencyType<?> frequencyType) {
        this.frequencyType = frequencyType;
    }

    public void tick() {
    }

    public void onRemove() {
    }

    public void onDeactivate(TileEntity tile) {
    }

    public void update(TileEntity tile) {
    }

    public FrequencyType<?> getType() {
        return this.frequencyType;
    }

    public Object getKey() {
        return this.name;
    }

    public final SecurityMode getSecurity() {
        return this.isPublic() ? SecurityMode.PUBLIC : SecurityMode.PRIVATE;
    }

    public boolean isPublic() {
        return this.publicFreq;
    }

    public Frequency setPublic(boolean isPublic) {
        this.publicFreq = isPublic;
        return this;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public UUID getOwner() {
        return this.ownerUUID;
    }

    public boolean ownerMatches(UUID toCheck) {
        return Objects.equals(this.ownerUUID, toCheck);
    }

    public String getClientOwner() {
        return this.clientOwner;
    }

    public void writeComponentData(CompoundNBT nbtTags) {
        nbtTags.func_74778_a("name", this.name);
        if (this.ownerUUID != null) {
            nbtTags.func_186854_a("owner", this.ownerUUID);
        }
        nbtTags.func_74757_a("publicFreq", this.publicFreq);
    }

    public void write(CompoundNBT nbtTags) {
        this.writeComponentData(nbtTags);
    }

    protected void read(CompoundNBT nbtTags) {
        this.name = nbtTags.func_74779_i("name");
        NBTUtils.setUUIDIfPresent(nbtTags, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
        this.publicFreq = nbtTags.func_74767_n("publicFreq");
    }

    public void write(PacketBuffer buffer) {
        this.getType().write(buffer);
        buffer.func_180714_a(this.name);
        if (this.ownerUUID == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.func_179252_a(this.ownerUUID);
        }
        buffer.func_180714_a(MekanismUtils.getLastKnownUsername(this.ownerUUID));
        buffer.writeBoolean(this.publicFreq);
    }

    protected void read(PacketBuffer dataStream) {
        this.name = BasePacketHandler.readString(dataStream);
        this.ownerUUID = dataStream.readBoolean() ? dataStream.func_179253_g() : null;
        this.clientOwner = BasePacketHandler.readString(dataStream);
        this.publicFreq = dataStream.readBoolean();
    }

    public int getSyncHash() {
        return this.hashCode();
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.name.hashCode();
        if (this.ownerUUID != null) {
            code = 31 * code + this.ownerUUID.hashCode();
        }
        code = 31 * code + (this.publicFreq ? 1 : 0);
        return code;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Frequency) {
            Frequency other = (Frequency)obj;
            return this.publicFreq == other.publicFreq && this.ownerUUID != null && this.name.equals(other.name) && this.ownerUUID.equals(other.ownerUUID);
        }
        return false;
    }

    public FrequencyIdentity getIdentity() {
        return new FrequencyIdentity(this.getKey(), this.publicFreq);
    }

    public boolean areIdentitiesEqual(Frequency other) {
        return this.getIdentity().equals(other.getIdentity());
    }

    public CompoundNBT serializeIdentity() {
        return this.frequencyType.getIdentitySerializer().serialize(this.getIdentity());
    }

    public CompoundNBT serializeIdentityWithOwner() {
        CompoundNBT serializedIdentity = this.serializeIdentity();
        if (!serializedIdentity.func_186855_b("owner") && this.ownerUUID != null) {
            serializedIdentity.func_186854_a("owner", this.ownerUUID);
        }
        return serializedIdentity;
    }

    public static <FREQ extends Frequency> FREQ readFromPacket(PacketBuffer dataStream) {
        return FrequencyType.load(dataStream).create(dataStream);
    }

    public static class FrequencyIdentity {
        private final Object key;
        private final boolean publicFreq;

        public FrequencyIdentity(Object key, boolean publicFreq) {
            this.key = key;
            this.publicFreq = publicFreq;
        }

        public Object getKey() {
            return this.key;
        }

        public boolean isPublic() {
            return this.publicFreq;
        }

        public static FrequencyIdentity load(FrequencyType<?> type, CompoundNBT tag) {
            return type.getIdentitySerializer().load(tag);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.publicFreq ? 1231 : 1237);
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof FrequencyIdentity && ((FrequencyIdentity)obj).key.equals(this.key) && ((FrequencyIdentity)obj).publicFreq == this.publicFreq;
        }
    }
}

