/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import java.util.Optional;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.providers.IGasProvider;
import mekanism.api.text.EnumColor;
import mekanism.client.render.armor.CustomArmor;
import mekanism.client.render.armor.ScubaTankArmor;
import mekanism.client.render.item.ISTERProvider;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.BaseSpecialArmorMaterial;
import mekanism.common.item.gear.ItemGasArmor;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemScubaTank
extends ItemGasArmor
implements IItemHUDProvider,
IModeItem {
    private static final ScubaTankMaterial SCUBA_TANK_MATERIAL = new ScubaTankMaterial();

    public ItemScubaTank(Item.Properties properties) {
        super(SCUBA_TANK_MATERIAL, EquipmentSlotType.CHEST, properties.setISTER(ISTERProvider::scubaTank));
    }

    @Override
    protected LongSupplier getMaxGas() {
        return MekanismConfig.gear.scubaMaxGas;
    }

    @Override
    protected LongSupplier getFillRate() {
        return MekanismConfig.gear.scubaFillRate;
    }

    @Override
    protected IGasProvider getGasType() {
        return MekanismGases.OXYGEN;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)MekanismLang.FLOWING.translateColored(EnumColor.GRAY, BooleanStateDisplay.YesNo.of(this.getFlowing(stack), true)));
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public CustomArmor getGearModel() {
        return ScubaTankArmor.SCUBA_TANK;
    }

    public boolean getFlowing(ItemStack stack) {
        return ItemDataUtils.getBoolean(stack, "running");
    }

    public void setFlowing(ItemStack stack, boolean flowing) {
        ItemDataUtils.setBoolean(stack, "running", flowing);
    }

    @Override
    public void addHUDStrings(List<ITextComponent> list, PlayerEntity player, ItemStack stack, EquipmentSlotType slotType) {
        if (slotType == this.func_185083_B_()) {
            IGasHandler gasHandlerItem;
            ItemScubaTank scubaTank = (ItemScubaTank)stack.func_77973_b();
            list.add((ITextComponent)MekanismLang.SCUBA_TANK_MODE.translateColored(EnumColor.DARK_GRAY, BooleanStateDisplay.OnOff.of(scubaTank.getFlowing(stack), true)));
            GasStack stored = GasStack.EMPTY;
            Optional capability = stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).resolve();
            if (capability.isPresent() && (gasHandlerItem = (IGasHandler)capability.get()).getTanks() > 0) {
                stored = (GasStack)gasHandlerItem.getChemicalInTank(0);
            }
            list.add((ITextComponent)MekanismLang.GENERIC_STORED.translateColored(EnumColor.DARK_GRAY, MekanismGases.OXYGEN, EnumColor.ORANGE, stored.getAmount()));
        }
    }

    @Override
    public void changeMode(@Nonnull PlayerEntity player, @Nonnull ItemStack stack, int shift, boolean displayChangeMessage) {
        if (Math.abs(shift) % 2 == 1) {
            boolean newState = !this.getFlowing(stack);
            this.setFlowing(stack, newState);
            if (displayChangeMessage) {
                player.func_145747_a(MekanismUtils.logFormat(MekanismLang.FLOWING.translate(BooleanStateDisplay.OnOff.of(newState, true))), Util.field_240973_b_);
            }
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        stack.func_242395_a(ItemStack.TooltipDisplayFlags.MODIFIERS);
        return super.initCapabilities(stack, nbt);
    }

    @Override
    public boolean supportsSlotType(ItemStack stack, @Nonnull EquipmentSlotType slotType) {
        return slotType == this.func_185083_B_();
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    protected static class ScubaTankMaterial
    extends BaseSpecialArmorMaterial {
        protected ScubaTankMaterial() {
        }

        public String func_200897_d() {
            return "mekanism:scuba_tank";
        }
    }
}

