/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot.chemical;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.ItemStackToInfuseTypeRecipe;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class InfusionInventorySlot
extends ChemicalInventorySlot<InfuseType, InfusionStack> {
    @Nullable
    public static IInfusionHandler getCapability(ItemStack stack) {
        return InfusionInventorySlot.getCapability(stack, Capabilities.INFUSION_HANDLER_CAPABILITY);
    }

    private static InfusionStack getPotentialConversion(@Nullable World world, ItemStack itemStack) {
        return InfusionInventorySlot.getPotentialConversion(MekanismRecipeType.INFUSION_CONVERSION, world, itemStack, InfusionStack.EMPTY);
    }

    public static InfusionInventorySlot fillOrConvert(IInfusionTank infusionTank, Supplier<World> worldSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(infusionTank, "Infusion tank cannot be null");
        Objects.requireNonNull(worldSupplier, "World supplier cannot be null");
        Function<ItemStack, InfusionStack> potentialConversionSupplier = stack -> InfusionInventorySlot.getPotentialConversion((World)worldSupplier.get(), stack);
        return new InfusionInventorySlot(infusionTank, worldSupplier, InfusionInventorySlot.getFillOrConvertExtractPredicate(infusionTank, InfusionInventorySlot::getCapability, potentialConversionSupplier), InfusionInventorySlot.getFillOrConvertInsertPredicate(infusionTank, InfusionInventorySlot::getCapability, potentialConversionSupplier), stack -> {
            if (stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY).isPresent()) {
                return true;
            }
            InfusionStack conversion = InfusionInventorySlot.getPotentialConversion((World)worldSupplier.get(), stack);
            return !conversion.isEmpty() && infusionTank.isValid(conversion);
        }, listener, x, y);
    }

    private InfusionInventorySlot(IInfusionTank infusionTank, Supplier<World> worldSupplier, Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(infusionTank, worldSupplier, canExtract, canInsert, validator, listener, x, y);
    }

    @Override
    @Nullable
    protected IChemicalHandler<InfuseType, InfusionStack> getCapability() {
        return InfusionInventorySlot.getCapability(this.current);
    }

    @Nullable
    protected ItemStackToInfuseTypeRecipe getConversionRecipe(@Nullable World world, ItemStack stack) {
        return (ItemStackToInfuseTypeRecipe)MekanismRecipeType.INFUSION_CONVERSION.getInputCache().findFirstRecipe(world, stack);
    }
}

