/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.slot;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.inventory.AutomationType;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.IHasExtraData;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.slot.BasicInventorySlot;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;

public class VirtualCraftingOutputSlot
extends VirtualInventoryContainerSlot
implements IHasExtraData {
    @Nonnull
    private final QIOCraftingWindow craftingWindow;
    private boolean canCraft;
    private int amountCrafted;

    public VirtualCraftingOutputSlot(BasicInventorySlot slot, @Nullable SlotOverlay slotOverlay, Consumer<ItemStack> uncheckedSetter, @Nonnull QIOCraftingWindow craftingWindow) {
        super(slot, craftingWindow.getWindowData(), slotOverlay, uncheckedSetter);
        this.craftingWindow = craftingWindow;
    }

    @Override
    public boolean canMergeWith(@Nonnull ItemStack stack) {
        return false;
    }

    @Override
    public boolean func_75214_a(@Nonnull ItemStack stack) {
        return false;
    }

    @Override
    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, Action action) {
        return stack;
    }

    @Override
    @Nonnull
    public ItemStack func_75209_a(int amount) {
        ItemStack extracted = this.getInventorySlot().extractItem(amount, Action.SIMULATE, AutomationType.MANUAL);
        this.amountCrafted += extracted.func_190916_E();
        return extracted;
    }

    protected void func_75210_a(@Nonnull ItemStack stack, int amount) {
        this.amountCrafted += amount;
        this.func_75208_c(stack);
    }

    protected void func_190900_b(int numItemsCrafted) {
        this.amountCrafted += numItemsCrafted;
    }

    @Nonnull
    public ItemStack func_190901_a(@Nonnull PlayerEntity player, @Nonnull ItemStack stack) {
        ItemStack result = this.craftingWindow.performCraft(player, stack, this.amountCrafted);
        this.amountCrafted = 0;
        return result;
    }

    @Override
    public boolean func_82869_a(@Nonnull PlayerEntity player) {
        if (player.field_70170_p.field_72995_K || !(player instanceof ServerPlayerEntity)) {
            return this.canCraft && super.func_82869_a(player);
        }
        return this.craftingWindow.canViewRecipe((ServerPlayerEntity)player) && super.func_82869_a(player);
    }

    @Override
    @Nonnull
    public ItemStack getStackToRender() {
        return this.canCraft ? super.getStackToRender() : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack shiftClickSlot(@Nonnull PlayerEntity player, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots) {
        this.craftingWindow.performCraft(player, hotBarSlots, mainInventorySlots);
        return ItemStack.field_190927_a;
    }

    @Override
    public void addTrackers(PlayerEntity player, Consumer<ISyncableData> tracker) {
        if (player.field_70170_p.field_72995_K || !(player instanceof ServerPlayerEntity)) {
            tracker.accept(SyncableBoolean.create(() -> this.canCraft, value -> {
                this.canCraft = value;
            }));
        } else {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            tracker.accept(SyncableBoolean.create(() -> this.craftingWindow.canViewRecipe(serverPlayer), value -> {
                this.canCraft = value;
            }));
        }
    }
}

