/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.IQIOCraftingWindowHolder;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.IInsertableSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.CraftingWindowInventorySlot;
import mekanism.common.inventory.slot.CraftingWindowOutputInventorySlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.NonNullList;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Contract;

public class QIOCraftingWindow
implements IContentsListener {
    private static final SelectedWindowData[] WINDOWS = new SelectedWindowData[3];
    private final CraftingWindowInventorySlot[] inputSlots = new CraftingWindowInventorySlot[9];
    private final ReplacementHelper replacementHelper = new ReplacementHelper();
    private final RemainderHelper remainderHelper = new RemainderHelper();
    private final CraftingWindowOutputInventorySlot outputSlot;
    private final QIOCraftingInventory craftingInventory;
    private final IQIOCraftingWindowHolder holder;
    private final SelectedWindowData windowData;
    private final byte windowIndex;
    @Nullable
    private ICraftingRecipe lastRecipe;
    private boolean isCrafting;
    private boolean changedWhileCrafting;

    public QIOCraftingWindow(IQIOCraftingWindowHolder holder, byte windowIndex) {
        this.windowIndex = windowIndex;
        this.holder = holder;
        this.windowData = WINDOWS[windowIndex];
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            this.inputSlots[slotIndex] = CraftingWindowInventorySlot.input(this);
        }
        this.outputSlot = CraftingWindowOutputInventorySlot.create(this);
        this.craftingInventory = new QIOCraftingInventory();
    }

    public SelectedWindowData getWindowData() {
        return this.windowData;
    }

    public byte getWindowIndex() {
        return this.windowIndex;
    }

    public CraftingWindowInventorySlot getInputSlot(int slot) {
        if (slot < 0 || slot >= 9) {
            throw new IllegalArgumentException("Input slot out of range");
        }
        return this.inputSlots[slot];
    }

    public CraftingWindowOutputInventorySlot getOutputSlot() {
        return this.outputSlot;
    }

    public boolean isOutput(@Nonnull ItemStack stack) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)this.outputSlot.getStack(), (ItemStack)stack);
    }

    @Override
    public void onContentsChanged() {
        this.holder.onContentsChanged();
        if (this.isCrafting) {
            this.changedWhileCrafting = true;
        } else {
            World world = this.holder.getHolderWorld();
            if (world != null && !world.field_72995_K) {
                this.updateOutputSlot(world);
            }
        }
    }

    public void invalidateRecipe() {
        World world;
        this.lastRecipe = null;
        if (!this.outputSlot.isEmpty()) {
            this.outputSlot.setEmpty();
        }
        if ((world = this.holder.getHolderWorld()) != null && !world.field_72995_K) {
            this.updateOutputSlot(world);
        }
    }

    private void updateOutputSlot(@Nonnull World world) {
        if (world.func_73046_m() != null) {
            if (this.craftingInventory.func_191420_l()) {
                if (!this.outputSlot.isEmpty()) {
                    this.outputSlot.setEmpty();
                }
            } else if (this.lastRecipe != null && this.lastRecipe.func_77569_a((IInventory)this.craftingInventory, world)) {
                if (this.outputSlot.isEmpty()) {
                    this.outputSlot.setStack(this.lastRecipe.func_77572_b((IInventory)this.craftingInventory));
                }
            } else {
                ICraftingRecipe recipe = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftingInventory, world).orElse(null);
                if (recipe != this.lastRecipe) {
                    if (recipe == null) {
                        if (!this.outputSlot.isEmpty()) {
                            this.outputSlot.setEmpty();
                        }
                    } else {
                        this.lastRecipe = recipe;
                        this.outputSlot.setStack(this.lastRecipe.func_77572_b((IInventory)this.craftingInventory));
                    }
                }
            }
        }
    }

    public boolean canViewRecipe(@Nonnull ServerPlayerEntity player) {
        if (this.lastRecipe == null) {
            return false;
        }
        return this.lastRecipe.func_192399_d() || !player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223618_u) || player.func_192037_E().func_193830_f((IRecipe)this.lastRecipe);
    }

    @Contract(value="null, _ -> false")
    private boolean validateAndUnlockRecipe(@Nullable World world, @Nonnull PlayerEntity player) {
        if (world == null || this.lastRecipe == null || !this.lastRecipe.func_77569_a((IInventory)this.craftingInventory, world)) {
            return false;
        }
        if (this.lastRecipe != null && !this.lastRecipe.func_192399_d()) {
            if (player instanceof ServerPlayerEntity && world.func_82736_K().func_223586_b(GameRules.field_223618_u) && !((ServerPlayerEntity)player).func_192037_E().func_193830_f((IRecipe)this.lastRecipe)) {
                return false;
            }
            player.func_195065_a(Collections.singleton(this.lastRecipe));
        }
        return true;
    }

    private void craftingStarted(@Nonnull PlayerEntity player) {
        this.isCrafting = true;
        ForgeHooks.setCraftingPlayer((PlayerEntity)player);
    }

    private void craftingFinished(@Nonnull World world) {
        ForgeHooks.setCraftingPlayer(null);
        this.isCrafting = false;
        if (this.changedWhileCrafting) {
            this.changedWhileCrafting = false;
            this.updateOutputSlot(world);
        }
    }

    private int calculateMaxCraftAmount(@Nonnull ItemStack stack, @Nullable QIOFrequency frequency) {
        CraftingWindowInventorySlot inputSlot;
        int count;
        int outputSize = stack.func_190916_E();
        int inputSize = 64;
        CraftingWindowInventorySlot[] craftingWindowInventorySlotArray = this.inputSlots;
        int n = craftingWindowInventorySlotArray.length;
        for (int i = 0; i < n && ((count = (inputSlot = craftingWindowInventorySlotArray[i]).getCount()) <= 0 || count >= inputSize || (inputSize = count) != 1); ++i) {
        }
        if (inputSize > 1) {
            return inputSize * outputSize;
        }
        if (frequency == null) {
            return outputSize;
        }
        int maxToCraft = stack.func_77976_d();
        if (outputSize < maxToCraft) {
            maxToCraft -= maxToCraft % outputSize;
        }
        return maxToCraft;
    }

    private void useInput(IInventorySlot inputSlot) {
        MekanismUtils.logMismatchedStackSize(inputSlot.shrinkStack(1, Action.EXECUTE), 1L);
    }

    public void performCraft(@Nonnull PlayerEntity player, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots) {
        int crafted;
        if (this.lastRecipe == null || this.outputSlot.isEmpty()) {
            return;
        }
        World world = this.holder.getHolderWorld();
        if (!this.validateAndUnlockRecipe(world, player)) {
            return;
        }
        QIOFrequency frequency = this.holder.getFrequency();
        this.craftingStarted(player);
        ItemStack result = this.outputSlot.getStack().func_77946_l();
        Item resultItem = result.func_77973_b();
        resultItem.func_77622_d(result, world, player);
        Stat itemCraftedStat = Stats.field_188066_af.func_199076_b((Object)resultItem);
        int maxToCraft = this.calculateMaxCraftAmount(result, frequency);
        int amountPerCraft = result.func_190916_E();
        this.remainderHelper.reset();
        this.replacementHelper.reset();
        boolean recheckOutput = false;
        LastInsertTarget lastInsertTarget = new LastInsertTarget();
        NonNullList remaining = this.lastRecipe.func_179532_b((IInventory)this.craftingInventory);
        for (crafted = 0; crafted < maxToCraft; crafted += amountPerCraft) {
            if (recheckOutput && this.changedWhileCrafting) {
                ItemStack updatedOutput;
                recheckOutput = false;
                this.changedWhileCrafting = false;
                ICraftingRecipe oldRecipe = this.lastRecipe;
                this.updateOutputSlot(world);
                if (oldRecipe != this.lastRecipe || (updatedOutput = this.outputSlot.getStack()).func_190926_b() || updatedOutput.func_77973_b() != resultItem) break;
                ItemStack potentialUpdatedOutput = updatedOutput.func_77946_l();
                resultItem.func_77622_d(potentialUpdatedOutput, world, player);
                if (!ItemStack.func_77989_b((ItemStack)result, (ItemStack)potentialUpdatedOutput)) break;
                remaining = this.lastRecipe.func_179532_b((IInventory)this.craftingInventory);
            }
            ItemStack simulatedRemainder = MekanismContainer.insertItemCheckAll(hotBarSlots, result, this.windowData, Action.SIMULATE);
            if (!(simulatedRemainder = MekanismContainer.insertItemCheckAll(mainInventorySlots, simulatedRemainder, this.windowData, Action.SIMULATE)).func_190926_b()) break;
            ItemStack toInsert = lastInsertTarget.tryInserting(hotBarSlots, mainInventorySlots, this.windowData, result);
            if (!toInsert.func_190926_b()) {
                player.func_71019_a(toInsert, false);
            }
            boolean stopCrafting = false;
            for (int index = 0; index < remaining.size(); ++index) {
                ItemStack remainder = (ItemStack)remaining.get(index);
                CraftingWindowInventorySlot inputSlot = this.inputSlots[index];
                if (inputSlot.getCount() > 1) {
                    this.useInput(inputSlot);
                } else if (inputSlot.getCount() == 1) {
                    if (frequency == null || this.remainderHelper.isStackStillValid(world, remainder, index)) {
                        this.useInput(inputSlot);
                        recheckOutput = true;
                    } else {
                        ItemStack current = inputSlot.getStack();
                        ItemStack removed = frequency.removeItem(current, 1);
                        if (removed.func_190926_b()) {
                            this.useInput(inputSlot);
                            this.replacementHelper.findEquivalentItem(world, frequency, inputSlot, index, current);
                            stopCrafting = true;
                        }
                    }
                } else if (!remainder.func_190926_b()) {
                    recheckOutput = true;
                }
                this.addRemainingItem(player, frequency, inputSlot, remainder, true);
            }
            if (!stopCrafting) continue;
            crafted += amountPerCraft;
            break;
        }
        if (crafted > 0) {
            player.func_71064_a(itemCraftedStat, crafted);
        }
        this.craftingFinished(world);
    }

    @Nonnull
    public ItemStack performCraft(@Nonnull PlayerEntity player, @Nonnull ItemStack result, int amountCrafted) {
        if (amountCrafted == 0 || this.lastRecipe == null || result.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        World world = this.holder.getHolderWorld();
        if (!this.validateAndUnlockRecipe(world, player)) {
            return ItemStack.field_190927_a;
        }
        QIOFrequency frequency = this.holder.getFrequency();
        this.craftingStarted(player);
        result.func_77980_a(world, player, amountCrafted);
        NonNullList remaining = this.lastRecipe.func_179532_b((IInventory)this.craftingInventory);
        this.remainderHelper.reset();
        this.replacementHelper.reset();
        for (int index = 0; index < remaining.size(); ++index) {
            ItemStack remainder = (ItemStack)remaining.get(index);
            CraftingWindowInventorySlot inputSlot = this.inputSlots[index];
            if (inputSlot.getCount() > 1) {
                this.useInput(inputSlot);
            } else if (inputSlot.getCount() == 1) {
                if (frequency == null || this.remainderHelper.isStackStillValid(world, remainder, index)) {
                    this.useInput(inputSlot);
                } else {
                    ItemStack current = inputSlot.getStack();
                    ItemStack removed = frequency.removeItem(current, 1);
                    if (removed.func_190926_b()) {
                        this.useInput(inputSlot);
                        this.replacementHelper.findEquivalentItem(world, frequency, inputSlot, index, current);
                    }
                }
            }
            this.addRemainingItem(player, frequency, inputSlot, remainder, false);
        }
        this.craftingFinished(world);
        return result;
    }

    private void addRemainingItem(PlayerEntity player, @Nullable QIOFrequency frequency, IInventorySlot slot, @Nonnull ItemStack remainder, boolean copyIfNeeded) {
        int toInsert = remainder.func_190916_E();
        if (!(remainder = slot.insertItem(remainder, Action.EXECUTE, AutomationType.INTERNAL)).func_190926_b()) {
            if (copyIfNeeded && toInsert == remainder.func_190916_E()) {
                remainder = remainder.func_77946_l();
            }
            if (!player.field_71071_by.func_70441_a(remainder)) {
                if (frequency != null && (remainder = frequency.addItem(remainder)).func_190926_b()) {
                    return;
                }
                player.func_71019_a(remainder, false);
            }
        }
    }

    static {
        for (byte tableIndex = 0; tableIndex < WINDOWS.length; tableIndex = (byte)(tableIndex + 1)) {
            QIOCraftingWindow.WINDOWS[tableIndex] = new SelectedWindowData(SelectedWindowData.WindowType.CRAFTING, tableIndex);
        }
    }

    private class ReplacementHelper {
        private final Int2ObjectMap<Ingredient> slotIngredients;
        private boolean mapped;
        private boolean invalid;

        private ReplacementHelper() {
            this.slotIngredients = new Int2ObjectArrayMap(QIOCraftingWindow.this.inputSlots.length);
        }

        public void reset() {
            if (this.mapped) {
                this.mapped = false;
                this.invalid = false;
                this.slotIngredients.clear();
            }
        }

        public void findEquivalentItem(World world, @Nonnull QIOFrequency frequency, CraftingWindowInventorySlot slot, int index, ItemStack used) {
            this.mapRecipe(index, used);
            if (this.invalid) {
                return;
            }
            Ingredient usedIngredient = (Ingredient)this.slotIngredients.getOrDefault(index, (Object)Ingredient.field_193370_a);
            if (usedIngredient.test(used)) {
                for (ItemStack item : usedIngredient.func_193365_a()) {
                    if (!usedIngredient.isVanilla() && this.testEquivalentItem(world, frequency, slot, index, usedIngredient, HashedItem.raw(item))) {
                        return;
                    }
                    for (HashedItem type : frequency.getTypesForItem(item.func_77973_b())) {
                        if (!this.testEquivalentItem(world, frequency, slot, index, usedIngredient, type)) continue;
                        return;
                    }
                }
            }
        }

        private boolean testEquivalentItem(World world, @Nonnull QIOFrequency frequency, CraftingWindowInventorySlot slot, int index, Ingredient usedIngredient, HashedItem replacementType) {
            if (frequency.getStored(replacementType) == 0L || !usedIngredient.test(replacementType.getStack())) {
                return false;
            }
            ItemStack replacement = replacementType.createStack(1);
            ItemStack old = QIOCraftingWindow.this.remainderHelper.dummy.func_70301_a(index);
            if (QIOCraftingWindow.this.remainderHelper.isStackStillValid(world, replacement, index)) {
                ItemStack removed;
                if (slot.insertItem(replacement, Action.SIMULATE, AutomationType.INTERNAL).func_190926_b() && !(removed = frequency.removeByType(replacementType, 1)).func_190926_b()) {
                    ItemStack stack = slot.insertItem(removed, Action.EXECUTE, AutomationType.INTERNAL);
                    if (!stack.func_190926_b()) {
                        Mekanism.logger.error("Failed to insert item ({} with NBT: {}) into crafting window: {}.", (Object)removed.func_77973_b(), (Object)removed.func_77978_p(), (Object)QIOCraftingWindow.this.windowIndex);
                    }
                    return true;
                }
                QIOCraftingWindow.this.remainderHelper.dummy.func_70299_a(index, old);
            }
            return false;
        }

        private void mapRecipe(int index, ItemStack used) {
            if (!this.mapped) {
                this.mapped = true;
                if (QIOCraftingWindow.this.lastRecipe == null || QIOCraftingWindow.this.lastRecipe.func_192399_d()) {
                    this.invalid = true;
                    return;
                }
                NonNullList ingredients = QIOCraftingWindow.this.lastRecipe.func_192400_c();
                if (ingredients.isEmpty()) {
                    this.invalid = true;
                    return;
                }
                QIOCraftingWindow.this.remainderHelper.updateInputsWithReplacement(index, used);
                IntFunction<ItemStack> itemGetter = i -> {
                    if (i == index) {
                        return used;
                    }
                    if (i >= 0 && i < QIOCraftingWindow.this.inputSlots.length) {
                        return QIOCraftingWindow.this.inputSlots[i].getStack();
                    }
                    return ItemStack.field_190927_a;
                };
                if (QIOCraftingWindow.this.lastRecipe instanceof IShapedRecipe) {
                    this.mapShapedRecipe((IShapedRecipe)QIOCraftingWindow.this.lastRecipe, (NonNullList<Ingredient>)ingredients, itemGetter);
                } else {
                    this.mapShapelessRecipe((NonNullList<Ingredient>)ingredients, itemGetter);
                }
            }
        }

        private void mapShapedRecipe(IShapedRecipe<?> shapedRecipe, NonNullList<Ingredient> ingredients, IntFunction<ItemStack> itemGetter) {
            int recipeWidth = shapedRecipe.getRecipeWidth();
            int recipeHeight = shapedRecipe.getRecipeHeight();
            for (int columnStart = 0; columnStart <= 3 - recipeWidth; ++columnStart) {
                for (int rowStart = 0; rowStart <= 3 - recipeHeight; ++rowStart) {
                    if (!this.mapShapedRecipe(ingredients, columnStart, rowStart, recipeWidth, recipeHeight, true, itemGetter) && !this.mapShapedRecipe(ingredients, columnStart, rowStart, recipeWidth, recipeHeight, false, itemGetter)) continue;
                    return;
                }
            }
            this.invalid = true;
        }

        private boolean mapShapedRecipe(NonNullList<Ingredient> ingredients, int columnStart, int rowStart, int recipeWidth, int recipeHeight, boolean mirrored, IntFunction<ItemStack> itemGetter) {
            for (int actualColumn = 0; actualColumn < 3; ++actualColumn) {
                for (int actualRow = 0; actualRow < 3; ++actualRow) {
                    int index;
                    int column = actualColumn - columnStart;
                    int row = actualRow - rowStart;
                    Ingredient ingredient = Ingredient.field_193370_a;
                    if (column >= 0 && row >= 0 && column < recipeWidth && row < recipeHeight) {
                        ingredient = mirrored ? (Ingredient)ingredients.get(recipeWidth - column - 1 + row * recipeWidth) : (Ingredient)ingredients.get(column + row * recipeWidth);
                    }
                    if (!ingredient.test(itemGetter.apply(index = actualColumn + actualRow * 3))) {
                        this.slotIngredients.clear();
                        return false;
                    }
                    this.slotIngredients.put(index, (Object)ingredient);
                }
            }
            return true;
        }

        private void mapShapelessRecipe(NonNullList<Ingredient> ingredients, IntFunction<ItemStack> itemGetter) {
            Int2IntArrayMap actualLookup = new Int2IntArrayMap(QIOCraftingWindow.this.inputSlots.length);
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(QIOCraftingWindow.this.inputSlots.length);
            for (int index = 0; index < QIOCraftingWindow.this.inputSlots.length; ++index) {
                ItemStack stack = itemGetter.apply(index);
                if (stack.func_190926_b()) continue;
                actualLookup.put(inputs.size(), index);
                inputs.add(stack);
            }
            int[] matches = RecipeMatcher.findMatches(inputs, ingredients);
            if (matches != null) {
                for (int ingredientIndex = 0; ingredientIndex < matches.length; ++ingredientIndex) {
                    int actualSlot = actualLookup.getOrDefault(matches[ingredientIndex], -1);
                    if (actualSlot == -1) {
                        this.invalid = true;
                        return;
                    }
                    this.slotIngredients.put(actualSlot, ingredients.get(ingredientIndex));
                }
            } else {
                this.invalid = true;
            }
        }
    }

    private class RemainderHelper {
        private final CraftingInventory dummy = MekanismUtils.getDummyCraftingInv();
        private boolean updated;

        private RemainderHelper() {
        }

        public void reset() {
            if (this.updated) {
                this.updated = false;
                this.dummy.func_174888_l();
            }
        }

        private void updateInputs(@Nonnull ItemStack remainder) {
            if (!this.updated && !remainder.func_190926_b()) {
                for (int index = 0; index < QIOCraftingWindow.this.inputSlots.length; ++index) {
                    this.dummy.func_70299_a(index, StackUtils.size(QIOCraftingWindow.this.inputSlots[index].getStack(), 1));
                }
                this.updated = true;
            }
        }

        public void updateInputsWithReplacement(int index, ItemStack old) {
            if (!this.updated) {
                for (int i = 0; i < QIOCraftingWindow.this.inputSlots.length; ++i) {
                    ItemStack stack = i == index ? old : QIOCraftingWindow.this.inputSlots[i].getStack();
                    this.dummy.func_70299_a(i, StackUtils.size(stack, 1));
                }
                this.updated = true;
            }
        }

        public boolean isStackStillValid(World world, ItemStack stack, int index) {
            this.updateInputs(stack);
            ItemStack old = this.dummy.func_70301_a(index);
            this.dummy.func_70299_a(index, StackUtils.size(stack, 1));
            if (QIOCraftingWindow.this.lastRecipe != null && QIOCraftingWindow.this.lastRecipe.func_77569_a((IInventory)this.dummy, world)) {
                return true;
            }
            this.dummy.func_70299_a(index, old);
            return false;
        }
    }

    private class QIOCraftingInventory
    extends CraftingInventory {
        public QIOCraftingInventory() {
            super(null, 0, 0);
        }

        public int func_70302_i_() {
            return QIOCraftingWindow.this.inputSlots.length;
        }

        public boolean func_191420_l() {
            return Arrays.stream(QIOCraftingWindow.this.inputSlots).allMatch(BasicInventorySlot::isEmpty);
        }

        @Nonnull
        public ItemStack func_70301_a(int index) {
            CraftingWindowInventorySlot inputSlot;
            if (index >= 0 && index < this.func_70302_i_() && !(inputSlot = QIOCraftingWindow.this.getInputSlot(index)).isEmpty()) {
                return inputSlot.getStack().func_77946_l();
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack func_70304_b(int index) {
            if (index >= 0 && index < this.func_70302_i_()) {
                CraftingWindowInventorySlot inputSlot = QIOCraftingWindow.this.getInputSlot(index);
                ItemStack stored = inputSlot.getStack();
                inputSlot.setEmpty();
                return stored;
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack func_70298_a(int index, int count) {
            if (index >= 0 && index < this.func_70302_i_()) {
                return QIOCraftingWindow.this.getInputSlot(index).extractItem(count, Action.EXECUTE, AutomationType.INTERNAL);
            }
            return ItemStack.field_190927_a;
        }

        public void func_70299_a(int index, @Nonnull ItemStack stack) {
            if (index >= 0 && index < this.func_70302_i_()) {
                QIOCraftingWindow.this.getInputSlot(index).setStack(stack);
            }
        }

        public void func_174888_l() {
            for (CraftingWindowInventorySlot inputSlot : QIOCraftingWindow.this.inputSlots) {
                inputSlot.setEmpty();
            }
        }

        public int func_174923_h() {
            return 3;
        }

        public int func_174922_i() {
            return 3;
        }

        public void func_194018_a(@Nonnull RecipeItemHelper helper) {
            boolean copyNeeded = helper.getClass() != RecipeItemHelper.class;
            for (CraftingWindowInventorySlot inputSlot : QIOCraftingWindow.this.inputSlots) {
                ItemStack stack = inputSlot.getStack();
                helper.func_195932_a(copyNeeded ? stack.func_77946_l() : stack);
            }
        }
    }

    private static class LastInsertTarget {
        private boolean wasHotBar = true;
        private int lastIndex;

        private LastInsertTarget() {
        }

        public ItemStack tryInserting(List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots, SelectedWindowData windowData, ItemStack toInsert) {
            toInsert = this.insertItem(hotBarSlots, toInsert, true, true, windowData);
            toInsert = this.insertItem(mainInventorySlots, toInsert, true, false, windowData);
            toInsert = this.insertItem(hotBarSlots, toInsert, false, true, windowData);
            toInsert = this.insertItem(mainInventorySlots, toInsert, false, false, windowData);
            return toInsert;
        }

        @Nonnull
        private <SLOT extends Slot> ItemStack insertItem(List<SLOT> slots, @Nonnull ItemStack stack, boolean ignoreEmpty, boolean isHotBar, @Nullable SelectedWindowData selectedWindow) {
            if (stack.func_190926_b()) {
                return stack;
            }
            int slotCount = slots.size();
            for (int i = ignoreEmpty && this.wasHotBar == isHotBar ? this.lastIndex : 0; i < slotCount; ++i) {
                Slot slot = (Slot)slots.get(i);
                if (ignoreEmpty != slot.func_75216_d() || !((IInsertableSlot)slot).exists(selectedWindow) || !(stack = ((IInsertableSlot)slot).insertItem(stack, Action.EXECUTE)).func_190926_b()) continue;
                this.wasHotBar = isHotBar;
                this.lastIndex = i;
                break;
            }
            return stack;
        }
    }
}

