/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.oredictionificator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.value.CachedOredictionificatorConfigValue;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class OredictionificatorFilter<TYPE extends IForgeRegistryEntry<TYPE>, STACK, FILTER extends OredictionificatorFilter<TYPE, STACK, FILTER>>
extends BaseFilter<FILTER> {
    @Nullable
    private ResourceLocation filterLocation;
    private ITag<TYPE> filterTag;
    @Nonnull
    private TYPE selectedOutput = this.getFallbackElement();
    @Nullable
    private STACK cachedSelectedStack;
    private boolean isValid;

    protected OredictionificatorFilter() {
        this.filterTag = Tag.func_241284_a_();
    }

    protected OredictionificatorFilter(OredictionificatorFilter<TYPE, STACK, FILTER> filter) {
        this.filterLocation = filter.filterLocation;
        this.filterTag = filter.filterTag;
        this.selectedOutput = filter.selectedOutput;
        this.cachedSelectedStack = filter.cachedSelectedStack;
        this.isValid = filter.isValid;
    }

    public void flushCachedTag() {
        Object object = this.filterTag = this.filterLocation == null ? Tag.func_241284_a_() : this.getTagCollection().func_241834_b(this.filterLocation);
        if (!this.filterTag.func_230235_a_(this.selectedOutput)) {
            List elements = this.filterTag.func_230236_b_();
            this.setSelectedOutput(elements.isEmpty() ? this.getFallbackElement() : (IForgeRegistryEntry)elements.get(0));
        }
    }

    @Override
    public boolean hasFilter() {
        return this.filterLocation != null && this.isValid;
    }

    public void checkValidity() {
        if (this.filterLocation != null && this.getTagCollection().func_199908_a().contains(this.filterLocation)) {
            for (String filter : ((Map)this.getValidValuesConfig().get()).getOrDefault(this.filterLocation.func_110624_b(), Collections.emptyList())) {
                if (!this.filterLocation.func_110623_a().startsWith(filter)) continue;
                this.isValid = true;
                return;
            }
        }
        this.isValid = false;
    }

    public String getFilterText() {
        return this.filterLocation == null ? "" : this.filterLocation.toString();
    }

    public final void setFilter(ResourceLocation location) {
        this.filterLocation = location;
        this.flushCachedTag();
        this.isValid = true;
    }

    public final void setSelectedOutput(@Nonnull TYPE output) {
        this.selectedOutput = output;
        this.cachedSelectedStack = null;
    }

    public boolean filterMatches(ResourceLocation location) {
        return this.filterLocation != null && this.filterLocation.equals((Object)location);
    }

    @Override
    public CompoundNBT write(CompoundNBT nbtTags) {
        super.write(nbtTags);
        nbtTags.func_74778_a("filter", this.getFilterText());
        if (this.selectedOutput != this.getFallbackElement()) {
            nbtTags.func_74778_a("selected", this.selectedOutput.getRegistryName().toString());
        }
        return nbtTags;
    }

    @Override
    public void read(CompoundNBT nbtTags) {
        NBTUtils.setResourceLocationIfPresentElse(nbtTags, "filter", this::setFilter, () -> this.setFilter(null));
        NBTUtils.setResourceLocationIfPresent(nbtTags, "selected", this::setSelectedOrFallback);
        this.checkValidity();
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.filterLocation != null);
        if (this.filterLocation != null) {
            buffer.func_192572_a(this.filterLocation);
        }
        buffer.func_192572_a(this.selectedOutput.getRegistryName());
        buffer.writeBoolean(this.isValid);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.setFilter(buffer.readBoolean() ? buffer.func_192575_l() : null);
        this.setSelectedOrFallback(buffer.func_192575_l());
        this.isValid = buffer.readBoolean();
    }

    private void setSelectedOrFallback(@Nonnull ResourceLocation resourceLocation) {
        IForgeRegistryEntry output = this.getRegistry().getValue(resourceLocation);
        this.setSelectedOutput(output == null ? this.getFallbackElement() : output);
    }

    public STACK getResult() {
        if (this.cachedSelectedStack == null) {
            List matchingElements = this.filterTag.func_230236_b_();
            if (matchingElements.isEmpty()) {
                this.cachedSelectedStack = this.getEmptyStack();
            } else {
                if (this.selectedOutput == this.getFallbackElement() || !matchingElements.contains(this.selectedOutput)) {
                    this.selectedOutput = (IForgeRegistryEntry)matchingElements.get(0);
                }
                this.cachedSelectedStack = this.createResultStack(this.selectedOutput);
            }
        }
        return this.cachedSelectedStack;
    }

    public final void next() {
        this.adjustSelected((index, size) -> {
            if (index < size - 1) {
                return index + 1;
            }
            return 0;
        });
    }

    public final void previous() {
        this.adjustSelected((index, size) -> {
            if (index == -1) {
                return 0;
            }
            if (index > 0) {
                return index - 1;
            }
            return size - 1;
        });
    }

    private void adjustSelected(IntBinaryOperator calculateSelected) {
        List matchingElements = this.filterTag.func_230236_b_();
        int size = matchingElements.size();
        if (size > 1) {
            int selected = this.selectedOutput == this.getFallbackElement() ? size - 1 : calculateSelected.applyAsInt(matchingElements.indexOf(this.selectedOutput), size);
            this.setSelectedOutput((IForgeRegistryEntry)matchingElements.get(selected));
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.filterLocation);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.filterLocation, ((OredictionificatorFilter)o).filterLocation);
    }

    public abstract TYPE getResultElement();

    protected abstract IForgeRegistry<TYPE> getRegistry();

    protected abstract ITagCollection<TYPE> getTagCollection();

    protected abstract TYPE getFallbackElement();

    protected abstract STACK getEmptyStack();

    protected abstract STACK createResultStack(TYPE var1);

    protected abstract CachedOredictionificatorConfigValue getValidValuesConfig();
}

