/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.gear.ItemMekaSuitArmor;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
public class ModuleNutritionalInjectionUnit
implements ICustomModule<ModuleNutritionalInjectionUnit> {
    private static final ResourceLocation icon = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_HUD, "nutritional_injection_unit.png");

    @Override
    public void tickServer(IModule<ModuleNutritionalInjectionUnit> module, PlayerEntity player) {
        FloatingLong usage = (FloatingLong)MekanismConfig.gear.mekaSuitEnergyUsageNutritionalInjection.get();
        if (MekanismUtils.isPlayingMode(player) && player.func_71043_e(false)) {
            ItemStack container = module.getContainer();
            ItemMekaSuitArmor item = (ItemMekaSuitArmor)container.func_77973_b();
            long needed = Math.min((long)(20 - player.func_71024_bL().func_75116_a()), item.getContainedGas(container, (Gas)MekanismGases.NUTRITIONAL_PASTE.get()).getAmount() / (long)MekanismConfig.general.nutritionalPasteMBPerFood.get());
            long toFeed = Math.min((long)module.getContainerEnergy().divideToInt(usage), needed);
            if (toFeed > 0L) {
                module.useEnergy((LivingEntity)player, usage.multiply(toFeed));
                item.useGas(container, (Gas)MekanismGases.NUTRITIONAL_PASTE.get(), toFeed * (long)MekanismConfig.general.nutritionalPasteMBPerFood.get());
                player.func_71024_bL().func_75122_a((int)needed, (float)needed * MekanismConfig.general.nutritionalPasteSaturation.get());
            }
        }
    }

    @Override
    public void addHUDElements(IModule<ModuleNutritionalInjectionUnit> module, PlayerEntity player, Consumer<IHUDElement> hudElementAdder) {
        if (module.isEnabled()) {
            ItemStack container = module.getContainer();
            GasStack stored = ((ItemMekaSuitArmor)container.func_77973_b()).getContainedGas(container, (Gas)MekanismGases.NUTRITIONAL_PASTE.get());
            double ratio = StorageUtils.getRatio(stored.getAmount(), MekanismConfig.gear.mekaSuitNutritionalMaxStorage.getAsLong());
            hudElementAdder.accept(MekanismAPI.getModuleHelper().hudElementPercent(icon, ratio));
        }
    }
}

