/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArraySet;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.qio.QIOCraftingTransferHelper;
import mekanism.common.content.qio.QIOCraftingWindow;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.inventory.container.slot.HotBarSlot;
import mekanism.common.inventory.container.slot.MainInventorySlot;
import mekanism.common.inventory.slot.CraftingWindowInventorySlot;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.to_server.PacketQIOFillCraftingWindow;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.util.text.ITextComponent;

public class QIOCraftingTransferHandler<CONTAINER extends QIOItemViewerContainer>
implements IRecipeTransferHandler<CONTAINER> {
    private final IRecipeTransferHandlerHelper handlerHelper;
    private final Class<CONTAINER> containerClass;
    private final IStackHelper stackHelper;

    public QIOCraftingTransferHandler(IRecipeTransferHandlerHelper handlerHelper, IStackHelper stackHelper, Class<CONTAINER> containerClass) {
        this.handlerHelper = handlerHelper;
        this.stackHelper = stackHelper;
        this.containerClass = containerClass;
    }

    public Class<CONTAINER> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(CONTAINER container, Object rawRecipe, IRecipeLayout recipeLayout, PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        if (!(rawRecipe instanceof ICraftingRecipe)) {
            return this.handlerHelper.createInternalError();
        }
        byte selectedCraftingGrid = ((QIOItemViewerContainer)container).getSelectedCraftingGrid();
        if (selectedCraftingGrid == -1) {
            return this.handlerHelper.createInternalError();
        }
        ICraftingRecipe recipe = (ICraftingRecipe)rawRecipe;
        QIOCraftingWindow craftingWindow = ((QIOItemViewerContainer)container).getCraftingWindow(selectedCraftingGrid);
        byte nonEmptyCraftingSlots = 0;
        if (!doTransfer) {
            CraftingInventory dummy = MekanismUtils.getDummyCraftingInv();
            for (int slot = 0; slot < 9; ++slot) {
                CraftingWindowInventorySlot inputSlot = craftingWindow.getInputSlot(slot);
                if (inputSlot.isEmpty()) continue;
                dummy.func_70299_a(slot, StackUtils.size(inputSlot.getStack(), 1));
                nonEmptyCraftingSlots = (byte)(nonEmptyCraftingSlots + 1);
            }
            if (recipe.func_77569_a((IInventory)dummy, player.field_70170_p)) {
                return null;
            }
        }
        int inputCount = 0;
        Byte2ObjectArrayMap hashedIngredients = new Byte2ObjectArrayMap();
        for (Map.Entry entry : recipeLayout.getItemStacks().getGuiIngredients().entrySet()) {
            List validIngredients;
            IGuiIngredient ingredient2 = (IGuiIngredient)entry.getValue();
            if (!ingredient2.isInput() || (validIngredients = ingredient2.getAllIngredients()).isEmpty()) continue;
            ++inputCount;
            LinkedHashSet<HashedItem> representations = new LinkedHashSet<HashedItem>();
            ItemStack itemStack = (ItemStack)ingredient2.getDisplayedIngredient();
            if (itemStack != null) {
                representations.add(HashedItem.raw(itemStack));
            }
            for (ItemStack validIngredient : validIngredients) {
                representations.add(HashedItem.raw(validIngredient));
            }
            int actualIndex = (Integer)entry.getKey() - 1;
            if (actualIndex > 127 || actualIndex < -128) {
                Mekanism.logger.warn("Error evaluating recipe transfer handler for recipe: {}, had unexpected index: {}", (Object)recipe.func_199560_c(), (Object)actualIndex);
                return this.handlerHelper.createInternalError();
            }
            hashedIngredients.put((byte)actualIndex, representations);
        }
        if (inputCount > 9) {
            Mekanism.logger.warn("Error evaluating recipe transfer handler for recipe: {}, had more than 9 inputs: {}", (Object)recipe.func_199560_c(), (Object)inputCount);
            return this.handlerHelper.createInternalError();
        }
        QIOCraftingTransferHelper qioTransferHelper = ((QIOItemViewerContainer)container).getTransferHelper(player, craftingWindow);
        if (qioTransferHelper.isInvalid()) {
            Mekanism.logger.warn("Error initializing QIO transfer handler for crafting window: {}", (Object)selectedCraftingGrid);
            return this.handlerHelper.createInternalError();
        }
        HashMap<HashedItem, ByteList> hashMap = new HashMap<HashedItem, ByteList>(inputCount);
        ByteArraySet missingSlots = new ByteArraySet(inputCount);
        for (Object entry : hashedIngredients.byte2ObjectEntrySet()) {
            boolean bl = false;
            for (HashedItem validInput : (Set)entry.getValue()) {
                QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(validInput);
                if (source == null || !source.hasMoreRemaining()) continue;
                source.matchFound();
                bl = true;
                hashMap.computeIfAbsent(validInput, item -> new ByteArrayList()).add(entry.getByteKey());
                break;
            }
            if (bl) continue;
            missingSlots.add(entry.getByteKey());
        }
        if (!missingSlots.isEmpty()) {
            HashMap<HashedItem, String> cachedIngredientUUIDs = new HashMap<HashedItem, String>();
            for (Map.Entry entry : qioTransferHelper.reverseLookup.entrySet()) {
                QIOCraftingTransferHelper.HashedItemSource source = (QIOCraftingTransferHelper.HashedItemSource)entry.getValue();
                if (!source.hasMoreRemaining()) continue;
                HashedItem storedHashedItem = (HashedItem)entry.getKey();
                ItemStack storedItem = storedHashedItem.getStack();
                Item storedItemType = storedItem.func_77973_b();
                String storedItemUUID = null;
                ByteIterator missingIterator = missingSlots.iterator();
                while (missingIterator.hasNext()) {
                    byte index = missingIterator.nextByte();
                    for (HashedItem validIngredient : (Set)hashedIngredients.get(index)) {
                        String ingredientUUID;
                        if (storedItemType != validIngredient.getStack().func_77973_b()) continue;
                        if (storedItemUUID == null) {
                            storedItemUUID = this.stackHelper.getUniqueIdentifierForStack(storedItem, UidContext.Recipe);
                        }
                        if (!storedItemUUID.equals(ingredientUUID = cachedIngredientUUIDs.computeIfAbsent(validIngredient, ingredient -> this.stackHelper.getUniqueIdentifierForStack(ingredient.getStack(), UidContext.Recipe)))) continue;
                        source.matchFound();
                        missingIterator.remove();
                        hashMap.computeIfAbsent(storedHashedItem, item -> new ByteArrayList()).add(index);
                        break;
                    }
                    if (source.hasMoreRemaining()) continue;
                    break;
                }
                if (!missingSlots.isEmpty()) continue;
                break;
            }
            if (!missingSlots.isEmpty()) {
                return this.handlerHelper.createUserErrorForSlots((ITextComponent)MekanismLang.JEI_MISSING_ITEMS.translate(new Object[0]), (Collection)missingSlots.stream().map(i -> i + 1).collect(Collectors.toList()));
            }
        }
        if (doTransfer || nonEmptyCraftingSlots > 0 && nonEmptyCraftingSlots >= qioTransferHelper.getEmptyInventorySlots()) {
            int toTransfer;
            if (maxTransfer) {
                long maxToTransfer = Long.MAX_VALUE;
                for (Map.Entry entry : hashMap.entrySet()) {
                    HashedItem hashedItem = (HashedItem)entry.getKey();
                    QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(hashedItem);
                    if (source == null) {
                        return this.invalidSource(hashedItem);
                    }
                    int maxStack = hashedItem.getStack().func_77976_d();
                    long max = maxStack == 1 ? maxToTransfer : Math.min(maxToTransfer, (long)maxStack);
                    maxToTransfer = Math.min(max, source.getAvailable() / (long)((ByteList)entry.getValue()).size());
                }
                toTransfer = MathUtils.clampToInt(maxToTransfer);
            } else {
                toTransfer = 1;
            }
            QIOFrequency frequency = ((QIOItemViewerContainer)container).getFrequency();
            Byte2ObjectArrayMap byte2ObjectArrayMap = new Byte2ObjectArrayMap(inputCount);
            HashMap<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>> shuffleLookup = frequency == null ? Collections.emptyMap() : new HashMap<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>>(inputCount);
            for (Map.Entry entry : hashMap.entrySet()) {
                HashedItem hashedItem = (HashedItem)entry.getKey();
                QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(hashedItem);
                if (source == null) {
                    return this.invalidSource(hashedItem);
                }
                int transferAmount = Math.min(toTransfer, hashedItem.getStack().func_77976_d());
                ByteListIterator byteListIterator = ((ByteList)entry.getValue()).iterator();
                while (byteListIterator.hasNext()) {
                    byte slot = (Byte)byteListIterator.next();
                    List<QIOCraftingTransferHelper.SingularHashedItemSource> actualSources = source.use(transferAmount);
                    if (actualSources.isEmpty()) {
                        return this.invalidSource(hashedItem);
                    }
                    byte2ObjectArrayMap.put(slot, actualSources);
                    if (frequency == null) continue;
                    int elements = ((ByteList)entry.getValue()).size();
                    if (elements == 1) {
                        shuffleLookup.put(source, Collections.singletonList(actualSources));
                        continue;
                    }
                    shuffleLookup.computeIfAbsent(source, s -> new ArrayList(elements)).add(actualSources);
                }
            }
            if (!QIOCraftingTransferHandler.hasRoomToShuffle(qioTransferHelper, frequency, craftingWindow, ((MekanismContainer)container).getHotBarSlots(), ((MekanismContainer)container).getMainInventorySlots(), shuffleLookup)) {
                return this.handlerHelper.createUserErrorWithTooltip((ITextComponent)MekanismLang.JEI_INVENTORY_FULL.translate(new Object[0]));
            }
            if (doTransfer) {
                Mekanism.packetHandler.sendToServer(new PacketQIOFillCraftingWindow(recipe.func_199560_c(), maxTransfer, (Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>>)byte2ObjectArrayMap));
            }
        }
        return null;
    }

    private IRecipeTransferError invalidSource(@Nonnull HashedItem type) {
        ItemStack stack = type.getStack();
        Mekanism.logger.warn("Error finding source for: {} with nbt: {}. This should not be possible happen.", (Object)stack.func_77973_b(), (Object)stack.func_77978_p());
        return this.handlerHelper.createInternalError();
    }

    private static boolean hasRoomToShuffle(final QIOCraftingTransferHelper qioTransferHelper, @Nullable QIOFrequency frequency, QIOCraftingWindow craftingWindow, List<HotBarSlot> hotBarSlots, List<MainInventorySlot> mainInventorySlots, Map<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>> shuffleLookup) {
        Object2IntArrayMap leftOverInput = new Object2IntArrayMap(9);
        for (byte slotIndex = 0; slotIndex < 9; slotIndex = (byte)((byte)(slotIndex + 1))) {
            CraftingWindowInventorySlot slot = craftingWindow.getInputSlot(slotIndex);
            if (slot.isEmpty()) continue;
            HashedItem type = HashedItem.raw(slot.getStack());
            QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(type);
            if (source == null) {
                return false;
            }
            int remaining = source.getSlotRemaining(slotIndex);
            if (remaining <= 0) continue;
            leftOverInput.mergeInt((Object)type, remaining, Integer::sum);
        }
        if (!leftOverInput.isEmpty()) {
            QIOCraftingTransferHelper.BaseSimulatedInventory simulatedInventory = new QIOCraftingTransferHelper.BaseSimulatedInventory(hotBarSlots, mainInventorySlots){

                @Override
                protected int getRemaining(int slot, ItemStack currentStored) {
                    QIOCraftingTransferHelper.HashedItemSource source = qioTransferHelper.getSource(HashedItem.raw(currentStored));
                    if (source == null) {
                        return currentStored.func_190916_E();
                    }
                    return source.getSlotRemaining((byte)(slot + 9));
                }
            };
            Object2IntMap<HashedItem> stillLeftOver = simulatedInventory.shuffleInputs((Object2IntMap<HashedItem>)leftOverInput, frequency != null);
            if (stillLeftOver == null) {
                return false;
            }
            if (!stillLeftOver.isEmpty() && frequency != null) {
                QIOCraftingTransferHelper.HashedItemSource source;
                int availableItemTypes = frequency.getTotalItemTypeCapacity() - frequency.getTotalItemTypes(true);
                long availableItemSpace = frequency.getTotalItemCountCapacity() - frequency.getTotalItemCount();
                Object2BooleanArrayMap usedQIOSource = new Object2BooleanArrayMap(shuffleLookup.size());
                for (Map.Entry<QIOCraftingTransferHelper.HashedItemSource, List<List<QIOCraftingTransferHelper.SingularHashedItemSource>>> entry : shuffleLookup.entrySet()) {
                    source = entry.getKey();
                    boolean usedQIO = false;
                    for (List<QIOCraftingTransferHelper.SingularHashedItemSource> usedSources : entry.getValue()) {
                        for (QIOCraftingTransferHelper.SingularHashedItemSource usedSource : usedSources) {
                            UUID qioSource = usedSource.getQioSource();
                            if (qioSource == null) continue;
                            availableItemSpace += (long)usedSource.getUsed();
                            if (source.getQIORemaining(qioSource) != 0L) continue;
                            ++availableItemTypes;
                            usedQIO = true;
                        }
                    }
                    usedQIOSource.put((Object)source, usedQIO);
                }
                for (Object2IntMap.Entry entry : stillLeftOver.object2IntEntrySet()) {
                    if ((availableItemSpace -= (long)entry.getIntValue()) <= 0L) {
                        return false;
                    }
                    source = qioTransferHelper.getSource((HashedItem)entry.getKey());
                    if (source == null) {
                        return false;
                    }
                    if (!(source.hasQIOSources() ? usedQIOSource.containsKey((Object)source) && usedQIOSource.getBoolean((Object)source) && --availableItemTypes <= 0 : --availableItemTypes <= 0)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

