/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.robit;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import mekanism.client.gui.robit.GuiRobit;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.entity.robit.RepairRobitContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CRenameItemPacket;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiRobitRepair
extends GuiRobit<RepairRobitContainer>
implements IContainerListener {
    private static final ResourceLocation ANVIL_RESOURCE = new ResourceLocation("textures/gui/container/anvil.png");
    private TextFieldWidget itemNameField;

    public GuiRobitRepair(RepairRobitContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        ++this.field_238745_s_;
        this.field_238742_p_ = 60;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.itemNameField = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 62, this.field_147009_r + 24, 103, 12, StringTextComponent.field_240750_d_));
        this.itemNameField.func_146205_d(false);
        this.itemNameField.func_231049_c__(true);
        this.itemNameField.func_146193_g(-1);
        this.itemNameField.func_146204_h(-1);
        this.itemNameField.func_146185_a(false);
        this.itemNameField.func_146203_f(35);
        this.itemNameField.func_212954_a(this::onTextUpdate);
        ((RepairRobitContainer)this.field_147002_h).func_82847_b(this);
        ((RepairRobitContainer)this.field_147002_h).func_75132_a(this);
    }

    @Override
    public void func_231158_b_(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String previousName = this.itemNameField == null ? "" : this.itemNameField.func_146179_b();
        super.func_231158_b_(minecraft, scaledWidth, scaledHeight);
        this.itemNameField.func_146180_a(previousName);
    }

    private void onTextUpdate(String newText) {
        if (!newText.isEmpty()) {
            Slot slot = ((RepairRobitContainer)this.field_147002_h).func_75139_a(0);
            if (slot.func_75216_d() && !slot.func_75211_c().func_82837_s() && newText.equals(slot.func_75211_c().func_200301_q().getString())) {
                newText = "";
            }
            ((RepairRobitContainer)this.field_147002_h).func_82850_a(newText);
            this.getMinecraft().field_71439_g.field_71174_a.func_147297_a((IPacket)new CRenameItemPacket(newText));
        }
    }

    @Override
    public void func_231164_f_() {
        super.func_231164_f_();
        this.getMinecraft().field_195559_v.func_197967_a(false);
        ((RepairRobitContainer)this.field_147002_h).func_82847_b(this);
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.drawString(matrix, (ITextComponent)MekanismLang.ROBIT_REPAIR.translate(new Object[0]), this.field_238742_p_, this.field_238743_q_, this.titleTextColor());
        int maximumCost = ((RepairRobitContainer)this.field_147002_h).func_216976_f();
        if (maximumCost > 0) {
            int k = 8453920;
            boolean flag = true;
            TranslationTextComponent component = MekanismLang.REPAIR_COST.translate(maximumCost);
            if (maximumCost >= 40 && !this.getMinecraft().field_71439_g.func_184812_l_()) {
                component = MekanismLang.REPAIR_EXPENSIVE.translate(new Object[0]);
                k = 0xFF6060;
            } else {
                Slot slot = ((RepairRobitContainer)this.field_147002_h).func_75139_a(2);
                if (!slot.func_75216_d()) {
                    flag = false;
                } else if (!slot.func_82869_a(this.field_213127_e.field_70458_d)) {
                    k = 0xFF6060;
                }
            }
            if (flag) {
                int width = this.field_146999_f - 8 - this.getStringWidth((ITextComponent)component) - 2;
                GuiRobitRepair.func_238467_a_((MatrixStack)matrix, (int)(width - 2), (int)67, (int)(this.field_146999_f - 8), (int)79, (int)0x4F000000);
                this.getFont().func_243246_a(matrix, (ITextComponent)component, (float)width, 69.0f, k);
                MekanismRenderer.resetColor();
            }
        }
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    public boolean func_231042_a_(char c, int keyCode) {
        if (this.itemNameField.func_212955_f()) {
            return this.itemNameField.func_231042_a_(c, keyCode);
        }
        return super.func_231042_a_(c, keyCode);
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode != 256 && this.itemNameField.func_212955_f()) {
            return this.itemNameField.func_231046_a_(keyCode, scanCode, modifiers);
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    @Override
    protected boolean shouldOpenGui(GuiRobit.RobitGuiType guiType) {
        return guiType != GuiRobit.RobitGuiType.REPAIR;
    }

    @Override
    protected void func_230450_a_(@Nonnull MatrixStack matrix, float partialTick, int mouseX, int mouseY) {
        this.getMinecraft().field_71446_o.func_110577_a(ANVIL_RESOURCE);
        this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_238474_b_(matrix, this.field_147003_i + 59, this.field_147009_r + 20, 0, this.field_147000_g + (((RepairRobitContainer)this.field_147002_h).func_75139_a(0).func_75216_d() ? 0 : 16), 110, 16);
        if ((((RepairRobitContainer)this.field_147002_h).func_75139_a(0).func_75216_d() || ((RepairRobitContainer)this.field_147002_h).func_75139_a(1).func_75216_d()) && !((RepairRobitContainer)this.field_147002_h).func_75139_a(2).func_75216_d()) {
            this.func_238474_b_(matrix, this.field_147003_i + 99, this.field_147009_r + 45, this.field_146999_f, 0, 28, 21);
        }
    }

    public void func_71110_a(@Nonnull Container container, @Nonnull NonNullList<ItemStack> list) {
        this.func_71111_a(container, 0, container.func_75139_a(0).func_75211_c());
    }

    public void func_71111_a(@Nonnull Container container, int slotID, @Nonnull ItemStack stack) {
        if (slotID == 0) {
            this.itemNameField.func_146180_a(stack.func_190926_b() ? "" : stack.func_200301_q().getString());
            this.itemNameField.func_146184_c(!stack.func_190926_b());
        }
    }

    public void func_71112_a(@Nonnull Container container, int varToUpdate, int newValue) {
    }
}

