/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.slot;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.VirtualSlotContainerScreen;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.common.inventory.container.slot.IVirtualSlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.slot.VirtualInventoryContainerSlot;
import net.minecraft.item.ItemStack;

public class GuiVirtualSlot
extends GuiSlot
implements IJEIIngredientHelper {
    private IVirtualSlot virtualSlot;

    public GuiVirtualSlot(SlotType type, IGuiWrapper gui, int x, int y, VirtualInventoryContainerSlot containerSlot) {
        this(type, gui, x, y);
        if (containerSlot != null) {
            SlotOverlay slotOverlay = containerSlot.getSlotOverlay();
            if (slotOverlay != null) {
                this.with(slotOverlay);
            }
            this.updateVirtualSlot(containerSlot);
        }
    }

    public GuiVirtualSlot(SlotType type, IGuiWrapper gui, int x, int y) {
        super(type, gui, x, y);
        this.setRenderHover(true);
    }

    public boolean isElementForSlot(IVirtualSlot virtualSlot) {
        return this.virtualSlot == virtualSlot;
    }

    public void updateVirtualSlot(@Nonnull IVirtualSlot virtualSlot) {
        this.virtualSlot = virtualSlot;
        this.virtualSlot.updatePosition(() -> this.relativeX + 1, () -> this.relativeY + 1);
    }

    @Override
    protected void drawContents(@Nonnull MatrixStack matrix) {
        ItemStack stack;
        if (this.virtualSlot != null && !(stack = this.virtualSlot.getStackToRender()).func_190926_b()) {
            int xPos = this.field_230690_l_ + 1;
            int yPos = this.field_230691_m_ + 1;
            if (this.virtualSlot.shouldDrawOverlay()) {
                GuiVirtualSlot.func_238467_a_((MatrixStack)matrix, (int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-2130706433);
            }
            this.gui().renderItemWithOverlay(matrix, stack, xPos, yPos, 1.0f, this.virtualSlot.getTooltipOverride());
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        IGuiWrapper gui;
        if (mouseX >= (double)this.field_230690_l_ && mouseY >= (double)this.field_230691_m_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_) && (gui = this.gui()) instanceof VirtualSlotContainerScreen && this.virtualSlot != null) {
            return ((VirtualSlotContainerScreen)((Object)gui)).slotClicked(this.virtualSlot.getSlot(), button);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return this.virtualSlot == null ? null : this.virtualSlot.getStackToRender();
    }
}

