/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.BoxedChemicalInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ChemicalCrystallizerCachedRecipe
extends CachedRecipe<ChemicalCrystallizerRecipe> {
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final BoxedChemicalInputHandler inputHandler;
    private BoxedChemicalStack recipeInput = BoxedChemicalStack.EMPTY;

    public ChemicalCrystallizerCachedRecipe(ChemicalCrystallizerRecipe recipe, BoxedChemicalInputHandler inputHandler, IOutputHandler<@NonNull ItemStack> outputHandler) {
        super(recipe);
        this.inputHandler = Objects.requireNonNull(inputHandler, "Input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        this.recipeInput = this.inputHandler.getRecipeInput(((ChemicalCrystallizerRecipe)this.recipe).getInput());
        if (this.recipeInput.isEmpty()) {
            return -1;
        }
        if ((currentMax = this.inputHandler.operationsCanSupport(this.recipeInput, currentMax)) <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ChemicalCrystallizerRecipe)this.recipe).getOutput(this.recipeInput), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ChemicalCrystallizerRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.recipeInput.isEmpty()) {
            return;
        }
        this.inputHandler.use(this.recipeInput, operations);
        this.outputHandler.handleOutput(((ChemicalCrystallizerRecipe)this.recipe).getOutput(this.recipeInput), operations);
    }
}

