/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.merged;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.text.IHasTextComponent;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BoxedChemical
implements IHasTextComponent {
    public static final BoxedChemical EMPTY = new BoxedChemical(ChemicalType.GAS, MekanismAPI.EMPTY_GAS);
    private final ChemicalType chemicalType;
    private final Chemical<?> chemical;

    public static BoxedChemical box(Chemical<?> chemical) {
        if (chemical.isEmptyType()) {
            return EMPTY;
        }
        return new BoxedChemical(ChemicalType.getTypeFor(chemical), chemical);
    }

    public static BoxedChemical read(PacketBuffer buffer) {
        ChemicalType chemicalType = (ChemicalType)buffer.func_179257_a(ChemicalType.class);
        if (chemicalType == ChemicalType.GAS) {
            return new BoxedChemical(chemicalType, (Gas)buffer.readRegistryId());
        }
        if (chemicalType == ChemicalType.INFUSION) {
            return new BoxedChemical(chemicalType, (InfuseType)buffer.readRegistryId());
        }
        if (chemicalType == ChemicalType.PIGMENT) {
            return new BoxedChemical(chemicalType, (Pigment)buffer.readRegistryId());
        }
        if (chemicalType == ChemicalType.SLURRY) {
            return new BoxedChemical(chemicalType, (Slurry)buffer.readRegistryId());
        }
        throw new IllegalStateException("Unknown chemical type");
    }

    public static BoxedChemical read(@Nullable CompoundNBT nbt) {
        ChemicalType chemicalType = ChemicalType.fromNBT(nbt);
        Chemical chemical = null;
        if (chemicalType == ChemicalType.GAS) {
            chemical = Gas.readFromNBT(nbt);
        } else if (chemicalType == ChemicalType.INFUSION) {
            chemical = InfuseType.readFromNBT(nbt);
        } else if (chemicalType == ChemicalType.PIGMENT) {
            chemical = Pigment.readFromNBT(nbt);
        } else if (chemicalType == ChemicalType.SLURRY) {
            chemical = Slurry.readFromNBT(nbt);
        }
        return chemicalType == null || chemical == null ? EMPTY : new BoxedChemical(chemicalType, chemical);
    }

    protected BoxedChemical(ChemicalType chemicalType, Chemical<?> chemical) {
        this.chemicalType = chemicalType;
        this.chemical = chemical;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.chemical.isEmptyType();
    }

    public ChemicalType getChemicalType() {
        return this.chemicalType;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        this.chemicalType.write(nbt);
        this.chemical.write(nbt);
        return nbt;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.chemicalType);
        if (this.chemicalType == ChemicalType.GAS) {
            buffer.writeRegistryId((IForgeRegistryEntry)((Gas)this.chemical));
        } else if (this.chemicalType == ChemicalType.INFUSION) {
            buffer.writeRegistryId((IForgeRegistryEntry)((InfuseType)this.chemical));
        } else if (this.chemicalType == ChemicalType.PIGMENT) {
            buffer.writeRegistryId((IForgeRegistryEntry)((Pigment)this.chemical));
        } else if (this.chemicalType == ChemicalType.SLURRY) {
            buffer.writeRegistryId((IForgeRegistryEntry)((Slurry)this.chemical));
        } else {
            throw new IllegalStateException("Unknown chemical type");
        }
    }

    public Chemical<?> getChemical() {
        return this.chemical;
    }

    @Override
    public ITextComponent getTextComponent() {
        return this.chemical.getTextComponent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxedChemical other = (BoxedChemical)o;
        return this.chemicalType == other.chemicalType && this.chemical == other.chemical;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chemicalType, this.chemical});
    }
}

