/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.mixin;

import java.util.Random;
import mod.beethoven92.betterendforge.common.init.ModBiomes;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.world.biome.BetterEndBiome;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BoneMealItem.class})
public abstract class BoneMealItemMixin {
    private static final Direction[] DIR = BlockHelper.makeHorizontal();
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    @Inject(method={"onItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void onItemUse(ItemUseContext context, CallbackInfoReturnable<ActionResultType> info) {
        World world = context.func_195991_k();
        BlockPos blockPos = context.func_195995_a();
        if (BoneMealItem.applyBonemeal((ItemStack)context.func_195996_i(), (World)world, (BlockPos)blockPos, (PlayerEntity)context.func_195999_j())) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, blockPos, 0);
            }
            info.setReturnValue((Object)ActionResultType.func_233537_a_((boolean)world.field_72995_K));
            info.cancel();
        } else if (!world.func_201670_d()) {
            boolean endBiome;
            BlockPos offseted = blockPos.func_177972_a(context.func_196000_l());
            boolean bl = endBiome = world.func_226691_t_(offseted).func_201856_r() == Biome.Category.THEEND;
            if (world.func_180495_p(blockPos).func_235714_a_(ModTags.END_GROUND)) {
                boolean consume = false;
                if (world.func_180495_p(blockPos).func_203425_a(Blocks.field_150377_bs)) {
                    BlockState nylium = this.getNylium(world, blockPos);
                    if (nylium != null) {
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, blockPos, nylium);
                        consume = true;
                    }
                    if (!world.func_204610_c(offseted).func_206888_e() && endBiome) {
                        info.setReturnValue((Object)ActionResultType.FAIL);
                        info.cancel();
                    }
                } else if (!world.func_204610_c(offseted).func_206888_e() && endBiome) {
                    if (world.func_180495_p(offseted).func_203425_a(Blocks.field_150355_j)) {
                        consume = this.growWaterGrass(world, blockPos);
                    }
                } else if (world.func_180495_p(offseted).func_196958_f()) {
                    consume = this.growGrass(world, blockPos);
                }
                if (consume) {
                    if (!context.func_195999_j().func_184812_l_()) {
                        context.func_195996_i().func_190918_g(1);
                    }
                    world.func_217379_c(2005, blockPos, 0);
                    info.setReturnValue((Object)ActionResultType.SUCCESS);
                    info.cancel();
                }
            } else if (!world.func_204610_c(offseted).func_206888_e() && endBiome) {
                info.setReturnValue((Object)ActionResultType.FAIL);
                info.cancel();
            }
        }
    }

    private boolean growGrass(World world, BlockPos pos) {
        int y1 = pos.func_177956_o() + 3;
        int y2 = pos.func_177956_o() - 3;
        boolean result = false;
        block0: for (int i = 0; i < 64; ++i) {
            int x = (int)((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * 2.0);
            int z = (int)((double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * 2.0);
            POS.func_223471_o(x);
            POS.func_223472_q(z);
            for (int y = y1; y >= y2; --y) {
                POS.func_185336_p(y);
                BlockPos down = POS.func_177977_b();
                if (!world.func_175623_d((BlockPos)POS) || world.func_175623_d(down)) continue;
                BlockState grass = this.getGrassState(world, down);
                if (grass == null) continue block0;
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, grass);
                result = true;
                continue block0;
            }
        }
        return result;
    }

    private boolean growWaterGrass(World world, BlockPos pos) {
        int y1 = pos.func_177956_o() + 3;
        int y2 = pos.func_177956_o() - 3;
        boolean result = false;
        block0: for (int i = 0; i < 64; ++i) {
            int x = (int)((double)pos.func_177958_n() + world.field_73012_v.nextGaussian() * 2.0);
            int z = (int)((double)pos.func_177952_p() + world.field_73012_v.nextGaussian() * 2.0);
            POS.func_223471_o(x);
            POS.func_223472_q(z);
            for (int y = y1; y >= y2; --y) {
                POS.func_185336_p(y);
                BlockPos down = POS.func_177977_b();
                if (!world.func_180495_p((BlockPos)POS).func_203425_a(Blocks.field_150355_j) || !world.func_180495_p(down).func_235714_a_(ModTags.END_GROUND)) continue;
                BlockState grass = this.getWaterGrassState(world, down);
                if (grass == null) continue block0;
                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, grass);
                result = true;
                continue block0;
            }
        }
        return result;
    }

    private Block[] glowingGrasslandsGrass() {
        return new Block[]{(Block)ModBlocks.BLOOMING_COOKSONIA.get(), (Block)ModBlocks.VAIOLUSH_FERN.get(), (Block)ModBlocks.FRACTURN.get(), (Block)ModBlocks.SALTEAGO.get(), (Block)ModBlocks.CREEPING_MOSS.get(), (Block)ModBlocks.UMBRELLA_MOSS.get(), (Block)ModBlocks.TWISTED_UMBRELLA_MOSS.get()};
    }

    private BlockState getGrassState(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == ModBlocks.END_MOSS.get() || block == ModBlocks.END_MYCELIUM.get()) {
            if (world.func_226691_t_(pos).getRegistryName().equals((Object)ModBiomes.GLOWING_GRASSLANDS.getID())) {
                Block[] grasses = this.glowingGrasslandsGrass();
                return grasses[world.field_73012_v.nextInt(grasses.length)].func_176223_P();
            }
            return world.field_73012_v.nextBoolean() ? ((Block)ModBlocks.CREEPING_MOSS.get()).func_176223_P() : ((Block)ModBlocks.UMBRELLA_MOSS.get()).func_176223_P();
        }
        if (block == ModBlocks.CAVE_MOSS.get()) {
            return ((Block)ModBlocks.CAVE_GRASS.get()).func_176223_P();
        }
        if (block == ModBlocks.CHORUS_NYLIUM.get()) {
            return ((Block)ModBlocks.CHORUS_GRASS.get()).func_176223_P();
        }
        if (block == ModBlocks.CRYSTAL_MOSS.get()) {
            return ((Block)ModBlocks.CRYSTAL_GRASS.get()).func_176223_P();
        }
        if (block == ModBlocks.AMBER_MOSS.get()) {
            return ((Block)ModBlocks.AMBER_GRASS.get()).func_176223_P();
        }
        if (block == ModBlocks.SHADOW_GRASS.get()) {
            return ((Block)ModBlocks.SHADOW_PLANT.get()).func_176223_P();
        }
        if (block == ModBlocks.PINK_MOSS.get()) {
            return ((Block)ModBlocks.BUSHY_GRASS.get()).func_176223_P();
        }
        if (block == ModBlocks.JUNGLE_MOSS.get()) {
            return this.getRandomGrassState(world.field_73012_v, ((Block)ModBlocks.TWISTED_UMBRELLA_MOSS.get()).func_176223_P(), ((Block)ModBlocks.SMALL_JELLYSHROOM.get()).func_176223_P(), ((Block)ModBlocks.JUNGLE_GRASS.get()).func_176223_P());
        }
        if (block == ModBlocks.SANGNUM.get() || block == ModBlocks.MOSSY_DRAGON_BONE.get() || block == ModBlocks.MOSSY_OBSIDIAN.get()) {
            return this.getRandomGrassState(world.field_73012_v, ((Block)ModBlocks.GLOBULAGUS.get()).func_176223_P(), ((Block)ModBlocks.CLAWFERN.get()).func_176223_P(), ((Block)ModBlocks.SMALL_AMARANITA_MUSHROOM.get()).func_176223_P());
        }
        if (block == ModBlocks.RUTISCUS.get()) {
            return this.getRandomGrassState(world.field_73012_v, ((Block)ModBlocks.AERIDIUM.get()).func_176223_P(), ((Block)ModBlocks.LAMELLARIUM.get()).func_176223_P(), ((Block)ModBlocks.BOLUX_MUSHROOM.get()).func_176223_P(), ((Block)ModBlocks.ORANGO.get()).func_176223_P(), ((Block)ModBlocks.LUTEBUS.get()).func_176223_P());
        }
        return null;
    }

    private BlockState getWaterGrassState(World world, BlockPos pos) {
        BetterEndBiome biome = ModBiomes.getFromBiome(world.func_226691_t_(pos));
        if (world.field_73012_v.nextInt(16) == 0) {
            return ((Block)ModBlocks.CHARNIA_RED.get()).func_176223_P();
        }
        if (biome == ModBiomes.FOGGY_MUSHROOMLAND || biome == ModBiomes.MEGALAKE || biome == ModBiomes.MEGALAKE_GROVE) {
            return world.field_73012_v.nextBoolean() ? ((Block)ModBlocks.CHARNIA_CYAN.get()).func_176223_P() : ((Block)ModBlocks.CHARNIA_LIGHT_BLUE.get()).func_176223_P();
        }
        if (biome == ModBiomes.AMBER_LAND) {
            return world.field_73012_v.nextBoolean() ? ((Block)ModBlocks.CHARNIA_ORANGE.get()).func_176223_P() : ((Block)ModBlocks.CHARNIA_RED.get()).func_176223_P();
        }
        if (biome == ModBiomes.CHORUS_FOREST || biome == ModBiomes.SHADOW_FOREST) {
            return ((Block)ModBlocks.CHARNIA_PURPLE.get()).func_176223_P();
        }
        if (biome == ModBiomes.SULPHUR_SPRINGS) {
            return world.field_73012_v.nextBoolean() ? ((Block)ModBlocks.CHARNIA_ORANGE.get()).func_176223_P() : ((Block)ModBlocks.CHARNIA_GREEN.get()).func_176223_P();
        }
        if (biome == ModBiomes.UMBRELLA_JUNGLE) {
            return this.getRandomGrassState(world.field_73012_v, ((Block)ModBlocks.CHARNIA_CYAN.get()).func_176223_P(), ((Block)ModBlocks.CHARNIA_GREEN.get()).func_176223_P(), ((Block)ModBlocks.CHARNIA_LIGHT_BLUE.get()).func_176223_P());
        }
        if (biome == ModBiomes.GLOWING_GRASSLANDS) {
            return this.getRandomGrassState(world.field_73012_v, ((Block)ModBlocks.CHARNIA_CYAN.get()).func_176223_P(), ((Block)ModBlocks.CHARNIA_GREEN.get()).func_176223_P(), ((Block)ModBlocks.CHARNIA_LIGHT_BLUE.get()).func_176223_P());
        }
        return ((Block)ModBlocks.CHARNIA_RED.get()).func_176223_P();
    }

    private BlockState getRandomGrassState(Random rand, BlockState ... states) {
        int index = rand.nextInt(states.length);
        return states[index];
    }

    private void shuffle(Random random) {
        for (int i = 0; i < 4; ++i) {
            int j = random.nextInt(4);
            Direction d = DIR[i];
            BoneMealItemMixin.DIR[i] = DIR[j];
            BoneMealItemMixin.DIR[j] = d;
        }
    }

    private BlockState getNylium(World world, BlockPos pos) {
        this.shuffle(world.field_73012_v);
        for (Direction dir : DIR) {
            BlockState state = world.func_180495_p(pos.func_177972_a(dir));
            if (!BlockHelper.isEndNylium(state)) continue;
            return state;
        }
        return null;
    }
}

