/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.network.PacketLogReady;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGetLog
extends PacketGetListFromServer {
    private boolean fromTablet;

    public PacketGetLog(PacketBuffer buf) {
        super(buf);
        this.fromTablet = buf.readBoolean();
    }

    public PacketGetLog(RegistryKey<World> dimension, BlockPos pos, boolean fromTablet) {
        super(dimension, pos, ProcessorTileEntity.CMD_GETLOG.getName(), TypedMap.EMPTY);
        this.fromTablet = fromTablet;
    }

    public PacketGetLog(RegistryKey<World> dimension, BlockPos pos, String cmd, @Nonnull TypedMap params) {
        super(dimension, pos, cmd, params);
        this.fromTablet = false;
    }

    public PacketGetLog(BlockPos pos, String cmd, @Nonnull TypedMap params) {
        super(pos, cmd, params);
        this.fromTablet = false;
    }

    public PacketGetLog(BlockPos pos, String cmd) {
        super(pos, cmd);
        this.fromTablet = false;
    }

    public void toBytes(PacketBuffer buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.fromTablet);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te;
            ServerWorld world = LevelTools.getLevel((World)ctx.getSender().func_130014_f_(), (RegistryKey)this.dimension);
            if (world.func_175667_e(this.pos) && (te = world.func_175625_s(this.pos)) instanceof GenericTileEntity) {
                List list = ((GenericTileEntity)te).executeServerCommandList(ProcessorTileEntity.CMD_GETLOG.getName(), (PlayerEntity)ctx.getSender(), this.params, String.class);
                if (this.fromTablet) {
                    RFToolsCtrlMessages.INSTANCE.sendTo((Object)new PacketLogReady(null, ProcessorTileEntity.CMD_GETLOG.getName(), list), ctx.getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                } else {
                    RFToolsCtrlMessages.INSTANCE.sendTo((Object)new PacketLogReady(this.pos, ProcessorTileEntity.CMD_GETLOG.getName(), list), ctx.getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

