/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.blocks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.control.code.Function;
import mcjty.rftoolsbase.api.control.code.ICompiledOpcode;
import mcjty.rftoolsbase.api.control.code.IOpcodeRunnable;
import mcjty.rftoolsbase.api.control.machines.IProcessor;
import mcjty.rftoolsbase.api.control.machines.IProgram;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import mcjty.rftoolsbase.api.control.parameters.IParameter;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolsbase.api.control.parameters.Tuple;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolscontrol.compat.RFToolsStuff;
import mcjty.rftoolscontrol.modules.craftingstation.blocks.CraftingStationTileEntity;
import mcjty.rftoolscontrol.modules.multitank.blocks.MultiTankTileEntity;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankFluidProperties;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorContainer;
import mcjty.rftoolscontrol.modules.processor.client.GuiProcessor;
import mcjty.rftoolscontrol.modules.processor.items.CPUCoreItem;
import mcjty.rftoolscontrol.modules.processor.items.GraphicsCardItem;
import mcjty.rftoolscontrol.modules.processor.items.NetworkCardItem;
import mcjty.rftoolscontrol.modules.processor.items.NetworkIdentifierItem;
import mcjty.rftoolscontrol.modules.processor.items.RAMChipItem;
import mcjty.rftoolscontrol.modules.processor.logic.LogicInventoryTools;
import mcjty.rftoolscontrol.modules.processor.logic.Parameter;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTools;
import mcjty.rftoolscontrol.modules.processor.logic.TypeConverters;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledCard;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledEvent;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledOpcode;
import mcjty.rftoolscontrol.modules.processor.logic.grid.ProgramCardInstance;
import mcjty.rftoolscontrol.modules.processor.logic.registry.InventoryUtil;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Opcodes;
import mcjty.rftoolscontrol.modules.processor.logic.running.CpuCore;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import mcjty.rftoolscontrol.modules.processor.logic.running.RunningProgram;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetFluids;
import mcjty.rftoolscontrol.modules.processor.util.CardInfo;
import mcjty.rftoolscontrol.modules.processor.util.Commands;
import mcjty.rftoolscontrol.modules.processor.util.QueuedEvent;
import mcjty.rftoolscontrol.modules.processor.util.WaitForItem;
import mcjty.rftoolscontrol.modules.processor.util.WatchInfo;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpBox;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpLine;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpText;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.blocks.NodeTileEntity;
import mcjty.rftoolscontrol.modules.various.blocks.WorkbenchTileEntity;
import mcjty.rftoolscontrol.modules.various.items.TokenItem;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ProcessorTileEntity
extends TickingTileEntity
implements IProcessor {
    public static final int CARD_SLOTS = 6;
    public static final int ITEM_SLOTS = 24;
    public static final int EXPANSION_SLOTS = 16;
    public static final int MAXVARS = 32;
    public static final int MAXFLUIDVARS = 24;
    private static final BiFunction<ParameterType, Object, ItemStack> CONVERTOR_ITEM = TypeConverters::convertToItem;
    private static final BiFunction<ParameterType, Object, FluidStack> CONVERTOR_FLUID = TypeConverters::convertToFluid;
    private static final BiFunction<ParameterType, Object, BlockSide> CONVERTOR_SIDE = TypeConverters::convertToSide;
    private static final BiFunction<ParameterType, Object, Inventory> CONVERTOR_INVENTORY = TypeConverters::convertToInventory;
    private static final BiFunction<ParameterType, Object, Tuple> CONVERTOR_TUPLE = TypeConverters::convertToTuple;
    private static final BiFunction<ParameterType, Object, List<Parameter>> CONVERTOR_VECTOR = TypeConverters::convertToVector;
    private static final BiFunction<ParameterType, Object, Integer> CONVERTOR_INTEGER = TypeConverters::convertToInteger;
    private static final BiFunction<ParameterType, Object, Long> CONVERTOR_LONG = TypeConverters::convertToLong;
    private static final BiFunction<ParameterType, Object, String> CONVERTOR_STRING = TypeConverters::convertToString;
    private static final BiFunction<ParameterType, Object, Boolean> CONVERTOR_BOOL = TypeConverters::convertToBool;
    private static final BiFunction<ParameterType, Object, Number> CONVERTOR_NUMBER = TypeConverters::convertToNumber;
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, ProcessorContainer.CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (this.isExpansionSlot((int)slot)) {
            return this.isValidExpansionItem(stack.func_77973_b());
        }
        if (this.isCardSlot((int)slot)) {
            return stack.func_77973_b() == VariousModule.PROGRAM_CARD.get();
        }
        return true;
    }).onUpdate((slot, stack) -> this.onUpdateCard((int)slot)).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)Config.processorMaxenergy.get()).intValue(), (long)((Integer)Config.processorReceivepertick.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Processor").containerSupplier((windowId, player) -> ProcessorContainer.create(windowId, this.func_174877_v(), (GenericTileEntity)this, player)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    private final List<CpuCore> cpuCores = new ArrayList<CpuCore>();
    public static final int HUD_OFF = 0;
    public static final int HUD_LOG = 1;
    public static final int HUD_DB = 2;
    public static final int HUD_GFX = 3;
    @GuiValue
    private int showHud = 0;
    private boolean cardsDirty = true;
    private boolean coresDirty = true;
    private int maxVars = -1;
    private int hasNetworkCard = -1;
    private int storageCard = -2;
    private boolean hasGraphicsCard = false;
    private final Cached<List<Predicate<ItemStack>>> filterCaches = Cached.of(this::getFilterCaches);
    private final Map<String, GfxOp> gfxOps = new HashMap<String, GfxOp>();
    private List<String> orderedOps = null;
    private final List<GfxOp> clientGfxOps = new ArrayList<GfxOp>();
    @GuiValue
    private boolean exclusive = false;
    private String lastException = null;
    private long lastExceptionTime = 0L;
    private String channel = "";
    private final Map<String, BlockPos> networkNodes = new HashMap<String, BlockPos>();
    private final Set<BlockPos> craftingStations = new HashSet<BlockPos>();
    private int prevIn = 0;
    private int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    private int tickCount = 0;
    private final Parameter[] variables = new Parameter[32];
    private final WatchInfo[] watchInfos = new WatchInfo[32];
    private int fluidSlotsAvailable = -1;
    private final CardInfo[] cardInfo = new CardInfo[6];
    private Queue<QueuedEvent> eventQueue = new ArrayDeque<QueuedEvent>();
    private final List<WaitForItem> waitingForItems = new ArrayList<WaitForItem>();
    private final Queue<String> logMessages = new ArrayDeque<String>();
    public long clientTime = 0L;
    private List<String> clientLog = new ArrayList<String>();
    private List<String> clientDebugLog = new ArrayList<String>();
    private Set<Pair<Integer, Integer>> runningEvents = new HashSet<Pair<Integer, Integer>>();
    private final Set<String> locks = new HashSet<String>();
    private RegistryKey<World> dummyType = null;
    public static final Key<Integer> PARAM_CARD = new Key("card", Type.INTEGER);
    public static final Key<Integer> PARAM_ITEMS = new Key("items", Type.INTEGER);
    public static final Key<Integer> PARAM_VARS = new Key("vars", Type.INTEGER);
    public static final Key<Integer> PARAM_FLUID = new Key("fluids", Type.INTEGER);
    public static final Key<String> PARAM_CMD = new Key("cmd", Type.STRING);
    public static final Key<Boolean> PARAM_EXCLUSIVE = new Key("exclusive", Type.BOOLEAN);
    public static final Key<Integer> PARAM_HUDMODE = new Key("hudmode", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_ALLOCATE = Command.create((String)"allocate", (te, player, params) -> {
        int card = (Integer)params.get(PARAM_CARD);
        int itemAlloc = (Integer)params.get(PARAM_ITEMS);
        int varAlloc = (Integer)params.get(PARAM_VARS);
        int fluidAlloc = (Integer)params.get(PARAM_FLUID);
        te.allocate(card, itemAlloc, varAlloc, fluidAlloc);
    });
    @ServerCommand
    public static final Command<?> CMD_EXECUTE = Command.create((String)"execute", (te, player, params) -> Commands.executeCommand(te, (String)params.get(PARAM_CMD)));
    @ServerCommand
    public static final Command<?> CMD_SETEXCLUSIVE = Command.create((String)"setExclusive", (te, player, params) -> te.setExclusive((Boolean)params.get(PARAM_EXCLUSIVE)));
    @ServerCommand
    public static final Command<?> CMD_SETHUDMODE = Command.create((String)"setHudMode", (te, player, params) -> te.setShowHud((Integer)params.get(PARAM_HUDMODE)));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETDEBUGLOG = ListCommand.create((String)"rftoolscontrol.processor.getDebugLog", (te, player, params) -> te.getDebugLog(), (te, player, params, list) -> {
        te.clientDebugLog = list;
    });
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETLOG = ListCommand.create((String)"rftoolscontrol.processor.getLog", (te, player, params) -> te.getLog(), (te, player, params, list) -> {
        te.clientLog = list;
    });
    @ServerCommand(type=Parameter.class, serializer=Parameter.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETVARS = ListCommand.create((String)"rftoolscontrol.processor.getVars", (te, player, params) -> te.getVariables(), (te, player, params, list) -> GuiProcessor.storeVarsForClient(list));
    @ServerCommand(type=PacketGetFluids.FluidEntry.class, serializer=PacketGetFluids.FluidEntry.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETFLUIDS = ListCommand.create((String)"rftoolscontrol.processor.getFluids", (te, player, params) -> te.getFluids(), (te, player, params, list) -> GuiProcessor.storeFluidsForClient(list));

    public ProcessorTileEntity() {
        super((TileEntityType)ProcessorModule.PROCESSOR_TILE.get());
        int i;
        for (i = 0; i < this.cardInfo.length; ++i) {
            this.cardInfo[i] = new CardInfo();
        }
        for (i = 0; i < 32; ++i) {
            this.variables[i] = null;
            this.watchInfos[i] = null;
        }
        this.fluidSlotsAvailable = -1;
    }

    public ProcessorTileEntity(RegistryKey<World> type) {
        this();
        this.dummyType = type;
    }

    public boolean isDummy() {
        return this.dummyType != null;
    }

    public RegistryKey<World> getDimension() {
        if (this.dummyType != null) {
            return this.dummyType;
        }
        return super.getDimension();
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        this.func_70296_d();
    }

    public Parameter getParameter(int idx) {
        return this.variables[idx];
    }

    public boolean isFluidSlotAvailable(int idx) {
        int sideIndex = idx / 4;
        return (this.getFluidSlotsAvailable() & 1 << sideIndex) != 0;
    }

    private BlockPos getAdjacentPosition(@Nonnull BlockSide side) {
        BlockPos p;
        if (side.getNodeName() != null && !side.getNodeName().isEmpty()) {
            p = this.networkNodes.get(side.getNodeName());
            if (p == null) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof NodeTileEntity)) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
        } else {
            p = this.field_174879_c;
        }
        return p;
    }

    public int readRedstoneIn(@Nonnull BlockSide side) {
        Direction facing = side.getSide();
        BlockPos p = this.getAdjacentPosition(side);
        if (p == null) {
            return 0;
        }
        return this.field_145850_b.func_175651_c(p.func_177972_a(facing), facing);
    }

    public void setPowerOut(@Nonnull BlockSide side, int amount) {
        Direction facing = side.getSide();
        BlockPos p = this.getAdjacentPosition(side);
        if (p == null) {
            return;
        }
        if (amount < 0) {
            amount = 0;
        } else if (amount > 15) {
            amount = 15;
        }
        if (p.equals((Object)this.field_174879_c)) {
            this.powerOut[facing.ordinal()] = amount;
            this.func_70296_d();
            this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(facing), this.func_195044_w().func_177230_c(), this.field_174879_c);
        } else {
            NodeTileEntity te = (NodeTileEntity)this.field_145850_b.func_175625_s(p);
            te.setPowerOut(facing, amount);
        }
    }

    public int getPowerOut(Direction side) {
        return this.powerOut[side.ordinal()];
    }

    public void tickServer() {
        this.process();
        this.prevIn = this.powerLevel;
    }

    private void process() {
        ++this.tickCount;
        this.func_70296_d();
        this.updateCores();
        this.compileCards();
        this.processEventQueue();
        try {
            this.handleEvents();
        }
        catch (ProgException e) {
            this.exception(e.getExceptionType(), null);
        }
        this.run();
    }

    private void processEventQueue() {
        QueuedEvent queuedEvent = this.eventQueue.peek();
        if (queuedEvent != null) {
            CompiledEvent compiledEvent = queuedEvent.getCompiledEvent();
            if (compiledEvent.isSingle() && this.runningEvents.contains(Pair.of((Object)queuedEvent.getCardIndex(), (Object)compiledEvent.getIndex()))) {
                return;
            }
            CpuCore core = this.findAvailableCore(queuedEvent.getCardIndex());
            if (core != null) {
                this.eventQueue.remove();
                RunningProgram program = new RunningProgram(queuedEvent.getCardIndex());
                program.startFromEvent(compiledEvent);
                program.setCraftTicket(queuedEvent.getTicket());
                program.setLastValue(queuedEvent.getParameter());
                core.startProgram(program);
                if (compiledEvent.isSingle()) {
                    this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)queuedEvent.getCardIndex(), (Object)compiledEvent.getIndex()));
                }
            }
        }
    }

    public void getCraftableItems(List<ItemStack> stacks) {
        try {
            for (CardInfo info : this.cardInfo) {
                CompiledCard compiledCard = info.getCompiledCard();
                if (compiledCard == null) continue;
                for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFT)) {
                    int index = event.getIndex();
                    CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                    ItemStack stack = this.evaluateItemParameter(compiledOpcode, null, 0);
                    Inventory inv = this.evaluateInventoryParameter(compiledOpcode, null, 1);
                    if (!stack.func_190926_b() && inv != null) {
                        throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
                    }
                    if (stack.func_190926_b() && inv == null) {
                        throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
                    }
                    if (!stack.func_190926_b()) {
                        stacks.add(stack);
                        continue;
                    }
                    this.getItemHandlerAt(inv).ifPresent(handler -> {
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            ItemStack result;
                            ItemStack s = handler.getStackInSlot(i);
                            if (s.func_190926_b() || s.func_77973_b() != RFToolsStuff.CRAFTING_CARD || (result = CraftingCardItem.getResult((ItemStack)s)).func_190926_b()) continue;
                            stacks.add(result);
                        }
                    });
                }
            }
        }
        catch (ProgException e) {
            this.exception(e.getExceptionType(), null);
        }
    }

    public void craftOk(IProgram program, @Nullable Integer slot) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        String ticket = program.getCraftTicket();
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        Integer realSlot = info.getRealSlot(slot);
        ItemStack craftedItem = ItemStack.field_190927_a;
        if (realSlot != null) {
            craftedItem = this.items.getStackInSlot(realSlot.intValue());
        }
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            craftedItem = craftingStation.craftOk(this, ticket, craftedItem);
        }
        if (realSlot != null) {
            this.items.setStackInSlot(realSlot.intValue(), craftedItem);
        }
    }

    public void craftFail(IProgram program) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        String ticket = program.getCraftTicket();
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            craftingStation.craftFail(ticket);
        }
    }

    public boolean pushItemsWorkbench(IProgram program, @Nonnull BlockSide workbench, ItemStack item, int slot1, int slot2) {
        if (item.func_190926_b()) {
            item = this.getCraftResult(program);
        }
        if (item.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        TileEntity te = this.getTileEntityAt(workbench);
        if (!(te instanceof WorkbenchTileEntity)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTAWORKBENCH);
        }
        ItemStack finalItem = item;
        ItemStack card = this.getItemHandlerAt(te, Direction.EAST).map(handler -> this.findCraftingCard((IItemHandler)handler, finalItem)).orElse(ItemStack.field_190927_a);
        if (card.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        if (!CraftingCardItem.fitsGrid((ItemStack)card)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTAGRID);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        GenericItemHandler itemHandler = this.items;
        return this.getItemHandlerAt(te, Direction.UP).map(arg_0 -> ProcessorTileEntity.lambda$pushItemsWorkbench$8(card, slot1, slot2, info, (IItemHandler)itemHandler, arg_0)).orElse(false);
    }

    public int pushItemsMulti(IProgram program, @Nullable Inventory inv, int slot1, int slot2, @Nullable Integer extSlot) {
        return this.getHandlerForInv(inv).map(handler -> {
            IStorageScanner scanner = this.getScannerForInv(inv);
            CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
            int e = 0;
            if (extSlot != null) {
                e = extSlot;
            }
            int failed = 0;
            for (int slot = slot1; slot <= slot2; ++slot) {
                int realSlot = info.getRealSlot(slot);
                ItemStack stack = this.items.getStackInSlot(realSlot);
                if (!stack.func_190926_b()) {
                    ItemStack remaining = LogicInventoryTools.insertItem(handler, scanner, stack, extSlot == null ? null : Integer.valueOf(e));
                    if (!remaining.func_190926_b()) {
                        ++failed;
                    }
                    this.items.setStackInSlot(realSlot, remaining);
                }
                ++e;
            }
            return failed;
        }).orElse(0);
    }

    public int countCardIngredients(IProgram program, @Nullable Inventory inv, ItemStack card) {
        IStorageScanner scanner = this.getScannerForInv(inv);
        return this.getHandlerForInv(inv).map(handler -> {
            List ingredients = CraftingCardItem.getIngredients((ItemStack)card);
            List<Ingredient> needed = this.combineIngredients(ingredients);
            return this.countPossibleCrafts(scanner, (IItemHandler)handler, needed);
        }).orElse(0);
    }

    public boolean checkIngredients(IProgram program, @Nonnull Inventory cardInv, ItemStack item, int slot1, int slot2) {
        if (item.func_190926_b()) {
            item = this.getCraftResult(program);
        }
        if (item.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        ItemStack finalItem = item;
        ItemStack card = this.getItemHandlerAt(cardInv).map(cardHandler -> this.findCraftingCard((IItemHandler)cardHandler, finalItem)).orElse(ItemStack.field_190927_a);
        if (card.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int slot = slot1;
        List ingredients = CraftingCardItem.fitsGrid((ItemStack)card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid((ItemStack)card) : CraftingCardItem.getIngredients((ItemStack)card);
        boolean failed = false;
        for (Ingredient ingredient : ingredients) {
            int realSlot = info.getRealSlot(slot);
            ItemStack localStack = this.items.getStackInSlot(realSlot);
            if (ingredient != Ingredient.field_193370_a) {
                if (!ingredient.test(localStack)) {
                    return false;
                }
                if (LogicInventoryTools.getCountFromIngredient(ingredient) != localStack.func_190916_E()) {
                    return false;
                }
            } else if (!localStack.func_190926_b()) {
                return false;
            }
            ++slot;
        }
        return true;
    }

    public int getIngredientsSmart(IProgram program, Inventory inv, @Nonnull Inventory cardInv, ItemStack inputStack, int slot1, int slot2, @Nonnull Inventory destInv) {
        IStorageScanner scanner = this.getScannerForInv(inv);
        return this.getHandlerForInv(inv).map(handler -> {
            ItemStack item = inputStack;
            if (item.func_190926_b()) {
                item = this.getCraftResult(program);
            }
            if (item.func_190926_b()) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
            }
            ItemStack finalItem = item;
            return (Integer)this.getHandlerForInv(destInv).map(destHandler -> {
                ItemStack card = this.getItemHandlerAt(cardInv).map(cardHandler -> this.findCraftingCard((IItemHandler)cardHandler, finalItem)).orElse(ItemStack.field_190927_a);
                if (card.func_190926_b()) {
                    throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
                }
                CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
                List ingredients = CraftingCardItem.fitsGrid((ItemStack)card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid((ItemStack)card) : CraftingCardItem.getIngredients((ItemStack)card);
                List<Ingredient> needed = this.combineIngredients(ingredients);
                int requested = this.checkAvailableItemsAndRequestMissing(destInv, scanner, (IItemHandler)handler, needed);
                if (requested != 0) {
                    return requested;
                }
                int slot = slot1;
                for (Ingredient ingredient : ingredients) {
                    ItemStack stack;
                    int realSlot = info.getRealSlot(slot);
                    if (ingredient != Ingredient.field_193370_a && !(stack = LogicInventoryTools.extractItem(handler, scanner, LogicInventoryTools.getCountFromIngredient(ingredient), true, ingredient, null)).func_190926_b()) {
                        this.items.insertItem(realSlot, stack, false);
                    }
                    ++slot;
                }
                return 0;
            }).orElseThrow(() -> new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY));
        }).orElse(0);
    }

    private int checkAvailableItemsAndRequestMissing(Inventory destInv, IStorageScanner scanner, IItemHandler handler, List<Ingredient> needed) {
        int requested = 0;
        for (Ingredient ingredient : needed) {
            int countFromIngredient;
            int cnt;
            if (ingredient == Ingredient.field_193370_a || (cnt = LogicInventoryTools.countItem(handler, scanner, ingredient, countFromIngredient = LogicInventoryTools.getCountFromIngredient(ingredient))) >= countFromIngredient) continue;
            ++requested;
            if (this.isRequested(ingredient) || this.requestCraft(ingredient, destInv)) continue;
            return -1;
        }
        return requested;
    }

    private int countPossibleCrafts(IStorageScanner scanner, IItemHandler handler, List<Ingredient> needed) {
        int maxPossible = Integer.MAX_VALUE;
        for (Ingredient ingredient : needed) {
            int cnt;
            int possible;
            if (ingredient == Ingredient.field_193370_a || (possible = (cnt = LogicInventoryTools.countItem(handler, scanner, ingredient, -1)) / LogicInventoryTools.getCountFromIngredient(ingredient)) >= maxPossible) continue;
            maxPossible = possible;
        }
        return maxPossible;
    }

    private List<Ingredient> combineIngredients(List<Ingredient> ingredients) {
        return ingredients;
    }

    public int getIngredients(IProgram program, Inventory inv, Inventory cardInv, ItemStack inputStack, int slot1, int slot2) {
        IStorageScanner scanner = this.getScannerForInv(inv);
        return this.getHandlerForInv(inv).map(handler -> {
            ItemStack item = inputStack;
            if (item.func_190926_b()) {
                item = this.getCraftResult(program);
            }
            if (item.func_190926_b()) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
            }
            ItemStack finalItem = item;
            ItemStack card = this.getItemHandlerAt(cardInv).map(cardHandler -> this.findCraftingCard((IItemHandler)cardHandler, finalItem)).orElse(ItemStack.field_190927_a);
            if (card.func_190926_b()) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
            }
            CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
            int slot = slot1;
            List ingredients = CraftingCardItem.fitsGrid((ItemStack)card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid((ItemStack)card) : CraftingCardItem.getIngredients((ItemStack)card);
            int failed = 0;
            for (Ingredient ingredient : ingredients) {
                int realSlot = info.getRealSlot(slot);
                if (ingredient != Ingredient.field_193370_a) {
                    ItemStack stack = LogicInventoryTools.extractItem(handler, scanner, LogicInventoryTools.getCountFromIngredient(ingredient), true, ingredient, null);
                    if (!stack.func_190926_b()) {
                        ItemStack remainder = this.items.insertItem(realSlot, stack, false);
                        if (!remainder.func_190926_b()) {
                            LogicInventoryTools.insertItem(handler, scanner, remainder, null);
                        }
                    } else {
                        ++failed;
                    }
                }
                ++slot;
            }
            return failed;
        }).orElse(0);
    }

    public void craftWait(IProgram program, @Nonnull Inventory inv, ItemStack stack) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        if (stack.func_190926_b() && (stack = this.getCraftResult(program)).func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        WaitForItem waitForItem = new WaitForItem(program.getCraftTicket(), stack, inv);
        this.waitingForItems.add(waitForItem);
        this.func_70296_d();
    }

    public void craftWaitTimed(IProgram program) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        WaitForItem waitForItem = new WaitForItem(program.getCraftTicket(), ItemStack.field_190927_a, null);
        this.waitingForItems.add(waitForItem);
        this.func_70296_d();
    }

    public boolean isRequested(Ingredient ingredient) {
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            return craftingStation.isRequested(ingredient);
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGSTATION);
    }

    public boolean requestCraft(@Nonnull Ingredient ingredient, @Nullable Inventory inventory) {
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            return craftingStation.request(ingredient, inventory);
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGSTATION);
    }

    public void setCraftTicket(IProgram program, String ticket) {
        ((RunningProgram)program).setCraftTicket(ticket);
    }

    public ItemStack getItemFromCard(IProgram program) {
        Parameter lastValue = (Parameter)program.getLastValue();
        if (lastValue == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGLASTVALUE);
        }
        ItemStack itemStack = TypeConverters.convertToItem(lastValue);
        if (itemStack.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_NOTANITEM);
        }
        if (itemStack.func_77973_b() instanceof CraftingCardItem) {
            return CraftingCardItem.getResult((ItemStack)itemStack);
        }
        if (itemStack.func_77973_b() instanceof TokenItem && itemStack.func_77942_o()) {
            CompoundNBT tag = itemStack.func_77978_p().func_74775_l("parameter");
            if (tag.isEmpty()) {
                return ItemStack.field_190927_a;
            }
            Parameter parameter = ParameterTools.readFromNBT(tag);
            if (parameter == null || !parameter.isSet()) {
                return ItemStack.field_190927_a;
            }
            return TypeConverters.convertToItem(parameter);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getCraftResult(IProgram program) {
        if (!program.hasCraftTicket()) {
            return ItemStack.field_190927_a;
        }
        for (BlockPos p : this.craftingStations) {
            CraftingStationTileEntity craftingStation;
            ItemStack stack;
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity) || (stack = (craftingStation = (CraftingStationTileEntity)te).getCraftResult(program.getCraftTicket())).func_190926_b()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack findCraftingCard(IProgram program, Inventory inventory, ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.getHandlerForInv(inventory).map(handler -> this.findCraftingCard((IItemHandler)handler, stack)).orElseThrow(() -> new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY));
    }

    private ItemStack findCraftingCard(IItemHandler handler, ItemStack craftResult) {
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack result;
            ItemStack s = handler.getStackInSlot(j);
            if (s.func_190926_b() || s.func_77973_b() != RFToolsStuff.CRAFTING_CARD || (result = CraftingCardItem.getResult((ItemStack)s)).func_190926_b() || !LogicInventoryTools.areItemsEqual(result, craftResult, true, true)) continue;
            return s;
        }
        return ItemStack.field_190927_a;
    }

    public void fireCraftEvent(String ticket, ItemStack stackToCraft) {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFT)) {
                ItemStack craftingCard;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                ItemStack stack = this.evaluateItemParameter(compiledOpcode, null, 0);
                Inventory inv = this.evaluateInventoryParameter(compiledOpcode, null, 1);
                if (!stack.func_190926_b()) {
                    if (!stack.func_77969_a(stackToCraft)) continue;
                    this.runOrQueueEvent(i, event, ticket, null);
                    return;
                }
                if (inv == null || (craftingCard = this.getItemHandlerAt(inv).map(handler -> this.findCraftingCard((IItemHandler)handler, stackToCraft)).orElse(ItemStack.field_190927_a)).func_190926_b()) continue;
                this.runOrQueueEvent(i, event, ticket, null);
                return;
            }
        }
    }

    private void handleEvents() {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            this.handleEventsRedstoneOn(i, compiledCard);
            this.handleEventsRedstoneOff(i, compiledCard);
            this.handleEventsTimer(i, compiledCard);
            this.handleEventsCraftResume(i, compiledCard);
        }
    }

    private void handleEventsCraftResume(int cardIndex, CompiledCard compiledCard) {
        for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFTRESUME)) {
            int index = event.getIndex();
            CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
            int ticks = this.evaluateIntParameter(compiledOpcode, null, 0);
            if (ticks <= 0 || this.tickCount % ticks != 0 || this.waitingForItems.isEmpty()) continue;
            WaitForItem found = null;
            int foundIdx = -1;
            for (int i = 0; i < this.waitingForItems.size(); ++i) {
                WaitForItem wfi = this.waitingForItems.get(i);
                if (wfi.getInventory() == null || wfi.getItemStack().func_190926_b()) {
                    foundIdx = i;
                    found = wfi;
                    break;
                }
                int cnt = this.getItemHandlerAt(wfi.getInventory()).map(handler -> this.countItemInHandler(wfi.getItemStack(), (IItemHandler)handler)).orElse(0);
                if (cnt < wfi.getItemStack().func_190916_E()) continue;
                foundIdx = i;
                found = wfi;
                break;
            }
            if (found == null) continue;
            this.waitingForItems.remove(foundIdx);
            this.runOrQueueEvent(cardIndex, event, found.getTicket(), null);
        }
    }

    private void handleEventsTimer(int i, CompiledCard compiledCard) {
        for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_TIMER)) {
            int index = event.getIndex();
            CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
            int ticks = this.evaluateIntParameter(compiledOpcode, null, 0);
            if (ticks <= 0 || this.tickCount % ticks != 0) continue;
            this.runOrDropEvent(i, event, null, null);
        }
    }

    private void handleEventsRedstoneOff(int i, CompiledCard compiledCard) {
        int redstoneOffMask = this.prevIn & ~this.powerLevel;
        if (redstoneOffMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_OFF)) {
                Direction facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side != null && side.hasNodeName()) continue;
                Direction direction = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOffMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOn(int i, CompiledCard compiledCard) {
        int redstoneOnMask = this.powerLevel & ~this.prevIn;
        if (redstoneOnMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_ON)) {
                Direction facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side != null && side.hasNodeName()) continue;
                Direction direction = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOnMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOff(int i, CompiledCard compiledCard, String node, int prevMask, int newMask) {
        int redstoneOffMask = prevMask & ~newMask;
        if (redstoneOffMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_OFF)) {
                Direction facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side == null || !node.equals(side.getNodeName()) || (facing = side.getSide()) != null && (redstoneOffMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOn(int i, CompiledCard compiledCard, String node, int prevMask, int newMask) {
        int redstoneOnMask = newMask & ~prevMask;
        if (redstoneOnMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_ON)) {
                Direction facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side == null || !node.equals(side.getNodeName()) || (facing = side.getSide()) != null && (redstoneOnMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    public void clearRunningEvent(int cardIndex, int eventIndex) {
        this.runningEvents.remove(Pair.of((Object)cardIndex, (Object)eventIndex));
    }

    private void runOrDropEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        if (event.isSingle() && this.runningEvents.contains(Pair.of((Object)cardIndex, (Object)event.getIndex()))) {
            return;
        }
        CpuCore core = this.findAvailableCore(cardIndex);
        if (core == null) {
            for (QueuedEvent q : this.eventQueue) {
                if (q.getCardIndex() != cardIndex || !q.getCompiledEvent().equals(event)) continue;
                return;
            }
            this.queueEvent(cardIndex, event, ticket, parameter);
        } else {
            RunningProgram program = new RunningProgram(cardIndex);
            program.startFromEvent(event);
            program.setCraftTicket(ticket);
            program.setLastValue(parameter);
            core.startProgram(program);
            if (event.isSingle()) {
                this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)event.getIndex()));
            }
        }
    }

    private void runOrQueueEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        if (event.isSingle() && this.runningEvents.contains(Pair.of((Object)cardIndex, (Object)event.getIndex()))) {
            this.queueEvent(cardIndex, event, ticket, parameter);
            return;
        }
        CpuCore core = this.findAvailableCore(cardIndex);
        if (core == null) {
            this.queueEvent(cardIndex, event, ticket, parameter);
        } else {
            RunningProgram program = new RunningProgram(cardIndex);
            program.startFromEvent(event);
            program.setCraftTicket(ticket);
            program.setLastValue(parameter);
            core.startProgram(program);
            if (event.isSingle()) {
                this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)event.getIndex()));
            }
        }
    }

    private void queueEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        if (this.eventQueue.size() >= (Integer)Config.maxEventQueueSize.get()) {
            throw new ProgException(ExceptionType.EXCEPT_TOOMANYEVENTS);
        }
        this.eventQueue.add(new QueuedEvent(cardIndex, event, ticket, parameter));
    }

    public int signal(String signal) {
        int cnt = 0;
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_SIGNAL)) {
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String sig = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!signal.equals(sig)) continue;
                this.runOrQueueEvent(i, event, null, null);
                ++cnt;
            }
        }
        return cnt;
    }

    public int signal(Tuple location) {
        int cnt = 0;
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_GFX_SELECT)) {
                int index = event.getIndex();
                this.runOrQueueEvent(i, event, null, Parameter.builder().type(ParameterType.PAR_TUPLE).value(ParameterValue.constant((Object)location)).build());
                ++cnt;
            }
        }
        return cnt;
    }

    public void receiveMessage(String name, @Nullable Parameter value) {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_MESSAGE)) {
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String messageName = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!name.equals(messageName)) continue;
                this.runOrQueueEvent(i, event, null, value);
            }
        }
    }

    private String getStatus(int c) {
        String db;
        CpuCore core = this.cpuCores.get(c);
        String string = db = core.isDebug() ? "[DB] " : "";
        if (core.hasProgram()) {
            RunningProgram program = core.getProgram();
            if (program.getDelay() > 0) {
                return db + "<delayed: " + program.getDelay() + ">";
            }
            if (program.getLock() != null) {
                return db + "<locked: " + program.getLock() + ">";
            }
            return db + "<busy>";
        }
        return db + "<idle>";
    }

    public void listStatus() {
        int n = 0;
        for (CpuCore core : this.getCpuCores()) {
            this.log("Core: " + n + " -> " + this.getStatus(n));
            ++n;
        }
        this.log("Event queue: " + this.eventQueue.size());
        this.log("Waiting items: " + this.waitingForItems.size());
        this.log("Locks: " + this.locks.size());
        if (this.lastException != null) {
            long dt = System.currentTimeMillis() - this.lastExceptionTime;
            this.log("Last: " + TextFormatting.RED + this.lastException);
            if (dt > 3600000L) {
                this.log("(" + dt / 1000L + "hours ago)");
            } else if (dt > 60000L) {
                this.log("(" + dt / 60000L + "min ago)");
            } else if (dt > 1000L) {
                this.log("(" + dt / 1000L + "sec ago)");
            } else {
                this.log("(" + dt + "ms ago)");
            }
        }
    }

    public int stopPrograms() {
        int n = 0;
        for (CpuCore core : this.getCpuCores()) {
            if (!core.hasProgram()) continue;
            ++n;
            core.stopProgram();
        }
        this.locks.clear();
        this.runningEvents.clear();
        return n;
    }

    public void reset() {
        this.waitingForItems.clear();
        this.eventQueue.clear();
        this.stopPrograms();
        for (Direction facing : Direction.values()) {
            this.powerOut[facing.ordinal()] = 0;
        }
        for (BlockPos np : this.networkNodes.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(np);
            if (!(te instanceof NodeTileEntity)) continue;
            NodeTileEntity tileEntity = (NodeTileEntity)te;
            for (Direction facing : Direction.values()) {
                tileEntity.setPowerOut(facing, 0);
            }
        }
        this.gfxOps.clear();
        this.orderedOps.clear();
        for (CpuCore core : this.cpuCores) {
            core.setDebug(false);
        }
        this.func_70296_d();
    }

    public IOpcodeRunnable.OpcodeResult placeLock(String name) {
        if (this.testLock(name)) {
            return IOpcodeRunnable.OpcodeResult.HOLD;
        }
        this.locks.add(name);
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }

    public void releaseLock(String name) {
        this.locks.remove(name);
    }

    public boolean testLock(String name) {
        return this.locks.contains(name);
    }

    public void clearLog() {
        this.logMessages.clear();
        this.lastException = null;
        this.func_70296_d();
    }

    public void exception(ExceptionType exception, @Nullable RunningProgram program) {
        String message;
        if (exception != ExceptionType.EXCEPT_TOOMANYEVENTS) {
            for (int i = 0; i < this.cardInfo.length; ++i) {
                CardInfo info = this.cardInfo[i];
                CompiledCard compiledCard = info.getCompiledCard();
                if (compiledCard == null) continue;
                for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_EXCEPTION)) {
                    int index = event.getIndex();
                    CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                    String code = this.evaluateStringParameter(compiledOpcode, null, 0);
                    if (!exception.getCode().equals(code)) continue;
                    this.runOrQueueEvent(i, event, program == null ? null : program.getCraftTicket(), null);
                    return;
                }
            }
        }
        if (program != null) {
            CompiledCard card = this.getCompiledCard(program.getCardIndex());
            if (card == null) {
                message = TextFormatting.RED + "INTERNAL: " + exception.getDescription();
            } else {
                CompiledOpcode opcode = program.getCurrentOpcode(this);
                int gridX = opcode.getGridX();
                int gridY = opcode.getGridY();
                message = TextFormatting.RED + "[" + gridX + "," + gridY + "] " + exception.getDescription() + " (" + program.getCardIndex() + ")";
            }
        } else {
            message = TextFormatting.RED + exception.getDescription();
        }
        this.lastException = message;
        this.lastExceptionTime = System.currentTimeMillis();
        this.log(message);
    }

    public void log(String message) {
        if (message == null) {
            return;
        }
        this.logMessages.add(message);
        while (this.logMessages.size() > (Integer)Config.processorMaxloglines.get()) {
            this.logMessages.remove();
        }
    }

    private List<String> getDebugLog() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < Math.min(5, this.cpuCores.size()); ++i) {
            result.add(TextFormatting.BLUE + "Core " + i + " " + TextFormatting.WHITE + this.getStatus(i));
        }
        this.showWithWarn("Event queue: ", this.eventQueue.size(), 20, result);
        this.showWithWarn("Waiting items: ", this.waitingForItems.size(), 20, result);
        this.showWithWarn("Locks: ", this.locks.size(), 10, result);
        if (this.lastException != null) {
            long dt = System.currentTimeMillis() - this.lastExceptionTime;
            result.add(TextFormatting.RED + this.lastException);
            if (dt > 3600000L) {
                result.add("(" + dt / 1000L + "hours ago)");
            } else if (dt > 60000L) {
                result.add("(" + dt / 60000L + "min ago)");
            } else if (dt > 1000L) {
                result.add("(" + dt / 1000L + "sec ago)");
            } else {
                result.add("(" + dt + "ms ago)");
            }
        }
        return result;
    }

    private void showWithWarn(String label, int size, int max, List<String> result) {
        if (size >= max) {
            result.add(label + TextFormatting.RED + size);
        } else {
            result.add(label + TextFormatting.GREEN + size);
        }
    }

    private List<String> getLog() {
        return this.logMessages.stream().collect(Collectors.toList());
    }

    public List<String> getClientLog() {
        return this.clientLog;
    }

    public List<String> getClientDebugLog() {
        return this.clientDebugLog;
    }

    public List<String> getLastMessages(int n) {
        ArrayList<String> rc = new ArrayList<String>();
        int i = 0;
        for (String s : this.logMessages) {
            if (i >= this.logMessages.size() - n) {
                rc.add(s);
            }
            ++i;
        }
        return rc;
    }

    public int getFluidSlotsAvailable() {
        if (this.fluidSlotsAvailable == -1) {
            this.updateFluidSlotsAvailability();
        }
        return this.fluidSlotsAvailable;
    }

    public Parameter[] getVariableArray() {
        return this.variables;
    }

    public List<Parameter> getVariables() {
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        Collections.addAll(pars, this.variables);
        return pars;
    }

    public WatchInfo[] getWatchInfos() {
        return this.watchInfos;
    }

    public void setWatch(int varIndex, boolean br) {
        this.watchInfos[varIndex] = new WatchInfo(br);
        this.markDirtyQuick();
    }

    public void clearWatch(int varIndex) {
        this.watchInfos[varIndex] = null;
        this.markDirtyQuick();
    }

    public List<PacketGetFluids.FluidEntry> getFluids() {
        ArrayList<PacketGetFluids.FluidEntry> pars = new ArrayList<PacketGetFluids.FluidEntry>();
        for (int i = 0; i < 24; ++i) {
            if (this.isFluidSlotAvailable(i)) {
                Direction side = Direction.values()[i / 4];
                TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
                if (te instanceof MultiTankTileEntity) {
                    MultiTankTileEntity mtank = (MultiTankTileEntity)te;
                    MultiTankFluidProperties[] propertyList = mtank.getProperties();
                    MultiTankFluidProperties properties = propertyList[i % 4];
                    FluidStack fluidStack = properties == null ? null : properties.getContents();
                    pars.add(new PacketGetFluids.FluidEntry(fluidStack, true));
                    continue;
                }
                pars.add(new PacketGetFluids.FluidEntry(null, true));
                continue;
            }
            pars.add(new PacketGetFluids.FluidEntry(null, false));
        }
        return pars;
    }

    public List<CpuCore> getCpuCores() {
        return this.cpuCores;
    }

    private CpuCore findAvailableCore(int cardIndex) {
        if (this.exclusive) {
            CpuCore core;
            if (cardIndex < this.cpuCores.size() && !(core = this.cpuCores.get(cardIndex)).hasProgram()) {
                return core;
            }
        } else {
            for (CpuCore core : this.cpuCores) {
                if (core.hasProgram()) continue;
                return core;
            }
        }
        return null;
    }

    private void run() {
        long rf = this.energyStorage.getEnergy();
        for (CpuCore core : this.cpuCores) {
            int rft;
            if (!core.hasProgram() || (long)(rft = ((Integer)Config.coreRFPerTick[core.getTier()].get()).intValue()) >= rf) continue;
            core.run(this);
            this.energyStorage.consumeEnergy((long)rft);
            rf -= (long)rft;
        }
    }

    private void updateCores() {
        if (this.coresDirty) {
            this.coresDirty = false;
            this.cpuCores.clear();
            for (int i = 0; i < 16; ++i) {
                ItemStack expansionStack = this.items.getStackInSlot(i);
                if (expansionStack.func_190926_b() || !(expansionStack.func_77973_b() instanceof CPUCoreItem)) continue;
                CPUCoreItem coreItem = (CPUCoreItem)expansionStack.func_77973_b();
                CpuCore core = new CpuCore();
                core.setTier(coreItem.getTier());
                this.cpuCores.add(core);
            }
        }
    }

    private void compileCards() {
        if (this.cardsDirty) {
            this.cardsDirty = false;
            for (int i = 16; i < 22; ++i) {
                int cardIndex;
                ItemStack cardStack = this.items.getStackInSlot(i);
                if (cardStack.func_190926_b() || this.cardInfo[cardIndex = i - 16].getCompiledCard() != null) continue;
                CompiledCard compiled = CompiledCard.compile(ProgramCardInstance.parseInstance(cardStack));
                this.cardInfo[cardIndex].setCompiledCard(compiled);
            }
        }
    }

    public String getMachineInfo(Inventory side, int idx) {
        TileEntity te = this.getTileEntityAt((BlockSide)side);
        return (String)te.getCapability(CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY).map(h -> {
            if (idx < 0 || idx >= h.getTagCount()) {
                throw new ProgException(ExceptionType.EXCEPT_INVALIDMACHINE_INDEX);
            }
            return h.getData(idx, 0L);
        }).orElseThrow(() -> new ProgException(ExceptionType.EXCEPT_INVALIDMACHINE));
    }

    public int getEnergy(Inventory side) {
        TileEntity te = this.getTileEntityAt((BlockSide)side);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return (Integer)te.getCapability(CapabilityEnergy.ENERGY, side.getIntSide()).map(IEnergyStorage::getEnergyStored).orElseThrow(() -> new ProgException(ExceptionType.EXCEPT_NORF));
    }

    public int getMaxEnergy(Inventory side) {
        TileEntity te = this.getTileEntityAt((BlockSide)side);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return (Integer)te.getCapability(CapabilityEnergy.ENERGY, side.getIntSide()).map(IEnergyStorage::getMaxEnergyStored).orElseThrow(() -> new ProgException(ExceptionType.EXCEPT_NORF));
    }

    public long getEnergyLong(Inventory side) {
        TileEntity te = this.getTileEntityAt((BlockSide)side);
        EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevelMulti((TileEntity)te, null);
        if (level.getMaxEnergy() >= 0L) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return level.getEnergy();
    }

    public long getMaxEnergyLong(Inventory side) {
        TileEntity te = this.getTileEntityAt((BlockSide)side);
        EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevelMulti((TileEntity)te, null);
        if (level.getMaxEnergy() >= 0L) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return level.getMaxEnergy();
    }

    public int getLiquid(@Nonnull Inventory side) {
        return this.getFluidHandlerAt(side).map(handler -> {
            FluidStack contents;
            if (handler.getTanks() > 0 && !(contents = handler.getFluidInTank(0)).isEmpty()) {
                return contents.getAmount();
            }
            return 0;
        }).orElse(0);
    }

    public int getMaxLiquid(@Nonnull Inventory side) {
        return this.getFluidHandlerAt(side).map(handler -> {
            if (handler.getTanks() > 0) {
                return handler.getTankCapacity(0);
            }
            return 0;
        }).orElse(0);
    }

    private IStorageScanner getScannerForInv(@Nullable Inventory inv) {
        if (inv == null) {
            return this.getStorageScanner();
        }
        return null;
    }

    private LazyOptional<IItemHandler> getHandlerForInv(@Nullable Inventory inv) {
        if (inv == null) {
            return LazyOptional.empty();
        }
        return this.getItemHandlerAt(inv);
    }

    public boolean compareNBTTag(@Nonnull ItemStack v1, @Nonnull ItemStack v2, @Nonnull String tag) {
        INBT tag2;
        if (!v1.func_77942_o() || !v2.func_77942_o()) {
            return v1.func_77942_o() == v2.func_77942_o();
        }
        INBT tag1 = v1.func_77978_p().func_74781_a(tag);
        if (tag1 == (tag2 = v2.func_77978_p().func_74781_a(tag))) {
            return true;
        }
        if (tag1 != null) {
            return tag1.equals(tag2);
        }
        return false;
    }

    private MultiTankFluidProperties getFluidPropertiesFromMultiTank(Direction side, int idx) {
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
        if (te instanceof MultiTankTileEntity) {
            MultiTankTileEntity mtank = (MultiTankTileEntity)te;
            return mtank.getProperties()[idx];
        }
        return null;
    }

    @Nonnull
    public FluidStack examineLiquid(@Nonnull Inventory inv, @Nullable Integer slot) {
        if (slot == null) {
            slot = 0;
        }
        Integer finalSlot = slot;
        return this.getFluidHandlerAt(inv).map(handler -> {
            if (finalSlot < handler.getTanks()) {
                return handler.getFluidInTank(finalSlot.intValue());
            }
            return FluidStack.EMPTY;
        }).orElse(FluidStack.EMPTY);
    }

    @Nullable
    public FluidStack examineLiquidInternal(IProgram program, int virtualSlot) {
        int idx;
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealFluidSlot(virtualSlot);
        Direction side = Direction.values()[realSlot / 4];
        MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
        if (properties == null) {
            return null;
        }
        return properties.getContents();
    }

    public int pushLiquid(IProgram program, @Nonnull Inventory inv, int amount, int virtualSlot) {
        return this.getFluidHandlerAt(inv).map(handler -> {
            int idx;
            CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
            int realSlot = info.getRealFluidSlot(virtualSlot);
            Direction side = Direction.values()[realSlot / 4];
            MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
            if (properties == null) {
                return 0;
            }
            if (!properties.hasContents()) {
                return 0;
            }
            int newAmount = Math.min(amount, properties.getContentsInternal().getAmount());
            FluidStack topush = properties.getContents();
            topush.setAmount(newAmount);
            int filled = handler.fill(topush, IFluidHandler.FluidAction.EXECUTE);
            properties.drain(filled);
            return filled;
        }).orElse(0);
    }

    public int fetchLiquid(IProgram program, @Nonnull Inventory inv, int amount, @Nullable FluidStack fluidStack, int virtualSlot) {
        return this.getFluidHandlerAt(inv).map(handler -> {
            int newAmount;
            int idx;
            CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
            int realSlot = info.getRealFluidSlot(virtualSlot);
            Direction side = Direction.values()[realSlot / 4];
            MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
            if (properties == null) {
                return 0;
            }
            int internalAmount = 0;
            if (properties.hasContents()) {
                if (fluidStack != null && !fluidStack.isFluidEqual(properties.getContentsInternal())) {
                    return 0;
                }
                internalAmount = properties.getContentsInternal().getAmount();
            }
            if (internalAmount + (newAmount = amount) > 10000) {
                newAmount = 10000 - internalAmount;
            }
            if (newAmount <= 0) {
                return 0;
            }
            if (fluidStack == null) {
                FluidStack drained = handler.drain(newAmount, IFluidHandler.FluidAction.SIMULATE);
                if (!drained.isEmpty()) {
                    if (!properties.hasContents() || properties.getContentsInternal().isFluidEqual(drained)) {
                        drained = handler.drain(newAmount, IFluidHandler.FluidAction.EXECUTE);
                        properties.fill(drained);
                        return drained.getAmount();
                    }
                    return 0;
                }
            } else {
                FluidStack todrain = fluidStack.copy();
                todrain.setAmount(newAmount);
                FluidStack drained = handler.drain(todrain, IFluidHandler.FluidAction.EXECUTE);
                if (!drained.isEmpty()) {
                    int drainedAmount = drained.getAmount();
                    if (properties.hasContents()) {
                        drained.setAmount(drained.getAmount() + properties.getContentsInternal().getAmount());
                    }
                    properties.fill(drained);
                    return drainedAmount;
                }
            }
            return 0;
        }).orElse(0);
    }

    public int fetchItemsFilter(IProgram program, Inventory inv, Integer amount, int virtualSlot, int filterIndex) {
        if (amount != null && amount == 0) {
            throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
        }
        Predicate<ItemStack> cache = this.getFilterCache(filterIndex);
        if (cache == null) {
            throw new ProgException(ExceptionType.EXCEPT_UNKNOWN_FILTER);
        }
        return this.getHandlerForInv(inv).map(handler -> {
            CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
            int realSlot = info.getRealSlot(virtualSlot);
            ItemStack stack = LogicInventoryTools.tryExtractItem(handler, amount, cache);
            if (stack.func_190926_b()) {
                return 0;
            }
            GenericItemHandler capability = this.items;
            if (!capability.insertItem(realSlot, stack, true).func_190926_b()) {
                return 0;
            }
            stack = LogicInventoryTools.extractItem(handler, amount, cache);
            capability.insertItem(realSlot, stack, false);
            return stack.func_190916_E();
        }).orElse(0);
    }

    public int fetchItems(IProgram program, Inventory inv, Integer slot, Ingredient itemMatcher, boolean routable, @Nullable Integer amount, int virtualSlot) {
        if (amount != null && amount == 0) {
            throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
        }
        IStorageScanner scanner = this.getScannerForInv(inv);
        return this.getHandlerForInv(inv).map(handler -> {
            CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
            int realSlot = info.getRealSlot(virtualSlot);
            ItemStack stack = LogicInventoryTools.tryExtractItem(handler, scanner, amount, routable, itemMatcher, slot);
            if (stack.func_190926_b()) {
                return 0;
            }
            GenericItemHandler capability = this.items;
            if (!capability.insertItem(realSlot, stack, true).func_190926_b()) {
                return 0;
            }
            stack = LogicInventoryTools.extractItem(handler, scanner, amount, routable, itemMatcher, slot);
            capability.insertItem(realSlot, stack, false);
            return stack.func_190916_E();
        }).orElse(0);
    }

    @Nullable
    public ItemStack getItemInternal(IProgram program, int virtualSlot) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(virtualSlot);
        return this.items.getStackInSlot(realSlot);
    }

    public int pushItems(IProgram program, Inventory inv, Integer slot, @Nullable Integer amount, int virtualSlot) {
        IStorageScanner scanner = this.getScannerForInv(inv);
        return this.getHandlerForInv(inv).map(handler -> {
            GenericItemHandler itemHandler = this.items;
            CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
            int realSlot = info.getRealSlot(virtualSlot);
            ItemStack extracted = itemHandler.extractItem(realSlot, amount == null ? 64 : amount, false);
            if (extracted.func_190926_b()) {
                return 0;
            }
            ItemStack remaining = LogicInventoryTools.insertItem(handler, scanner, extracted, slot);
            if (!remaining.func_190926_b()) {
                itemHandler.insertItem(realSlot, remaining, false);
                return extracted.func_190916_E() - remaining.func_190916_E();
            }
            return extracted.func_190916_E();
        }).orElse(0);
    }

    public void sendMessage(IProgram program, int idSlot, String messageName, @Nullable Integer variableSlot) {
        BlockPos dest;
        if (!this.hasNetworkCard()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
        }
        if (this.hasNetworkCard != 1) {
            throw new ProgException(ExceptionType.EXCEPT_NEEDSADVANCEDNETWORK);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realIdSlot = info.getRealSlot(idSlot);
        Integer realVariable = info.getRealVar(variableSlot);
        ItemStack idCard = this.items.getStackInSlot(realIdSlot);
        if (idCard.func_190926_b() || !(idCard.func_77973_b() instanceof NetworkIdentifierItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTANIDENTIFIER);
        }
        CompoundNBT tagCompound = idCard.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("monitorx")) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        String monitordim = tagCompound.func_74779_i("monitordim");
        int monitorx = tagCompound.func_74762_e("monitorx");
        int monitory = tagCompound.func_74762_e("monitory");
        int monitorz = tagCompound.func_74762_e("monitorz");
        ServerWorld world = LevelTools.getLevel((RegistryKey)LevelTools.getId((String)monitordim));
        if (!LevelTools.isLoaded((World)world, (BlockPos)(dest = new BlockPos(monitorx, monitory, monitorz)))) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        TileEntity te = world.func_175625_s(dest);
        if (!(te instanceof ProcessorTileEntity)) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        ProcessorTileEntity destTE = (ProcessorTileEntity)te;
        destTE.receiveMessage(messageName, realVariable == null ? null : this.getVariableArray()[realVariable]);
    }

    private void setOp(String id, GfxOp op) {
        if (!this.hasGraphicsCard()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGGRAPHICSCARD);
        }
        if (!this.gfxOps.containsKey(id)) {
            if (this.gfxOps.size() >= (Integer)Config.maxGraphicsOpcodes.get()) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
            }
            this.orderedOps = null;
        }
        this.gfxOps.put(id, op);
        this.func_70296_d();
    }

    private void sortOps() {
        this.orderedOps = new ArrayList<String>(this.gfxOps.keySet());
        this.orderedOps.sort(String::compareTo);
    }

    public void gfxDrawBox(IProgram program, String id, int x, int y, int w, int h, int color) {
        this.setOp(id, new GfxOpBox(x, y, w, h, color));
    }

    public void gfxDrawLine(IProgram program, String id, int x1, int y1, int x2, int y2, int color) {
        this.setOp(id, new GfxOpLine(x1, y1, x2, y2, color));
    }

    public void gfxDrawText(IProgram program, String id, int x, int y, String text, int color) {
        this.setOp(id, new GfxOpText(x, y, text, color));
    }

    public void gfxDrawBox(IProgram program, String id, @Nonnull Tuple loc, @Nonnull Tuple size, int color) {
        this.setOp(id, new GfxOpBox(loc.getX(), loc.getY(), size.getX(), size.getY(), color));
    }

    public void gfxDrawLine(IProgram program, String id, @Nonnull Tuple pos1, @Nonnull Tuple pos2, int color) {
        this.setOp(id, new GfxOpLine(pos1.getX(), pos1.getY(), pos2.getX(), pos2.getY(), color));
    }

    public void gfxDrawText(IProgram program, String id, @Nonnull Tuple pos, String text, int color) {
        this.setOp(id, new GfxOpText(pos.getX(), pos.getY(), text, color));
    }

    public void gfxClear(IProgram program, @Nullable String id) {
        if (id == null || id.isEmpty()) {
            this.gfxOps.clear();
            this.orderedOps = null;
        } else {
            this.gfxOps.remove(id);
            this.orderedOps = null;
        }
        this.func_70296_d();
    }

    public Map<String, GfxOp> getGfxOps() {
        return this.gfxOps;
    }

    public List<String> getOrderedOps() {
        if (this.orderedOps == null) {
            this.sortOps();
        }
        return this.orderedOps;
    }

    public void setClientOrderedGfx(Map<String, GfxOp> gfxOps, List<String> orderedOps) {
        this.clientGfxOps.clear();
        for (String key : orderedOps) {
            this.clientGfxOps.add(gfxOps.get(key));
        }
    }

    public List<GfxOp> getClientGfxOps() {
        return this.clientGfxOps;
    }

    public boolean testWithFilter(ItemStack item, int idx) {
        Predicate<ItemStack> filterCache = this.getFilterCache(idx);
        if (filterCache == null) {
            throw new ProgException(ExceptionType.EXCEPT_UNKNOWN_FILTER);
        }
        return filterCache.test(item);
    }

    private List<Predicate<ItemStack>> getFilterCaches() {
        ArrayList<Predicate<ItemStack>> caches = new ArrayList<Predicate<ItemStack>>();
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof FilterModuleItem)) continue;
            caches.add(FilterModuleItem.getCache((ItemStack)stack));
        }
        return caches;
    }

    @Nullable
    private Predicate<ItemStack> getFilterCache(int index) {
        if (index < ((List)this.filterCaches.get()).size()) {
            return (Predicate)((List)this.filterCaches.get()).get(index);
        }
        return null;
    }

    public int getMaxvars() {
        if (this.maxVars == -1) {
            this.maxVars = 0;
            this.hasNetworkCard = -1;
            this.hasGraphicsCard = false;
            this.storageCard = -1;
            Item storageCardItem = RFToolsStuff.STORAGE_CONTROL_MODULE;
            for (int i = 0; i < 16; ++i) {
                ItemStack stack = this.items.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() instanceof NetworkCardItem) {
                    this.hasNetworkCard = ((NetworkCardItem)stack.func_77973_b()).getTier();
                    continue;
                }
                if (stack.func_77973_b() instanceof RAMChipItem) {
                    this.maxVars += 8;
                    continue;
                }
                if (stack.func_77973_b() instanceof GraphicsCardItem) {
                    this.hasGraphicsCard = true;
                    continue;
                }
                if (stack.func_77973_b() != storageCardItem) continue;
                this.storageCard = i;
            }
            if (this.maxVars >= 32) {
                this.maxVars = 32;
            }
            this.updateFluidSlotsAvailability();
        }
        return this.maxVars;
    }

    public void markFluidSlotsDirty() {
        this.fluidSlotsAvailable = -1;
    }

    private void updateFluidSlotsAvailability() {
        this.fluidSlotsAvailable = 0;
        for (Direction facing : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing));
            if (!(te instanceof MultiTankTileEntity)) continue;
            this.fluidSlotsAvailable |= 1 << facing.ordinal();
        }
        this.fixCardInfoForSlotAvailability();
        this.func_70296_d();
    }

    private void fixCardInfoForSlotAvailability() {
        for (CardInfo info : this.cardInfo) {
            int alloc = info.getFluidAllocation();
            for (int i = 0; i < 24; ++i) {
                if ((this.fluidSlotsAvailable & 1 << i / 4) != 0) continue;
                alloc &= ~(1 << i);
            }
            info.setFluidAllocation(alloc);
        }
    }

    public boolean hasGraphicsCard() {
        if (this.maxVars == -1) {
            this.getMaxvars();
        }
        return this.hasGraphicsCard;
    }

    public boolean hasNetworkCard() {
        if (this.maxVars == -1) {
            this.getMaxvars();
        }
        return this.hasNetworkCard != -1;
    }

    public int getStorageCard() {
        if (this.storageCard == -2) {
            this.getMaxvars();
        }
        return this.storageCard;
    }

    public String getChannelName() {
        return this.channel;
    }

    public int getNodeCount() {
        return this.networkNodes.size();
    }

    public void stopOrResume(IProgram program) {
        ((RunningProgram)program).popLoopStack(this);
    }

    public boolean testGreater(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        Parameter lastValue = (Parameter)program.getLastValue();
        Parameter varValue = this.variables[realVar];
        if (lastValue == null) {
            return varValue == null;
        }
        if (varValue == null) {
            return false;
        }
        if (lastValue.getParameterType() != varValue.getParameterType()) {
            return false;
        }
        return ParameterTools.compare(lastValue, varValue) > 0;
    }

    public boolean testEquality(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        Parameter lastValue = (Parameter)program.getLastValue();
        Parameter varValue = this.variables[realVar];
        if (lastValue == null) {
            return varValue == null;
        }
        if (varValue == null) {
            return false;
        }
        if (lastValue.getParameterType() != varValue.getParameterType()) {
            return false;
        }
        Object v1 = lastValue.getParameterValue().getValue();
        Object v2 = varValue.getParameterValue().getValue();
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        if (varValue.getParameterType() == ParameterType.PAR_ITEM) {
            return ((ItemStack)v1).func_77969_a((ItemStack)v2);
        }
        if (varValue.getParameterType() == ParameterType.PAR_FLUID) {
            return ((FluidStack)v1).isFluidEqual((FluidStack)v2);
        }
        if (varValue.getParameterType() == ParameterType.PAR_VECTOR) {
            return ParameterTools.compare(lastValue, varValue) == 0;
        }
        return v1.equals(v2);
    }

    private int getRealVarSafe(int var, CardInfo info) {
        int realVar = info.getRealVar(var);
        if (realVar == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGVARIABLE);
        }
        if (realVar >= this.getMaxvars()) {
            throw new ProgException(ExceptionType.EXCEPT_NOTENOUGHVARIABLES);
        }
        return realVar;
    }

    public void handleCall(IProgram program, String signal) {
        RunningProgram p = (RunningProgram)program;
        CardInfo info = this.cardInfo[p.getCardIndex()];
        CompiledCard compiledCard = info.getCompiledCard();
        if (compiledCard != null) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_SIGNAL)) {
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String sig = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!signal.equals(sig)) continue;
                p.pushCall(p.getCurrentOpcode(this).getPrimaryIndex());
                p.setCurrent(event.getIndex());
                return;
            }
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGSIGNAL);
    }

    public IOpcodeRunnable.OpcodeResult handleLoop(IProgram program, int varIdx, int end) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(varIdx, info);
        Parameter parameter = this.getVariableArray()[realVar];
        int i = TypeConverters.convertToInt(parameter);
        if (i > end) {
            return IOpcodeRunnable.OpcodeResult.NEGATIVE;
        }
        ((RunningProgram)program).pushLoopStack(realVar);
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }

    public void setValueInToken(IProgram program, int slot) {
        Parameter lastValue;
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(slot);
        ItemStack stack = this.items.getStackInSlot(realSlot);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof TokenItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTATOKEN);
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        if ((lastValue = (Parameter)program.getLastValue()) == null) {
            stack.func_77978_p().func_82580_o("parameter");
        } else {
            CompoundNBT tag = ParameterTools.writeToNBT(lastValue);
            stack.func_77978_p().func_218657_a("parameter", (INBT)tag);
        }
    }

    @Nullable
    public Parameter getParameterFromToken(IProgram program, int slot) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(slot);
        ItemStack stack = this.items.getStackInSlot(realSlot);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof TokenItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTATOKEN);
        }
        if (!stack.func_77942_o()) {
            return null;
        }
        CompoundNBT tag = stack.func_77978_p().func_74775_l("parameter");
        if (tag.isEmpty()) {
            return null;
        }
        return ParameterTools.readFromNBT(tag);
    }

    public void setVariable(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        this.setVariableInternal(program, realVar, (Parameter)program.getLastValue());
    }

    public void setVariableInternal(IProgram program, int realVar, Parameter value) {
        Parameter oldValue;
        if (this.watchInfos[realVar] != null && this.isWatchTriggered(oldValue = this.variables[realVar], value)) {
            this.log(TextFormatting.BLUE + "W" + realVar + ": " + TypeConverters.convertToString(value));
            if (this.watchInfos[realVar].isBreakOnChange()) {
                CpuCore core = ((RunningProgram)program).getCore();
                core.setDebug(true);
            }
        }
        this.variables[realVar] = value;
    }

    private boolean isWatchTriggered(Parameter old, Parameter value) {
        if (old == value) {
            return false;
        }
        if (old == null) {
            return true;
        }
        if (value == null) {
            return true;
        }
        return value.compareTo(old) != 0;
    }

    public IParameter getVariable(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        return this.variables[realVar];
    }

    @Nullable
    public <T> T evaluateGenericParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex, BiFunction<ParameterType, Object, T> convertor) {
        List parameters = compiledOpcode.getParameters();
        if (parIndex >= parameters.size()) {
            return null;
        }
        IParameter parameter = (IParameter)parameters.get(parIndex);
        ParameterValue value = parameter.getParameterValue();
        if (value.isConstant()) {
            return convertor.apply(parameter.getParameterType(), value.getValue());
        }
        if (value.isFunction()) {
            Function function = value.getFunction();
            Object v = function.getFunctionRunnable().run((IProcessor)this, program);
            return convertor.apply(function.getReturnType(), v);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(value.getVariableIndex(), info);
        Parameter par = this.variables[realVar];
        if (par == null || par.getParameterValue() == null) {
            return null;
        }
        return convertor.apply(par.getParameterType(), par.getParameterValue().getValue());
    }

    @Nonnull
    public <T> T evaluateGenericParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex, BiFunction<ParameterType, Object, T> convertor) {
        T rc = this.evaluateGenericParameter(compiledOpcode, program, parIndex, convertor);
        if (rc == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGPARAMETER);
        }
        return rc;
    }

    @Nonnull
    public <T> T evaluateParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return (T)this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, (type, value) -> value);
    }

    @Nullable
    public <T> T evaluateParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return (T)this.evaluateGenericParameter(compiledOpcode, program, parIndex, (type, value) -> value);
    }

    @Nullable
    public Tuple evaluateTupleParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_TUPLE);
    }

    @Nonnull
    public Tuple evaluateTupleParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_TUPLE);
    }

    @Nullable
    public List<IParameter> evaluateVectorParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        List<Parameter> parameters = this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_VECTOR);
        if (parameters == null) {
            return null;
        }
        return parameters.stream().map(p -> p).collect(Collectors.toList());
    }

    @Nonnull
    public List<IParameter> evaluateVectorParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        List<Parameter> parameters = this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_VECTOR);
        return parameters.stream().map(p -> p).collect(Collectors.toList());
    }

    @Nullable
    public ItemStack evaluateItemParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        ItemStack stack = this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_ITEM);
        if (stack == null) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Nonnull
    public ItemStack evaluateItemParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        ItemStack stack = this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_ITEM);
        if (stack.func_190926_b()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGPARAMETER);
        }
        return stack;
    }

    @Nullable
    public FluidStack evaluateFluidParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_FLUID);
    }

    @Nonnull
    public FluidStack evaluateFluidParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_FLUID);
    }

    @Nullable
    public BlockSide evaluateSideParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_SIDE);
    }

    @Nonnull
    public BlockSide evaluateSideParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_SIDE);
    }

    @Nullable
    public Inventory evaluateInventoryParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_INVENTORY);
    }

    @Nonnull
    public Inventory evaluateInventoryParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_INVENTORY);
    }

    public int evaluateIntParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Integer value = this.evaluateIntegerParameter(compiledOpcode, program, parIndex);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public long evaluateLngParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Long value = this.evaluateLongParameter(compiledOpcode, program, parIndex);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    @Nullable
    public Integer evaluateIntegerParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_INTEGER);
    }

    @Nullable
    public Long evaluateLongParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_LONG);
    }

    @Nullable
    public Number evaluateNumberParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_NUMBER);
    }

    @Nullable
    public String evaluateStringParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_STRING);
    }

    @Nonnull
    public String evaluateStringParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_STRING);
    }

    public boolean evaluateBoolParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Boolean rc = this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_BOOL);
        if (rc == null) {
            return false;
        }
        return rc;
    }

    public int countItemStorage(ItemStack stack, boolean routable) {
        IStorageScanner scanner = this.getStorageScanner();
        return scanner.countItems(stack, routable);
    }

    private IStorageScanner getStorageScanner() {
        int card = this.getStorageCard();
        if (card == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGECARD);
        }
        ItemStack storageStack = this.items.getStackInSlot(card);
        if (!storageStack.func_77942_o()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGECARD);
        }
        CompoundNBT tagCompound = storageStack.func_77978_p();
        BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
        String dim = tagCompound.func_74779_i("monitordim");
        ServerWorld world = LevelTools.getLevel((RegistryKey)LevelTools.getId((String)dim));
        if (world == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        if (!LevelTools.isLoaded((World)world, (BlockPos)c)) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        TileEntity te = world.func_175625_s(c);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        if (!(te instanceof IStorageScanner)) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        return (IStorageScanner)te;
    }

    public int countSlots(Inventory inv, IProgram program) {
        return this.getItemHandlerAt(inv).map(IItemHandler::getSlots).orElse(0);
    }

    public int countItem(Inventory inv, Integer slot, ItemStack itemMatcher, boolean routable, IProgram program) {
        if (inv == null) {
            return this.countItemStorage(itemMatcher, routable);
        }
        return this.getItemHandlerAt(inv).map(handler -> {
            if (slot != null) {
                ItemStack stackInSlot = handler.getStackInSlot(slot.intValue());
                if (stackInSlot.func_190926_b()) {
                    return 0;
                }
                if (!itemMatcher.func_190926_b() && !ItemStack.func_179545_c((ItemStack)stackInSlot, (ItemStack)itemMatcher)) {
                    return 0;
                }
                return stackInSlot.func_190916_E();
            }
            if (!itemMatcher.func_190926_b()) {
                return this.countItemInHandler(itemMatcher, (IItemHandler)handler);
            }
            int cnt = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                cnt += stack.func_190916_E();
            }
            return cnt;
        }).orElse(0);
    }

    private int countItemInHandler(ItemStack itemMatcher, IItemHandler handler) {
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemMatcher)) continue;
            cnt += stack.func_190916_E();
        }
        return cnt;
    }

    @Nullable
    public TileEntity getTileEntityAt(@Nullable BlockSide inv) {
        BlockPos np = this.getPositionAt(inv);
        if (np == null) {
            return null;
        }
        return this.field_145850_b.func_175625_s(np);
    }

    @Nullable
    public BlockPos getPositionAt(@Nullable BlockSide inv) {
        if (inv == null) {
            return null;
        }
        BlockPos p = this.field_174879_c;
        if (inv.hasNodeName()) {
            if (!this.hasNetworkCard()) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
            }
            p = this.networkNodes.get(inv.getNodeName());
            if (p == null) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
        }
        if (inv.getSide() == null) {
            return p;
        }
        return p.func_177972_a(inv.getSide());
    }

    @Nonnull
    public LazyOptional<IFluidHandler> getFluidHandlerAt(@Nonnull Inventory inv) {
        TileEntity te = this.getTileEntityAt((BlockSide)inv);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_NOLIQUID);
        }
        LazyOptional capability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, inv.getIntSide());
        if (!capability.isPresent()) {
            throw new ProgException(ExceptionType.EXCEPT_NOLIQUID);
        }
        return capability;
    }

    @Nonnull
    public LazyOptional<IItemHandler> getItemHandlerAt(@Nonnull Inventory inv) {
        Direction intSide = inv.getIntSide();
        TileEntity te = this.getTileEntityAt((BlockSide)inv);
        return this.getItemHandlerAt(te, intSide);
    }

    private LazyOptional<IItemHandler> getItemHandlerAt(@Nonnull TileEntity te, Direction intSide) {
        LazyOptional capability = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, intSide);
        if (!capability.isPresent()) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
        }
        return capability;
    }

    private boolean isExpansionSlot(int index) {
        return index >= 0 && index < 16;
    }

    private boolean isCardSlot(int index) {
        return index >= 16 && index < 22;
    }

    private void removeCard(int index) {
        this.cardInfo[index].setCompiledCard(null);
        this.stopPrograms(index);
        ArrayDeque<QueuedEvent> newQueue = new ArrayDeque<QueuedEvent>();
        for (QueuedEvent event : this.eventQueue) {
            if (event.getCardIndex() == index) continue;
            newQueue.add(event);
        }
        this.eventQueue = newQueue;
    }

    private void stopPrograms(int cardIndex) {
        for (CpuCore core : this.cpuCores) {
            if (!core.hasProgram() || core.getProgram().getCardIndex() != cardIndex) continue;
            core.stopProgram();
        }
        HashSet<Pair<Integer, Integer>> newRunningEvents = new HashSet<Pair<Integer, Integer>>();
        for (Pair<Integer, Integer> pair : this.runningEvents) {
            if ((Integer)pair.getLeft() == cardIndex) continue;
            newRunningEvents.add(pair);
        }
        this.runningEvents = newRunningEvents;
    }

    private void clearExpansions() {
        this.coresDirty = true;
        this.maxVars = -1;
        this.storageCard = -2;
        this.hasNetworkCard = -1;
        this.filterCaches.clear();
    }

    public int getShowHud() {
        return this.showHud;
    }

    public void setShowHud(int showHud) {
        this.showHud = showHud;
        this.markDirtyClient();
    }

    public void loadClientDataFromNBT(CompoundNBT tagCompound) {
        this.exclusive = tagCompound.func_74767_n("exclusive");
        this.showHud = tagCompound.func_74771_c("hud");
        this.readCardInfo(tagCompound);
    }

    public void saveClientDataToNBT(CompoundNBT tagCompound) {
        tagCompound.func_74757_a("exclusive", this.exclusive);
        tagCompound.func_74774_a("hud", (byte)this.showHud);
        this.writeCardInfo(tagCompound);
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.prevIn = tagCompound.func_74762_e("prevIn");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.func_74771_c("p" + i);
        }
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        tagCompound.func_74768_a("prevIn", this.prevIn);
        for (int i = 0; i < 6; ++i) {
            tagCompound.func_74774_a("p" + i, (byte)this.powerOut[i]);
        }
    }

    protected void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.tickCount = info.func_74762_e("tickCount");
        this.channel = info.func_74779_i("channel");
        this.exclusive = info.func_74767_n("exclusive");
        this.showHud = info.func_74771_c("hud");
        if (info.func_74764_b("lastExc")) {
            this.lastException = info.func_74779_i("lastExc");
            this.lastExceptionTime = info.func_74763_f("lastExcT");
        } else {
            this.lastException = null;
            this.lastExceptionTime = 0L;
        }
        this.readCardInfo(info);
        this.readCores(info);
        this.readEventQueue(info);
        this.readLog(info);
        this.readVariables(info);
        this.readNetworkNodes(info);
        this.readCraftingStations(info);
        this.readWaitingForItems(info);
        this.readLocks(info);
        this.readRunningEvents(info);
        this.readGraphicsOperations(info);
    }

    private void readGraphicsOperations(CompoundNBT tagCompound) {
        this.gfxOps.clear();
        CompoundNBT opTag = tagCompound.func_74775_l("gfxop");
        for (String key : opTag.func_150296_c()) {
            this.gfxOps.put(key, GfxOp.readFromNBT(opTag.func_74775_l(key)));
        }
        this.sortOps();
    }

    private void readRunningEvents(CompoundNBT tagCompound) {
        this.runningEvents.clear();
        ListNBT evList = tagCompound.func_150295_c("singev", 10);
        for (int i = 0; i < evList.size(); ++i) {
            CompoundNBT tag = evList.func_150305_b(i);
            int cardIndex = tag.func_74762_e("card");
            int eventIndex = tag.func_74762_e("event");
            this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)eventIndex));
        }
    }

    private void readLocks(CompoundNBT tagCompound) {
        this.locks.clear();
        ListNBT lockList = tagCompound.func_150295_c("locks", 8);
        for (int i = 0; i < lockList.size(); ++i) {
            String name = lockList.func_150307_f(i);
            this.locks.add(name);
        }
    }

    private void readWaitingForItems(CompoundNBT tagCompound) {
        this.waitingForItems.clear();
        ListNBT waitingList = tagCompound.func_150295_c("waiting", 10);
        for (int i = 0; i < waitingList.size(); ++i) {
            CompoundNBT tag = waitingList.func_150305_b(i);
            String ticket = tag.func_74779_i("ticket");
            ItemStack stack = tag.func_74764_b("item") ? ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("item")) : ItemStack.field_190927_a;
            Inventory inventory = tag.func_74764_b("inv") ? InventoryUtil.readFromNBT(tag.func_74775_l("inv")) : null;
            WaitForItem waitForItem = new WaitForItem(ticket, stack, inventory);
            this.waitingForItems.add(waitForItem);
        }
    }

    private void readCraftingStations(CompoundNBT tagCompound) {
        this.craftingStations.clear();
        ListNBT stationList = tagCompound.func_150295_c("stations", 10);
        for (int i = 0; i < stationList.size(); ++i) {
            CompoundNBT tag = stationList.func_150305_b(i);
            BlockPos nodePos = new BlockPos(tag.func_74762_e("nodex"), tag.func_74762_e("nodey"), tag.func_74762_e("nodez"));
            this.craftingStations.add(nodePos);
        }
    }

    private void readNetworkNodes(CompoundNBT tagCompound) {
        this.networkNodes.clear();
        ListNBT networkList = tagCompound.func_150295_c("nodes", 10);
        for (int i = 0; i < networkList.size(); ++i) {
            CompoundNBT tag = networkList.func_150305_b(i);
            String name = tag.func_74779_i("name");
            BlockPos nodePos = new BlockPos(tag.func_74762_e("nodex"), tag.func_74762_e("nodey"), tag.func_74762_e("nodez"));
            this.networkNodes.put(name, nodePos);
        }
    }

    private void readVariables(CompoundNBT tagCompound) {
        for (int i = 0; i < 32; ++i) {
            this.variables[i] = null;
            this.watchInfos[i] = null;
        }
        ListNBT varList = tagCompound.func_150295_c("vars", 10);
        for (int i = 0; i < varList.size(); ++i) {
            WatchInfo info;
            CompoundNBT var = varList.func_150305_b(i);
            int index = var.func_74762_e("varidx");
            this.variables[index] = ParameterTools.readFromNBT(var);
            if (!var.func_74764_b("watch")) continue;
            this.watchInfos[index] = info = new WatchInfo(var.func_74767_n("watch"));
        }
    }

    private void readLog(CompoundNBT tagCompound) {
        this.logMessages.clear();
        ListNBT logList = tagCompound.func_150295_c("log", 8);
        for (int i = 0; i < logList.size(); ++i) {
            this.logMessages.add(logList.func_150307_f(i));
        }
    }

    private void readCores(CompoundNBT tagCompound) {
        ListNBT coreList = tagCompound.func_150295_c("cores", 10);
        this.cpuCores.clear();
        this.coresDirty = false;
        for (int i = 0; i < coreList.size(); ++i) {
            CpuCore core = new CpuCore();
            core.readFromNBT(coreList.func_150305_b(i));
            this.cpuCores.add(core);
        }
        if (this.cpuCores.isEmpty()) {
            this.coresDirty = true;
        }
    }

    private void readEventQueue(CompoundNBT tagCompound) {
        this.eventQueue.clear();
        ListNBT eventQueueList = tagCompound.func_150295_c("events", 10);
        for (int i = 0; i < eventQueueList.size(); ++i) {
            CompoundNBT tag = eventQueueList.func_150305_b(i);
            int card = tag.func_74762_e("card");
            int index = tag.func_74762_e("index");
            boolean single = tag.func_74767_n("single");
            String ticket = tag.func_74764_b("ticket") ? tag.func_74779_i("ticket") : null;
            Parameter parameter = null;
            if (tag.func_74764_b("parameter")) {
                parameter = ParameterTools.readFromNBT(tag.func_74775_l("parameter"));
            }
            this.eventQueue.add(new QueuedEvent(card, new CompiledEvent(index, single), ticket, parameter));
        }
    }

    private void readCardInfo(CompoundNBT tagCompound) {
        ListNBT cardInfoList = tagCompound.func_150295_c("cardInfo", 10);
        for (int i = 0; i < cardInfoList.size(); ++i) {
            this.cardInfo[i] = CardInfo.readFromNBT(cardInfoList.func_150305_b(i));
        }
    }

    protected void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("tickCount", this.tickCount);
        info.func_74778_a("channel", this.channel == null ? "" : this.channel);
        info.func_74757_a("exclusive", this.exclusive);
        info.func_74774_a("hud", (byte)this.showHud);
        if (this.lastException != null) {
            info.func_74778_a("lastExc", this.lastException);
            info.func_74772_a("lastExcT", this.lastExceptionTime);
        }
        this.writeCardInfo(info);
        this.writeCores(info);
        this.writeEventQueue(info);
        this.writeLog(info);
        this.writeVariables(info);
        this.writeNetworkNodes(info);
        this.writeCraftingStations(info);
        this.writeWaitingForItems(info);
        this.writeLocks(info);
        this.writeRunningEvents(info);
        this.writeGraphicsOperation(info);
    }

    private void writeGraphicsOperation(CompoundNBT tagCompound) {
        CompoundNBT opTag = new CompoundNBT();
        for (Map.Entry<String, GfxOp> entry : this.gfxOps.entrySet()) {
            opTag.func_218657_a(entry.getKey(), (INBT)entry.getValue().writeToNBT());
        }
        tagCompound.func_218657_a("gfxop", (INBT)opTag);
    }

    private void writeRunningEvents(CompoundNBT tagCompound) {
        ListNBT evList = new ListNBT();
        for (Pair<Integer, Integer> pair : this.runningEvents) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("card", ((Integer)pair.getLeft()).intValue());
            tag.func_74768_a("event", ((Integer)pair.getRight()).intValue());
            evList.add((Object)tag);
        }
        tagCompound.func_218657_a("singev", (INBT)evList);
    }

    private void writeLocks(CompoundNBT tagCompound) {
        ListNBT lockList = new ListNBT();
        for (String name : this.locks) {
            lockList.add((Object)StringNBT.func_229705_a_((String)name));
        }
        tagCompound.func_218657_a("locks", (INBT)lockList);
    }

    private void writeWaitingForItems(CompoundNBT tagCompound) {
        ListNBT waitingList = new ListNBT();
        for (WaitForItem waitingForItem : this.waitingForItems) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("ticket", waitingForItem.getTicket());
            if (waitingForItem.getInventory() != null) {
                tag.func_218657_a("inv", (INBT)InventoryUtil.writeToNBT(waitingForItem.getInventory()));
            }
            if (!waitingForItem.getItemStack().func_190926_b()) {
                tag.func_218657_a("item", (INBT)waitingForItem.getItemStack().serializeNBT());
            }
            waitingList.add((Object)tag);
        }
        tagCompound.func_218657_a("waiting", (INBT)waitingList);
    }

    private void writeCraftingStations(CompoundNBT tagCompound) {
        ListNBT stationList = new ListNBT();
        for (BlockPos pos : this.craftingStations) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("nodex", pos.func_177958_n());
            tag.func_74768_a("nodey", pos.func_177956_o());
            tag.func_74768_a("nodez", pos.func_177952_p());
            stationList.add((Object)tag);
        }
        tagCompound.func_218657_a("stations", (INBT)stationList);
    }

    private void writeNetworkNodes(CompoundNBT tagCompound) {
        ListNBT networkList = new ListNBT();
        for (Map.Entry<String, BlockPos> entry : this.networkNodes.entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("name", entry.getKey());
            tag.func_74768_a("nodex", entry.getValue().func_177958_n());
            tag.func_74768_a("nodey", entry.getValue().func_177956_o());
            tag.func_74768_a("nodez", entry.getValue().func_177952_p());
            networkList.add((Object)tag);
        }
        tagCompound.func_218657_a("nodes", (INBT)networkList);
    }

    private void writeVariables(CompoundNBT tagCompound) {
        ListNBT varList = new ListNBT();
        for (int i = 0; i < 32; ++i) {
            if (this.variables[i] == null) continue;
            CompoundNBT var = ParameterTools.writeToNBT(this.variables[i]);
            var.func_74768_a("varidx", i);
            if (this.watchInfos[i] != null) {
                var.func_74757_a("watch", this.watchInfos[i].isBreakOnChange());
            }
            varList.add((Object)var);
        }
        tagCompound.func_218657_a("vars", (INBT)varList);
    }

    private void writeLog(CompoundNBT tagCompound) {
        ListNBT logList = new ListNBT();
        for (String message : this.logMessages) {
            logList.add((Object)StringNBT.func_229705_a_((String)message));
        }
        tagCompound.func_218657_a("log", (INBT)logList);
    }

    private void writeCores(CompoundNBT tagCompound) {
        ListNBT coreList = new ListNBT();
        for (CpuCore core : this.cpuCores) {
            coreList.add((Object)core.writeToNBT());
        }
        tagCompound.func_218657_a("cores", (INBT)coreList);
    }

    private void writeEventQueue(CompoundNBT tagCompound) {
        ListNBT eventQueueList = new ListNBT();
        for (QueuedEvent queuedEvent : this.eventQueue) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("card", queuedEvent.getCardIndex());
            tag.func_74768_a("index", queuedEvent.getCompiledEvent().getIndex());
            tag.func_74757_a("single", queuedEvent.getCompiledEvent().isSingle());
            if (queuedEvent.getTicket() != null) {
                tag.func_74778_a("ticket", queuedEvent.getTicket());
            }
            if (queuedEvent.getParameter() != null) {
                CompoundNBT parTag = ParameterTools.writeToNBT(queuedEvent.getParameter());
                tag.func_218657_a("parameter", (INBT)parTag);
            }
            eventQueueList.add((Object)tag);
        }
        tagCompound.func_218657_a("events", (INBT)eventQueueList);
    }

    private void writeCardInfo(CompoundNBT tagCompound) {
        ListNBT cardInfoList = new ListNBT();
        for (CardInfo info : this.cardInfo) {
            cardInfoList.add((Object)info.writeToNBT());
        }
        tagCompound.func_218657_a("cardInfo", (INBT)cardInfoList);
    }

    public boolean isFluidAllocated(int cardIndex, int fluidIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.cardInfo) {
                int fluidAlloc = info.getFluidAllocation();
                if ((fluidAlloc >> fluidIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int fluidA = info.getFluidAllocation();
        return (fluidA >> fluidIndex & 1) != 0;
    }

    public boolean isVarAllocated(int cardIndex, int varIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.cardInfo) {
                int varAlloc = info.getVarAllocation();
                if ((varAlloc >> varIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int varAlloc = info.getVarAllocation();
        return (varAlloc >> varIndex & 1) != 0;
    }

    public boolean isItemAllocated(int cardIndex, int itemIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.cardInfo) {
                int itemAlloc = info.getItemAllocation();
                if ((itemAlloc >> itemIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int itemAlloc = info.getItemAllocation();
        return (itemAlloc >> itemIndex & 1) != 0;
    }

    public CardInfo getCardInfo(int index) {
        return this.cardInfo[index];
    }

    public CompiledCard getCompiledCard(int index) {
        CardInfo info = this.getCardInfo(index);
        CompiledCard card = info.getCompiledCard();
        ItemStack cardStack = this.items.getStackInSlot(index + 16);
        if (card == null && !cardStack.func_190926_b()) {
            card = CompiledCard.compile(ProgramCardInstance.parseInstance(cardStack));
            this.cardInfo[index].setCompiledCard(card);
        }
        return card;
    }

    private void allocate(int card, int itemAlloc, int varAlloc, int fluidAlloc) {
        this.cardInfo[card].setItemAllocation(itemAlloc);
        this.cardInfo[card].setVarAllocation(varAlloc);
        this.cardInfo[card].setFluidAllocation(fluidAlloc);
        this.func_70296_d();
    }

    public void showNetworkInfo() {
        this.log("Channel: " + this.channel);
        this.log("Nodes: " + this.networkNodes.size());
    }

    public void listNodes() {
        if (this.networkNodes.isEmpty() && this.craftingStations.isEmpty()) {
            this.log("No nodes or crafting stations!");
        } else {
            for (Map.Entry<String, BlockPos> entry : this.networkNodes.entrySet()) {
                this.log(TextFormatting.GREEN + "Node " + TextFormatting.YELLOW + entry.getKey() + TextFormatting.GREEN + " at " + TextFormatting.YELLOW + BlockPosTools.toString((BlockPos)entry.getValue()));
            }
            for (BlockPos station : this.craftingStations) {
                this.log(TextFormatting.GREEN + "Crafting station at " + TextFormatting.YELLOW + BlockPosTools.toString((BlockPos)station));
            }
        }
    }

    public void setupNetwork(String name) {
        this.channel = name;
        this.func_70296_d();
    }

    public void redstoneNodeChange(int previousMask, int newMask, String node) {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            this.handleEventsRedstoneOn(i, compiledCard, node, previousMask, newMask);
            this.handleEventsRedstoneOff(i, compiledCard, node, previousMask, newMask);
        }
    }

    public void scanNodes() {
        if (!this.hasNetworkCard()) {
            this.log(TextFormatting.RED + "No network card!");
            return;
        }
        if (this.channel == null || this.channel.isEmpty()) {
            this.log(TextFormatting.RED + "Setup a channel first!");
            return;
        }
        this.networkNodes.clear();
        this.craftingStations.clear();
        int range = this.hasNetworkCard == 0 ? 8 : 16;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos n = new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z);
                    TileEntity te = this.field_145850_b.func_175625_s(n);
                    if (te instanceof NodeTileEntity) {
                        NodeTileEntity node = (NodeTileEntity)te;
                        if (!this.channel.equals(node.getChannelName())) continue;
                        if (node.getNodeName() == null || node.getNodeName().isEmpty()) {
                            this.log("Node is missing a name!");
                            continue;
                        }
                        this.networkNodes.put(node.getNodeName(), n);
                        node.setProcessor(this.func_174877_v());
                        continue;
                    }
                    if (!(te instanceof CraftingStationTileEntity)) continue;
                    CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
                    craftingStation.registerProcessor(this.field_174879_c);
                    this.craftingStations.add(n);
                }
            }
        }
        this.log("Found " + this.networkNodes.size() + " node(s)");
        this.log("Found " + this.craftingStations.size() + " crafting station(s)");
        this.func_70296_d();
    }

    private boolean isValidExpansionItem(Item item) {
        Item storageCardItem = RFToolsStuff.STORAGE_CONTROL_MODULE;
        return item == ProcessorModule.GRAPHICS_CARD.get() || item == ProcessorModule.NETWORK_CARD.get() || item == ProcessorModule.ADVANCED_NETWORK_CARD.get() || item == ProcessorModule.CPU_CORE_500.get() || item == ProcessorModule.CPU_CORE_1000.get() || item == ProcessorModule.CPU_CORE_2000.get() || item == ProcessorModule.RAM_CHIP.get() || item == storageCardItem || item instanceof FilterModuleItem;
    }

    private void onUpdateCard(int index) {
        if (this.isCardSlot(index)) {
            this.removeCard(index - 16);
            this.cardsDirty = true;
        } else if (this.isExpansionSlot(index)) {
            this.clearExpansions();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        return new AxisAlignedBB((double)xCoord, (double)yCoord, (double)zCoord, (double)(xCoord + 1), (double)(yCoord + 21), (double)(zCoord + 1));
    }

    private static /* synthetic */ Boolean lambda$pushItemsWorkbench$8(ItemStack card, int slot1, int slot2, CardInfo info, IItemHandler itemHandler, IItemHandler gridHandler) {
        List ingredients = CraftingCardItem.getIngredientsGrid((ItemStack)card);
        boolean success = true;
        for (int i = 0; i < 9; ++i) {
            ItemStack stackInWorkbench = gridHandler.getStackInSlot(i);
            Ingredient stackInIngredient = (Ingredient)ingredients.get(i);
            if (!stackInWorkbench.func_190926_b() && stackInIngredient == Ingredient.field_193370_a) {
                success = false;
                continue;
            }
            if (stackInWorkbench.func_190926_b() && stackInIngredient != Ingredient.field_193370_a) {
                boolean found = false;
                for (int slot = slot1; slot <= slot2; ++slot) {
                    int realSlot = info.getRealSlot(slot);
                    ItemStack localStack = itemHandler.getStackInSlot(realSlot);
                    if (!stackInIngredient.test(localStack)) continue;
                    localStack = itemHandler.extractItem(realSlot, LogicInventoryTools.getCountFromIngredient(stackInIngredient), false);
                    gridHandler.insertItem(i, localStack, false);
                    found = true;
                    break;
                }
                if (found) continue;
                success = false;
                continue;
            }
            if (stackInWorkbench.func_190926_b() || stackInIngredient == Ingredient.field_193370_a) continue;
            if (!stackInIngredient.test(stackInWorkbench)) {
                success = false;
                continue;
            }
            if (LogicInventoryTools.getCountFromIngredient(stackInIngredient) <= stackInWorkbench.func_190916_E()) continue;
            success = false;
        }
        return success;
    }
}

