/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.model;

import com.jozufozu.flywheel.backend.gl.buffer.VecBuffer;
import com.jozufozu.flywheel.core.model.ModelPart;
import com.jozufozu.flywheel.util.RenderMath;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;

public class PartBuilder {
    private final float sizeU;
    private final float sizeV;
    private TextureAtlasSprite sprite;
    private final List<CuboidBuilder> cuboids = new ArrayList<CuboidBuilder>();

    public PartBuilder(int sizeU, int sizeV) {
        this.sizeU = sizeU;
        this.sizeV = sizeV;
    }

    public PartBuilder sprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
        return this;
    }

    public CuboidBuilder cuboid() {
        return new CuboidBuilder(this);
    }

    public ModelPart build() {
        return new ModelPart(this.cuboids);
    }

    private PartBuilder addCuboid(CuboidBuilder builder) {
        this.cuboids.add(builder);
        return this;
    }

    public static class CuboidBuilder {
        TextureAtlasSprite sprite;
        Set<Direction> visibleFaces = EnumSet.allOf(Direction.class);
        int textureOffsetU;
        int textureOffsetV;
        float posX1;
        float posY1;
        float posZ1;
        float posX2;
        float posY2;
        float posZ2;
        boolean invertYZ;
        final PartBuilder partBuilder;

        CuboidBuilder(PartBuilder partBuilder) {
            this.partBuilder = partBuilder;
            this.sprite = partBuilder.sprite;
        }

        public CuboidBuilder textureOffset(int u, int v) {
            this.textureOffsetU = u;
            this.textureOffsetV = v;
            return this;
        }

        public CuboidBuilder start(float x, float y, float z) {
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            return this;
        }

        public CuboidBuilder end(float x, float y, float z) {
            this.posX2 = x;
            this.posY2 = y;
            this.posZ2 = z;
            return this;
        }

        public CuboidBuilder size(float x, float y, float z) {
            this.posX2 = this.posX1 + x;
            this.posY2 = this.posY1 + y;
            this.posZ2 = this.posZ1 + z;
            return this;
        }

        public CuboidBuilder sprite(TextureAtlasSprite sprite) {
            this.sprite = sprite;
            return this;
        }

        public CuboidBuilder invertYZ() {
            this.invertYZ = true;
            return this;
        }

        public PartBuilder endCuboid() {
            return this.partBuilder.addCuboid(this);
        }

        public int vertices() {
            return this.visibleFaces.size() * 4;
        }

        public void buffer(VecBuffer buffer) {
            float sizeX = this.posX2 - this.posX1;
            float sizeY = this.posY2 - this.posY1;
            float sizeZ = this.posZ2 - this.posZ1;
            float posX1 = this.posX1 / 16.0f;
            float posY1 = this.posY1 / 16.0f;
            float posZ1 = this.posZ1 / 16.0f;
            float posX2 = this.posX2 / 16.0f;
            float posY2 = this.posY2 / 16.0f;
            float posZ2 = this.posZ2 / 16.0f;
            Vector3f lll = new Vector3f(posX1, posY1, posZ1);
            Vector3f hll = new Vector3f(posX2, posY1, posZ1);
            Vector3f hhl = new Vector3f(posX2, posY2, posZ1);
            Vector3f lhl = new Vector3f(posX1, posY2, posZ1);
            Vector3f llh = new Vector3f(posX1, posY1, posZ2);
            Vector3f hlh = new Vector3f(posX2, posY1, posZ2);
            Vector3f hhh = new Vector3f(posX2, posY2, posZ2);
            Vector3f lhh = new Vector3f(posX1, posY2, posZ2);
            float f4 = this.getU(this.textureOffsetU);
            float f5 = this.getU((float)this.textureOffsetU + sizeZ);
            float f6 = this.getU((float)this.textureOffsetU + sizeZ + sizeX);
            float f7 = this.getU((float)this.textureOffsetU + sizeZ + sizeX + sizeX);
            float f8 = this.getU((float)this.textureOffsetU + sizeZ + sizeX + sizeZ);
            float f9 = this.getU((float)this.textureOffsetU + sizeZ + sizeX + sizeZ + sizeX);
            float f10 = this.getV(this.textureOffsetV);
            float f11 = this.getV((float)this.textureOffsetV + sizeZ);
            float f12 = this.getV((float)this.textureOffsetV + sizeZ + sizeY);
            if (this.invertYZ) {
                this.quad(buffer, new Vector3f[]{hlh, llh, lll, hll}, f6, f11, f7, f10, Direction.DOWN);
                this.quad(buffer, new Vector3f[]{hhl, lhl, lhh, hhh}, f5, f10, f6, f11, Direction.UP);
                this.quad(buffer, new Vector3f[]{lll, llh, lhh, lhl}, f5, f12, f4, f11, Direction.WEST);
                this.quad(buffer, new Vector3f[]{hll, lll, lhl, hhl}, f9, f12, f8, f11, Direction.NORTH);
                this.quad(buffer, new Vector3f[]{hlh, hll, hhl, hhh}, f8, f12, f6, f11, Direction.EAST);
                this.quad(buffer, new Vector3f[]{llh, hlh, hhh, lhh}, f6, f12, f5, f11, Direction.SOUTH);
            } else {
                this.quad(buffer, new Vector3f[]{hlh, llh, lll, hll}, f5, f10, f6, f11, Direction.DOWN);
                this.quad(buffer, new Vector3f[]{hhl, lhl, lhh, hhh}, f6, f11, f7, f10, Direction.UP);
                this.quad(buffer, new Vector3f[]{lll, llh, lhh, lhl}, f4, f11, f5, f12, Direction.WEST);
                this.quad(buffer, new Vector3f[]{hll, lll, lhl, hhl}, f5, f11, f6, f12, Direction.NORTH);
                this.quad(buffer, new Vector3f[]{hlh, hll, hhl, hhh}, f6, f11, f8, f12, Direction.EAST);
                this.quad(buffer, new Vector3f[]{llh, hlh, hhh, lhh}, f8, f11, f9, f12, Direction.SOUTH);
            }
        }

        public void quad(VecBuffer buffer, Vector3f[] vertices, float minU, float minV, float maxU, float maxV, Direction dir) {
            Vector3f normal = dir.func_229386_k_();
            buffer.putVec3(vertices[0].func_195899_a(), vertices[0].func_195900_b(), vertices[0].func_195902_c()).putVec3(RenderMath.nb(normal.func_195899_a()), RenderMath.nb(normal.func_195900_b()), RenderMath.nb(normal.func_195902_c())).putVec2(maxU, minV);
            buffer.putVec3(vertices[1].func_195899_a(), vertices[1].func_195900_b(), vertices[1].func_195902_c()).putVec3(RenderMath.nb(normal.func_195899_a()), RenderMath.nb(normal.func_195900_b()), RenderMath.nb(normal.func_195902_c())).putVec2(minU, minV);
            buffer.putVec3(vertices[2].func_195899_a(), vertices[2].func_195900_b(), vertices[2].func_195902_c()).putVec3(RenderMath.nb(normal.func_195899_a()), RenderMath.nb(normal.func_195900_b()), RenderMath.nb(normal.func_195902_c())).putVec2(minU, maxV);
            buffer.putVec3(vertices[3].func_195899_a(), vertices[3].func_195900_b(), vertices[3].func_195902_c()).putVec3(RenderMath.nb(normal.func_195899_a()), RenderMath.nb(normal.func_195900_b()), RenderMath.nb(normal.func_195902_c())).putVec2(maxU, maxV);
        }

        public float getU(float u) {
            if (this.sprite != null) {
                return this.sprite.func_94214_a((double)(u * 16.0f / this.partBuilder.sizeU));
            }
            return u;
        }

        public float getV(float v) {
            if (this.sprite != null) {
                return this.sprite.func_94207_b((double)(v * 16.0f / this.partBuilder.sizeV));
            }
            return v;
        }
    }
}

