/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.trees.util;

import corgiaoc.byg.common.world.feature.config.BYGTreeConfig;
import corgiaoc.byg.common.world.feature.overworld.trees.util.TreeSpawner;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public abstract class HugeTreeSpawner
extends TreeSpawner {
    public static boolean canBigTreeSpawnAt(BlockState blockUnder, IBlockReader worldIn, BlockPos pos, int xOffset, int zOffset) {
        Block block = blockUnder.func_177230_c();
        return block == worldIn.func_180495_p(pos.func_177982_a(xOffset, 0, zOffset)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset + 1, 0, zOffset)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset, 0, zOffset + 1)).func_177230_c() && block == worldIn.func_180495_p(pos.func_177982_a(xOffset + 1, 0, zOffset + 1)).func_177230_c();
    }

    @Override
    public boolean spawn(ISeedReader worldIn, ChunkGenerator chunkGenerator, BlockPos pos, BlockState blockUnder, Random random) {
        for (int i = 0; i >= -1; --i) {
            for (int j = 0; j >= -1; --j) {
                if (!HugeTreeSpawner.canBigTreeSpawnAt(blockUnder, (IBlockReader)worldIn, pos, i, j)) continue;
                return this.bigTree(worldIn, chunkGenerator, pos, blockUnder, random, i, j);
            }
        }
        return super.spawn(worldIn, chunkGenerator, pos, blockUnder, random);
    }

    @Nullable
    protected abstract ConfiguredFeature<BYGTreeConfig, ?> getBigTreeFeature(Random var1);

    public boolean bigTree(ISeedReader worldIn, ChunkGenerator chunkGenerator, BlockPos pos, BlockState blockUnder, Random random, int xOffset, int zOffset) {
        ConfiguredFeature<BYGTreeConfig, ?> configuredTreeFeature = this.getBigTreeFeature(random);
        if (configuredTreeFeature == null) {
            return false;
        }
        BlockState blockstate = Blocks.field_150350_a.func_176223_P();
        worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset), blockstate, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset), blockstate, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset + 1), blockstate, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset + 1), blockstate, 4);
        ((BYGTreeConfig)configuredTreeFeature.field_222738_b).forcePlacement();
        if (configuredTreeFeature.func_242765_a(worldIn, chunkGenerator, random, pos.func_177982_a(xOffset, 0, zOffset))) {
            return true;
        }
        worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset), blockUnder, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset), blockUnder, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset, 0, zOffset + 1), blockUnder, 4);
        worldIn.func_180501_a(pos.func_177982_a(xOffset + 1, 0, zOffset + 1), blockUnder, 4);
        return false;
    }
}

