/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketAnimEntity {
    int entityID;
    int anim;

    public PacketAnimEntity(int entityID) {
        this.entityID = entityID;
        this.anim = 0;
    }

    public PacketAnimEntity(int entityID, int anim) {
        this.entityID = entityID;
        this.anim = anim;
    }

    public static PacketAnimEntity decode(PacketBuffer buf) {
        return new PacketAnimEntity(buf.readInt(), buf.readInt());
    }

    public static void encode(PacketAnimEntity msg, PacketBuffer buf) {
        buf.writeInt(msg.entityID);
        buf.writeInt(msg.anim);
    }

    public static class Handler {
        public static void handle(final PacketAnimEntity m, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().setPacketHandled(true);
                return;
            }
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    ClientWorld world = mc.field_71441_e;
                    if (world.func_73045_a(m.entityID) instanceof IAnimationListener) {
                        ((IAnimationListener)world.func_73045_a(m.entityID)).startAnimation(m.anim);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

